/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.ValueIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

class FailedIndexProxyTest {
    private final MinimalIndexAccessor minimalIndexAccessor = (MinimalIndexAccessor)Mockito.mock(MinimalIndexAccessor.class);
    private final IndexPopulationFailure indexPopulationFailure = (IndexPopulationFailure)Mockito.mock(IndexPopulationFailure.class);
    private final IndexStatisticsStore indexStatisticsStore = (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class);

    FailedIndexProxyTest() {
    }

    @Test
    void shouldRemoveIndexCountsWhenTheIndexItselfIsDropped() {
        String userDescription = "description";
        ValueIndexProxyStrategy indexProxyStrategy = new ValueIndexProxyStrategy(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{2}), (IndexProviderDescriptor)IndexProviderDescriptor.UNDECIDED).withName(userDescription).materialise(1L), this.indexStatisticsStore, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
        FailedIndexProxy index = new FailedIndexProxy((IndexProxyStrategy)indexProxyStrategy, this.minimalIndexAccessor, this.indexPopulationFailure, (LogProvider)NullLogProvider.getInstance());
        index.drop();
        ((MinimalIndexAccessor)Mockito.verify((Object)this.minimalIndexAccessor)).drop();
        ((IndexStatisticsStore)Mockito.verify((Object)this.indexStatisticsStore)).removeIndex(ArgumentMatchers.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.minimalIndexAccessor, this.indexStatisticsStore});
    }

    @Test
    void shouldLogReasonForDroppingIndex() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        ValueIndexProxyStrategy indexProxyStrategy = new ValueIndexProxyStrategy(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{0}), (IndexProviderDescriptor)IndexProviderDescriptor.UNDECIDED).withName("foo").materialise(1L), this.indexStatisticsStore, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
        new FailedIndexProxy((IndexProxyStrategy)indexProxyStrategy, (MinimalIndexAccessor)Mockito.mock(IndexPopulator.class), IndexPopulationFailure.failure((String)"it broke"), (LogProvider)logProvider).drop();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(FailedIndexProxy.class).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"FailedIndexProxy#drop index on Index( id=1, name='foo', type='GENERAL BTREE', schema=(:Label0 {property0}), indexProvider='Undecided-0' ) dropped due to:\nit broke"});
    }
}

