/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.time.Clock;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.LoggingPhaseTracker;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.NullLog;
import org.neo4j.time.FakeClock;

class LoggingPhaseTrackerTest {
    private FakeClock clock = new FakeClock();

    LoggingPhaseTrackerTest() {
    }

    @Test
    void shouldLogSingleTime() {
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker();
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(100);
        phaseTracker.stop();
        EnumMap times = phaseTracker.times();
        for (Map.Entry phaseEntry : times.entrySet()) {
            LoggingPhaseTracker.Logger logger = (LoggingPhaseTracker.Logger)phaseEntry.getValue();
            if (phaseEntry.getKey() == PhaseTracker.Phase.SCAN) {
                Assertions.assertTrue((logger.totalTime >= 100L ? 1 : 0) != 0);
                Assertions.assertTrue((logger.totalTime < 500L ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertEquals((long)0L, (long)logger.totalTime);
        }
    }

    @Test
    void shouldLogMultipleTimes() {
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker();
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.WRITE);
        this.sleep(100);
        phaseTracker.stop();
        EnumMap times = phaseTracker.times();
        for (Map.Entry phaseEntry : times.entrySet()) {
            LoggingPhaseTracker.Logger logger = (LoggingPhaseTracker.Logger)phaseEntry.getValue();
            PhaseTracker.Phase phase = (PhaseTracker.Phase)phaseEntry.getKey();
            if (phase == PhaseTracker.Phase.SCAN || phase == PhaseTracker.Phase.WRITE) {
                Assertions.assertTrue((logger.totalTime >= 100L ? 1 : 0) != 0);
                Assertions.assertTrue((logger.totalTime < 500L ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertEquals((long)0L, (long)logger.totalTime);
        }
    }

    @Test
    void shouldAccumulateTimes() {
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker();
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.WRITE);
        LoggingPhaseTracker.Logger scanLogger = (LoggingPhaseTracker.Logger)phaseTracker.times().get(PhaseTracker.Phase.SCAN);
        long firstCount = scanLogger.totalTime;
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(100);
        phaseTracker.stop();
        Assertions.assertTrue((scanLogger.totalTime > firstCount ? 1 : 0) != 0);
    }

    @Test
    void throwIfEnterAfterStop() {
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker();
        phaseTracker.stop();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> LoggingPhaseTrackerTest.lambda$throwIfEnterAfterStop$0((PhaseTracker)phaseTracker));
        LogAssertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Trying to report a new phase after phase tracker has been stopped."});
    }

    @Test
    void mustReportMain() {
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        Log log = logProvider.getLog(IndexPopulationJob.class);
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker(log);
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.WRITE);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.WRITE);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.MERGE);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.BUILD);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.APPLY_EXTERNAL);
        this.sleep(100);
        phaseTracker.enterPhase(PhaseTracker.Phase.FLIP);
        this.sleep(100);
        phaseTracker.stop();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"TIME/PHASE Final: SCAN[totalTime=200ms, avgTime=100ms, minTime=0ns, maxTime=100ms, nbrOfReports=2], WRITE[totalTime=200ms, avgTime=100ms, minTime=0ns, maxTime=100ms, nbrOfReports=2], MERGE[totalTime=100ms], BUILD[totalTime=100ms], APPLY_EXTERNAL[totalTime=100ms], FLIP[totalTime=100ms]"});
    }

    @Test
    void mustReportPeriod() {
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        Log log = logProvider.getLog(IndexPopulationJob.class);
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker(1, log);
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        this.sleep(1000);
        phaseTracker.enterPhase(PhaseTracker.Phase.WRITE);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.DEBUG).containsMessages(new String[]{"TIME/PHASE Total: SCAN[totalTime=1s], Last 1 sec: SCAN[totalTime=1s]"});
        this.sleep(1000);
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.DEBUG).containsMessages(new String[]{"TIME/PHASE Total: SCAN[totalTime=1s], WRITE[totalTime=1s], Last 1 sec: WRITE[totalTime=1s]"});
        this.sleep(1000);
        phaseTracker.enterPhase(PhaseTracker.Phase.WRITE);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.DEBUG).containsMessages(new String[]{"TIME/PHASE Total: SCAN[totalTime=2s, avgTime=1s, minTime=0ns, maxTime=1s, nbrOfReports=2], WRITE[totalTime=1s], Last 1 sec: SCAN[totalTime=1s]"});
    }

    @Test
    void shouldRegisterTimeManually() {
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        Log log = logProvider.getLog(IndexPopulationJob.class);
        LoggingPhaseTracker phaseTracker = this.getPhaseTracker(1, log);
        phaseTracker.registerTime(PhaseTracker.Phase.SCAN, 1234L);
        phaseTracker.registerTime(PhaseTracker.Phase.BUILD, 56789L);
        phaseTracker.stop();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(IndexPopulationJob.class).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"TIME/PHASE Final: SCAN[totalTime=1s234ms], BUILD[totalTime=56s789ms]"});
    }

    private LoggingPhaseTracker getPhaseTracker() {
        return this.getPhaseTracker((Log)NullLog.getInstance());
    }

    private LoggingPhaseTracker getPhaseTracker(Log log) {
        return this.getPhaseTracker(LoggingPhaseTracker.PERIOD_INTERVAL, log);
    }

    private LoggingPhaseTracker getPhaseTracker(int periodIntervalInSeconds, Log log) {
        return new LoggingPhaseTracker((long)periodIntervalInSeconds, log, (Clock)this.clock);
    }

    private void sleep(int i) {
        this.clock.forward((long)i, TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void lambda$throwIfEnterAfterStop$0(PhaseTracker phaseTracker) throws Throwable {
        phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
    }
}

