/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.api.index.ValueIndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.JobSchedulerExtension;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.Values;

@ExtendWith(value={JobSchedulerExtension.class})
class TokenIndexPopulationTest {
    private final IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
    private final IndexDescriptor valueIndex = TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
    private final IndexPopulator valueIndexPopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
    private IndexDescriptor tokenIndex;
    private final IndexPopulator tokenIndexPopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
    private final ArgumentCaptor<Collection<? extends IndexEntryUpdate<?>>> indexUpdates = ArgumentCaptor.forClass(Collection.class);
    private MultipleIndexPopulator multipleIndexPopulator;
    @Inject
    private JobScheduler jobScheduler;

    TokenIndexPopulationTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.tokenIndex = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE), (IndexProviderDescriptor)TokenIndexProvider.DESCRIPTOR).withName("label_index").withIndexType(IndexType.LOOKUP).materialise(123L);
        this.multipleIndexPopulator = new MultipleIndexPopulator(this.storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), this.jobScheduler, (TokenNameLookup)new InMemoryTokens(), PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, "", Subject.AUTH_DISABLED, Config.defaults());
    }

    @Test
    void testBasicTokenIndexPopulation() throws Exception {
        this.addIndexPopulator(this.tokenIndexPopulator, this.tokenIndex);
        this.mockTokenStore(batch -> {
            batch.addRecord(1L, new long[]{123L});
            batch.addRecord(2L, new long[]{123L, 111L});
            batch.addRecord(3L, new long[]{111L});
        });
        this.multipleIndexPopulator.create(CursorContext.NULL);
        this.multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL).run(StoreScan.NO_EXTERNAL_UPDATES);
        ((IndexPopulator)Mockito.verify((Object)this.tokenIndexPopulator)).add((Collection)this.indexUpdates.capture(), (CursorContext)ArgumentMatchers.any());
        List indexUpdateBatches = this.indexUpdates.getAllValues();
        Assertions.assertEquals((int)1, (int)indexUpdateBatches.size());
        HashSet indexEntryUpdates = new HashSet((Collection)indexUpdateBatches.get(0));
        Set<TokenIndexEntryUpdate> expectedUpdates = Set.of(IndexEntryUpdate.change((long)1L, (SchemaDescriptorSupplier)this.tokenIndex, (long[])new long[0], (long[])new long[]{123L}), IndexEntryUpdate.change((long)2L, (SchemaDescriptorSupplier)this.tokenIndex, (long[])new long[0], (long[])new long[]{123L, 111L}), IndexEntryUpdate.change((long)3L, (SchemaDescriptorSupplier)this.tokenIndex, (long[])new long[0], (long[])new long[]{111L}));
        Assertions.assertEquals(expectedUpdates, indexEntryUpdates);
    }

    @Test
    void tokenIndexPopulationShouldIgnoreEntityUpdates() throws Exception {
        this.addIndexPopulator(this.tokenIndexPopulator, this.tokenIndex);
        this.addIndexPopulator(this.valueIndexPopulator, this.valueIndex);
        this.mockPropertyStore(batch -> batch.addRecord(1L, new long[]{1L}, Map.of(1, Values.stringValue((String)"Hello"))));
        this.multipleIndexPopulator.create(CursorContext.NULL);
        this.multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL).run(StoreScan.NO_EXTERNAL_UPDATES);
        ((IndexPopulator)Mockito.verify((Object)this.tokenIndexPopulator, (VerificationMode)Mockito.never())).add((Collection)this.indexUpdates.capture(), (CursorContext)ArgumentMatchers.any());
        ((IndexPopulator)Mockito.verify((Object)this.valueIndexPopulator)).add((Collection)ArgumentMatchers.any(), (CursorContext)ArgumentMatchers.any());
    }

    @Test
    void shouldNotPassConsumerForValueIndexUpdatesToStoreWhenNoValueIndexPopulating() {
        this.addIndexPopulator(this.tokenIndexPopulator, this.tokenIndex);
        this.mockTokenStore(batch -> batch.addRecord(1L, new long[]{123L}));
        this.multipleIndexPopulator.create(CursorContext.NULL);
        this.multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL).run(StoreScan.NO_EXTERNAL_UPDATES);
        ((IndexStoreView)Mockito.verify((Object)this.storeView)).visitNodes((int[])ArgumentMatchers.any(), (IntPredicate)ArgumentMatchers.any(), (PropertyScanConsumer)ArgumentMatchers.isNull(), (TokenScanConsumer)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (PageCacheTracer)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any());
    }

    @Test
    void shouldNotPassConsumerForTokenIndexUpdatesToStoreWhenNoTokenIndexPopulating() {
        this.addIndexPopulator(this.valueIndexPopulator, this.valueIndex);
        this.mockPropertyStore(batch -> batch.addRecord(1L, new long[]{1L}, Map.of(1, Values.stringValue((String)"Hello"))));
        this.multipleIndexPopulator.create(CursorContext.NULL);
        this.multipleIndexPopulator.createStoreScan(PageCacheTracer.NULL).run(StoreScan.NO_EXTERNAL_UPDATES);
        ((IndexStoreView)Mockito.verify((Object)this.storeView)).visitNodes((int[])ArgumentMatchers.any(), (IntPredicate)ArgumentMatchers.any(), (PropertyScanConsumer)ArgumentMatchers.any(), (TokenScanConsumer)ArgumentMatchers.isNull(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (PageCacheTracer)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any());
    }

    private void mockPropertyStore(Consumer<PropertyScanConsumer.Batch> updates) {
        Mockito.when((Object)this.storeView.visitNodes((int[])ArgumentMatchers.any(), (IntPredicate)ArgumentMatchers.any(), (PropertyScanConsumer)ArgumentMatchers.any(), (TokenScanConsumer)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (PageCacheTracer)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenAnswer(invocation -> {
            PropertyScanConsumer consumerArg = (PropertyScanConsumer)invocation.getArgument(2);
            return new IndexEntryUpdateScan(() -> {
                if (consumerArg != null) {
                    PropertyScanConsumer.Batch batch = consumerArg.newBatch();
                    updates.accept(batch);
                    batch.process();
                }
            });
        });
        Mockito.when((Object)this.storeView.newPropertyAccessor((CursorContext)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class)));
    }

    private void mockTokenStore(Consumer<TokenScanConsumer.Batch> updates) {
        Mockito.when((Object)this.storeView.visitNodes((int[])ArgumentMatchers.any(), (IntPredicate)ArgumentMatchers.any(), (PropertyScanConsumer)ArgumentMatchers.any(), (TokenScanConsumer)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (PageCacheTracer)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenAnswer(invocation -> {
            TokenScanConsumer consumerArg = (TokenScanConsumer)invocation.getArgument(3);
            return new IndexEntryUpdateScan(() -> {
                if (consumerArg != null) {
                    TokenScanConsumer.Batch batch = consumerArg.newBatch();
                    updates.accept(batch);
                    batch.process();
                }
            });
        });
        Mockito.when((Object)this.storeView.newPropertyAccessor((CursorContext)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class)));
    }

    private void addIndexPopulator(IndexPopulator populator, IndexDescriptor descriptor) {
        Object indexProxyStrategy = descriptor.getIndexType() == IndexType.LOOKUP ? new TokenIndexProxyStrategy(descriptor, (TokenNameLookup)new InMemoryTokens(), false) : new ValueIndexProxyStrategy(TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1}), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (TokenNameLookup)new InMemoryTokens());
        this.multipleIndexPopulator.addPopulator(populator, (IndexProxyStrategy)indexProxyStrategy, (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class), (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class));
    }

    private static class IndexEntryUpdateScan
    implements StoreScan {
        final Runnable action;

        IndexEntryUpdateScan(Runnable action) {
            this.action = action;
        }

        public void run(StoreScan.ExternalUpdatesCheck externalUpdatesCheck) {
            this.action.run();
        }

        public void stop() {
        }

        public PopulationProgress getProgress() {
            return PopulationProgress.NONE;
        }
    }
}

