/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.Value;

@PageCacheExtension
abstract class BlockBasedIndexPopulatorUpdatesTest<KEY extends NativeIndexKey<KEY>> {
    final IndexDescriptor INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1})).withName("index").withIndexType(this.indexType()).materialise(1L);
    private final IndexDescriptor UNIQUE_INDEX_DESCRIPTOR = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1})).withName("constraint").withIndexType(this.indexType()).materialise(1L);
    final TokenNameLookup tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;
    @Inject
    private PageCache pageCache;
    IndexFiles indexFiles;
    DatabaseIndexContext databaseIndexContext;
    private JobScheduler jobScheduler;
    IndexPopulator.PopulationWorkScheduler populationWorkScheduler;

    BlockBasedIndexPopulatorUpdatesTest() {
    }

    abstract IndexType indexType();

    abstract BlockBasedIndexPopulator<KEY> instantiatePopulator(IndexDescriptor var1) throws IOException;

    abstract Value supportedValue(int var1);

    @BeforeEach
    void setup() {
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor("test", "v1");
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)this.directory.homePath()).forProvider(providerDescriptor);
        this.indexFiles = new IndexFiles.Directory(this.fs, directoryStructure, this.INDEX_DESCRIPTOR.getId());
        this.databaseIndexContext = DatabaseIndexContext.builder((PageCache)this.pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").build();
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.populationWorkScheduler = new IndexPopulator.PopulationWorkScheduler(){

            public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
                return BlockBasedIndexPopulatorUpdatesTest.this.jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(null, null, null), job);
            }
        };
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldSeeExternalUpdateBothBeforeAndAfterScanCompleted() throws IndexEntryConflictException, IOException {
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(this.INDEX_DESCRIPTOR);
        try {
            Value first = this.supportedValue(1);
            Value second = this.supportedValue(2);
            int firstId = 1;
            int secondId = 2;
            this.externalUpdate(populator, first, firstId);
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            this.externalUpdate(populator, second, secondId);
            this.assertMatch(populator, first, firstId);
            this.assertMatch(populator, second, secondId);
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowOnDuplicatedValuesFromScan() throws IOException {
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(this.UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = this.supportedValue(1);
            ValueIndexEntryUpdate firstScanUpdate = ValueIndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            ValueIndexEntryUpdate secondScanUpdate = ValueIndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            Assertions.assertThrows(IndexEntryConflictException.class, () -> {
                populator.add(Collections.singleton(firstScanUpdate), CursorContext.NULL);
                populator.add(Collections.singleton(secondScanUpdate), CursorContext.NULL);
                populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            });
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowOnDuplicatedValuesFromExternalUpdates() throws IOException {
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(this.UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = this.supportedValue(1);
            ValueIndexEntryUpdate firstExternalUpdate = ValueIndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            ValueIndexEntryUpdate secondExternalUpdate = ValueIndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            Assertions.assertThrows(IndexEntryConflictException.class, () -> {
                try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
                    updater.process((IndexEntryUpdate)firstExternalUpdate);
                    updater.process((IndexEntryUpdate)secondExternalUpdate);
                }
                populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            });
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowOnDuplicatedValuesFromScanAndExternalUpdates() throws IOException {
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(this.UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = this.supportedValue(1);
            ValueIndexEntryUpdate externalUpdate = ValueIndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            ValueIndexEntryUpdate scanUpdate = ValueIndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            Assertions.assertThrows(IndexEntryConflictException.class, () -> {
                try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
                    updater.process((IndexEntryUpdate)externalUpdate);
                }
                populator.add(Collections.singleton(scanUpdate), CursorContext.NULL);
                populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            });
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotThrowOnDuplicationsLaterFixedByExternalUpdates() throws IndexEntryConflictException, IOException {
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(this.UNIQUE_INDEX_DESCRIPTOR);
        try {
            Value duplicate = this.supportedValue(1);
            Value unique = this.supportedValue(2);
            ValueIndexEntryUpdate firstScanUpdate = ValueIndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            ValueIndexEntryUpdate secondScanUpdate = ValueIndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{duplicate});
            ValueIndexEntryUpdate externalUpdate = ValueIndexEntryUpdate.change((long)1L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value)duplicate, (Value)unique);
            populator.add(Collections.singleton(firstScanUpdate), CursorContext.NULL);
            try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
                updater.process((IndexEntryUpdate)externalUpdate);
            }
            populator.add(Collections.singleton(secondScanUpdate), CursorContext.NULL);
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            this.assertHasEntry(populator, unique, 1);
            this.assertHasEntry(populator, duplicate, 2);
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    void assertHasEntry(BlockBasedIndexPopulator<KEY> populator, Value entry, int expectedId) {
        try (NativeIndexReader reader = populator.newReader();){
            SimpleEntityValueClient valueClient = new SimpleEntityValueClient();
            PropertyIndexQuery.ExactPredicate exact = PropertyIndexQuery.exact((int)this.INDEX_DESCRIPTOR.schema().getPropertyId(), (Object)entry);
            reader.query((IndexProgressor.EntityValueClient)valueClient, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{exact});
            Assertions.assertTrue((boolean)valueClient.next());
            long id = valueClient.reference;
            Assertions.assertEquals((long)expectedId, (long)id);
        }
    }

    void externalUpdate(BlockBasedIndexPopulator<KEY> populator, Value value, int entityId) {
        try (IndexUpdater indexUpdater = populator.newPopulatingUpdater(CursorContext.NULL);){
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)entityId, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{value}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void assertMatch(BlockBasedIndexPopulator<KEY> populator, Value value, long id) {
        try (NativeIndexReader reader = populator.newReader();){
            SimpleEntityValueClient cursor = new SimpleEntityValueClient();
            reader.query((IndexProgressor.EntityValueClient)cursor, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.INDEX_DESCRIPTOR.schema().getPropertyId(), (Object)value)});
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertEquals((long)id, (long)cursor.reference);
            Assertions.assertEquals((Object)value, (Object)cursor.values[0]);
            Assertions.assertFalse((boolean)cursor.next());
        }
    }
}

