/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.SimpleLongLayout;
import org.neo4j.io.pagecache.ByteArrayPageCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.BlockEntry;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class BlockEntryTest {
    @Inject
    RandomSupport rnd;
    private static final PageCursor pageCursor = ByteArrayPageCursor.wrap((int)1000);
    private static SimpleLongLayout layout;

    BlockEntryTest() {
    }

    @BeforeEach
    void setup() {
        layout = SimpleLongLayout.longLayout().withFixedSize(this.rnd.nextBoolean()).withKeyPadding(this.rnd.nextInt(10)).build();
    }

    @Test
    void shouldReadWriteSingleEntry() {
        MutableLong writeKey = layout.key(this.rnd.nextLong());
        MutableLong writeValue = layout.value(this.rnd.nextLong());
        int offset = pageCursor.getOffset();
        BlockEntry.write((PageCursor)pageCursor, (Layout)layout, (Object)writeKey, (Object)writeValue);
        MutableLong readKey = layout.newKey();
        MutableLong readValue = layout.newValue();
        pageCursor.setOffset(offset);
        BlockEntry.read((PageCursor)pageCursor, (Layout)layout, (Object)readKey, (Object)readValue);
        Assertions.assertEquals((int)0, (int)layout.compare(writeKey, readKey));
        Assertions.assertEquals((int)0, (int)layout.compare(writeValue, readValue));
    }

    @Test
    void shouldReadWriteMultipleEntries() {
        ArrayList<BlockEntry> expectedEntries = new ArrayList<BlockEntry>();
        int nbrOfEntries = 10;
        int offset = pageCursor.getOffset();
        for (int i = 0; i < nbrOfEntries; ++i) {
            MutableLong key = layout.key(this.rnd.nextLong());
            MutableLong value = layout.value(this.rnd.nextLong());
            BlockEntry entry = new BlockEntry((Object)key, (Object)value);
            BlockEntry.write((PageCursor)pageCursor, (Layout)layout, (Object)key, (Object)value);
            expectedEntries.add(entry);
        }
        pageCursor.setOffset(offset);
        for (BlockEntry expectedEntry : expectedEntries) {
            BlockEntry actualEntry = BlockEntry.read((PageCursor)pageCursor, (Layout)layout);
            BlockEntryTest.assertBlockEquals((BlockEntry<MutableLong, MutableLong>)expectedEntry, (BlockEntry<MutableLong, MutableLong>)actualEntry);
        }
    }

    private static void assertBlockEquals(BlockEntry<MutableLong, MutableLong> expected, BlockEntry<MutableLong, MutableLong> actual) {
        Assertions.assertEquals((int)0, (int)layout.compare((MutableLong)expected.key(), (MutableLong)actual.key()));
        Assertions.assertEquals((int)0, (int)layout.compare((MutableLong)expected.value(), (MutableLong)actual.value()));
    }
}

