/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.SimpleLongLayout;
import org.neo4j.kernel.impl.index.schema.CombinedPartSeeker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class CombinedPartSeekerTest {
    private static final Comparator<Pair<MutableLong, MutableLong>> HIT_COMPARATOR = Comparator.comparing(Pair::getKey);
    @Inject
    RandomSupport random;

    CombinedPartSeekerTest() {
    }

    @Test
    void shouldCombineAllParts() throws IOException {
        SimpleLongLayout layout = SimpleLongLayout.longLayout().withFixedSize(true).build();
        ArrayList<SimpleSeeker> parts = new ArrayList<SimpleSeeker>();
        int partCount = this.random.nextInt(1, 20);
        ArrayList<Pair<MutableLong, MutableLong>> expectedAllData = new ArrayList<Pair<MutableLong, MutableLong>>();
        int maxKey = this.random.nextInt(100, 10000);
        for (int i = 0; i < partCount; ++i) {
            int dataSize = this.random.nextInt(0, 100);
            ArrayList<Pair<MutableLong, MutableLong>> arrayList = new ArrayList<Pair<MutableLong, MutableLong>>(dataSize);
            for (int j = 0; j < dataSize; ++j) {
                long key = this.random.nextLong((long)maxKey);
                arrayList.add((Pair<MutableLong, MutableLong>)Pair.of((Object)new MutableLong(key), (Object)new MutableLong(key * 2L)));
            }
            arrayList.sort(HIT_COMPARATOR);
            parts.add(new SimpleSeeker(arrayList));
            expectedAllData.addAll(arrayList);
        }
        expectedAllData.sort(HIT_COMPARATOR);
        CombinedPartSeeker combinedSeeker = new CombinedPartSeeker((Layout)layout, parts);
        for (Pair pair : expectedAllData) {
            Assertions.assertTrue((boolean)combinedSeeker.next());
            Assertions.assertEquals((long)((MutableLong)pair.getKey()).longValue(), (long)((MutableLong)combinedSeeker.key()).longValue());
            Assertions.assertEquals((long)((MutableLong)pair.getValue()).longValue(), (long)((MutableLong)combinedSeeker.value()).longValue());
        }
        Assertions.assertFalse((boolean)combinedSeeker.next());
        Assertions.assertFalse((boolean)combinedSeeker.next());
    }

    private static class SimpleSeeker
    implements Seeker<MutableLong, MutableLong> {
        private final Iterator<Pair<MutableLong, MutableLong>> data;
        private Pair<MutableLong, MutableLong> current;

        private SimpleSeeker(Iterable<Pair<MutableLong, MutableLong>> data) {
            this.data = data.iterator();
        }

        public boolean next() {
            if (this.data.hasNext()) {
                this.current = this.data.next();
                return true;
            }
            return false;
        }

        public void close() {
        }

        public MutableLong key() {
            return (MutableLong)this.current.getKey();
        }

        public MutableLong value() {
            return (MutableLong)this.current.getValue();
        }
    }
}

