/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.DefaultTokenIndexReader;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.storageengine.api.schema.SimpleEntityTokenClient;

@Execution(value=ExecutionMode.CONCURRENT)
class DefaultTokenIndexReaderTest {
    private static final int LABEL_ID = 1;
    private final long[] keys = new long[]{0L, 1L, 3L};
    private final long[] bitsets = new long[]{35010L, 520L, 8353L};
    private final long[] expected = new long[]{1L, 6L, 7L, 11L, 15L, 67L, 73L, 192L, 197L, 199L, 205L};
    private GBPTree<TokenScanKey, TokenScanValue> index;

    DefaultTokenIndexReaderTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.index = (GBPTree)Mockito.mock(GBPTree.class);
        Mockito.when((Object)this.index.seek((Object)((TokenScanKey)ArgumentMatchers.any(TokenScanKey.class)), (Object)((TokenScanKey)ArgumentMatchers.any(TokenScanKey.class)), (CursorContext)ArgumentMatchers.eq((Object)CursorContext.NULL))).thenAnswer(innvocation -> this.cursor(((TokenScanKey)innvocation.getArgument((int)0, TokenScanKey.class)).idRange <= ((TokenScanKey)innvocation.getArgument((int)1, TokenScanKey.class)).idRange));
    }

    private Seeker<TokenScanKey, TokenScanValue> cursor(boolean ascending) throws Exception {
        Seeker cursor = (Seeker)Mockito.mock(Seeker.class);
        Mockito.when((Object)cursor.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)((TokenScanKey)cursor.key())).thenReturn((Object)DefaultTokenIndexReaderTest.key(ascending ? this.keys[0] : this.keys[2]), (Object[])new TokenScanKey[]{DefaultTokenIndexReaderTest.key(this.keys[1]), DefaultTokenIndexReaderTest.key(ascending ? this.keys[2] : this.keys[0])});
        Mockito.when((Object)((TokenScanValue)cursor.value())).thenReturn((Object)DefaultTokenIndexReaderTest.value(ascending ? this.bitsets[0] : this.bitsets[2]), (Object[])new TokenScanValue[]{DefaultTokenIndexReaderTest.value(this.bitsets[1]), DefaultTokenIndexReaderTest.value(ascending ? this.bitsets[2] : this.bitsets[0]), null});
        return cursor;
    }

    @Test
    void shouldFindMultipleEntitiesInEachRange() {
        DefaultTokenIndexReader reader = new DefaultTokenIndexReader(this.index);
        SimpleEntityTokenClient tokenClient = new SimpleEntityTokenClient();
        reader.query((IndexProgressor.EntityTokenClient)tokenClient, IndexQueryConstraints.unconstrained(), new TokenPredicate(1), CursorContext.NULL);
        Assertions.assertArrayEquals((long[])this.expected, (long[])DefaultTokenIndexReaderTest.asArray(tokenClient));
    }

    @Test
    void shouldFindMultipleWithProgressorAscending() {
        DefaultTokenIndexReader reader = new DefaultTokenIndexReader(this.index);
        SimpleEntityTokenClient tokenClient = new SimpleEntityTokenClient();
        reader.query((IndexProgressor.EntityTokenClient)tokenClient, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.ASCENDING, (boolean)false), new TokenPredicate(1), CursorContext.NULL);
        Assertions.assertArrayEquals((long[])this.expected, (long[])DefaultTokenIndexReaderTest.asArray(tokenClient));
    }

    @Test
    void shouldFindMultipleWithProgressorDescending() {
        DefaultTokenIndexReader reader = new DefaultTokenIndexReader(this.index);
        SimpleEntityTokenClient tokenClient = new SimpleEntityTokenClient();
        reader.query((IndexProgressor.EntityTokenClient)tokenClient, IndexQueryConstraints.constrained((IndexOrder)IndexOrder.DESCENDING, (boolean)false), new TokenPredicate(1), CursorContext.NULL);
        ArrayUtils.reverse((long[])this.expected);
        Assertions.assertArrayEquals((long[])this.expected, (long[])DefaultTokenIndexReaderTest.asArray(tokenClient));
    }

    private static long[] asArray(SimpleEntityTokenClient valueClient) {
        MutableLongList result = LongLists.mutable.empty();
        while (valueClient.next()) {
            result.add(valueClient.reference);
        }
        return result.toArray();
    }

    private static TokenScanValue value(long bits) {
        TokenScanValue value = new TokenScanValue();
        value.bits = bits;
        return value;
    }

    private static TokenScanKey key(long idRange) {
        return new TokenScanKey(1, idRange);
    }
}

