/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityClient;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;

@PageCacheExtension
@ExtendWith(value={RandomExtension.class})
abstract class IndexPopulationStressTest {
    private static final IndexProviderDescriptor PROVIDER = new IndexProviderDescriptor("provider", "1.0");
    private static final int THREADS = 50;
    private static final int MAX_BATCH_SIZE = 100;
    private static final int BATCHES_PER_THREAD = 100;
    @Inject
    private RandomSupport random;
    @Inject
    PageCache pageCache;
    @Inject
    FileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private final Scheduler scheduler = new Scheduler();
    private final boolean hasValues;
    private final Function<RandomValues, Value> valueGenerator;
    private final Function<IndexPopulationStressTest, IndexProvider> providerCreator;
    private IndexDescriptor descriptor;
    private IndexDescriptor descriptor2;
    private final IndexSamplingConfig samplingConfig = new IndexSamplingConfig(1000, 0.2, true);
    private final NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
    private IndexPopulator populator;
    private IndexProvider indexProvider;
    private TokenNameLookup tokenNameLookup;
    private boolean prevAccessCheck;

    abstract IndexType indexType();

    IndexPopulationStressTest(boolean hasValues, Function<RandomValues, Value> valueGenerator, Function<IndexPopulationStressTest, IndexProvider> providerCreator) {
        this.hasValues = hasValues;
        this.valueGenerator = valueGenerator;
        this.providerCreator = providerCreator;
    }

    IndexDirectoryStructure.Factory directory() {
        return IndexDirectoryStructure.directoriesBySubProvider((IndexDirectoryStructure)IndexDirectoryStructure.directoriesByProvider((Path)this.testDirectory.homePath()).forProvider(PROVIDER));
    }

    @BeforeEach
    void setup() throws IOException, EntityNotFoundException {
        this.indexProvider = this.providerCreator.apply(this);
        this.tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
        this.descriptor = this.indexProvider.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{0}), (IndexProviderDescriptor)PROVIDER).withIndexType(this.indexType()).withName("index_0").materialise(0L));
        this.descriptor2 = this.indexProvider.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{0}), (IndexProviderDescriptor)PROVIDER).withIndexType(this.indexType()).withName("index_1").materialise(1L));
        this.fs.mkdirs(this.indexProvider.directoryStructure().rootDirectory());
        this.populator = this.indexProvider.getPopulator(this.descriptor, this.samplingConfig, ByteBufferFactory.heapBufferFactory((int)((int)ByteUnit.kibiBytes((long)40L))), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenThrow(UnsupportedOperationException.class);
        this.prevAccessCheck = UnsafeUtil.exchangeNativeAccessCheckEnabled((boolean)false);
    }

    @AfterEach
    void tearDown() throws Exception {
        UnsafeUtil.exchangeNativeAccessCheckEnabled((boolean)this.prevAccessCheck);
        if (this.populator != null) {
            this.populator.close(true, CursorContext.NULL);
        }
        this.scheduler.shutdown();
    }

    @Test
    void stressIt() throws Throwable {
        Race race = new Race();
        AtomicReferenceArray lastBatches = new AtomicReferenceArray(50);
        Generator[] generators = new Generator[50];
        this.populator.create();
        CountDownLatch insertersDone = new CountDownLatch(50);
        ReentrantReadWriteLock updateLock = new ReentrantReadWriteLock(true);
        for (int i = 0; i < 50; ++i) {
            race.addContestant(this.inserter(lastBatches, generators, insertersDone, updateLock, i), 1);
        }
        ArrayList updates = new ArrayList();
        race.addContestant(this.updater(lastBatches, insertersDone, updateLock, updates));
        race.go();
        this.populator.scanCompleted(PhaseTracker.nullInstance, (IndexPopulator.PopulationWorkScheduler)this.scheduler, CursorContext.NULL);
        this.populator.close(true, CursorContext.NULL);
        this.populator = null;
        this.buildReferencePopulatorSingleThreaded(generators, updates);
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.samplingConfig, this.tokenNameLookup);
             IndexAccessor referenceAccessor = this.indexProvider.getOnlineAccessor(this.descriptor2, this.samplingConfig, this.tokenNameLookup);
             ValueIndexReader reader = accessor.newValueReader();
             ValueIndexReader referenceReader = referenceAccessor.newValueReader();){
            RecordingClient entries = new RecordingClient();
            RecordingClient referenceEntries = new RecordingClient();
            reader.query((IndexProgressor.EntityValueClient)entries, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unordered((boolean)this.hasValues), new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
            referenceReader.query((IndexProgressor.EntityValueClient)referenceEntries, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unordered((boolean)this.hasValues), new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
            this.exhaustAndSort(referenceEntries);
            this.exhaustAndSort(entries);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)entries.records.isEmpty());
            Assertions.assertThat(entries.records).isEqualTo(referenceEntries.records);
        }
    }

    private void exhaustAndSort(RecordingClient client) {
        while (client.next()) {
        }
        client.records.sort(Comparator.comparingLong(o -> o.entityId));
    }

    private Runnable updater(AtomicReferenceArray<List<ValueIndexEntryUpdate<?>>> lastBatches, CountDownLatch insertersDone, ReadWriteLock updateLock, Collection<ValueIndexEntryUpdate<?>> updates) {
        return Race.throwing(() -> {
            ArrayList<Long> removed = new ArrayList<Long>();
            RandomValues randomValues = RandomValues.create((Random)new Random(this.random.seed() + 50L));
            while (insertersDone.getCount() > 0L) {
                Thread.sleep(10L);
                updateLock.writeLock().lock();
                try {
                    IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor, CursorContext.NULL);
                    try {
                        for (int i = 0; i < 50; ++i) {
                            List batch = (List)lastBatches.get(i);
                            if (batch == null) continue;
                            ValueIndexEntryUpdate update = null;
                            switch (randomValues.nextInt(3)) {
                                case 0: {
                                    if (removed.isEmpty()) break;
                                    Long id = (Long)removed.remove(randomValues.nextInt(removed.size()));
                                    update = IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{this.valueGenerator.apply(randomValues)});
                                    break;
                                }
                                case 1: {
                                    ValueIndexEntryUpdate removal = (ValueIndexEntryUpdate)batch.get(randomValues.nextInt(batch.size()));
                                    update = IndexEntryUpdate.remove((long)removal.getEntityId(), (SchemaDescriptorSupplier)this.descriptor, (Value[])removal.values());
                                    removed.add(removal.getEntityId());
                                    break;
                                }
                                case 2: {
                                    ValueIndexEntryUpdate removal = (ValueIndexEntryUpdate)batch.get(randomValues.nextInt(batch.size()));
                                    IndexEntryUpdate.change((long)removal.getEntityId(), (SchemaDescriptorSupplier)this.descriptor, (Value[])removal.values(), (Value[])((Value[])ArrayUtils.toArray((Object[])new Value[]{this.valueGenerator.apply(randomValues)})));
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException();
                                }
                            }
                            if (update == null) continue;
                            updater.process(update);
                            updates.add(update);
                        }
                    }
                    finally {
                        if (updater == null) continue;
                        updater.close();
                    }
                }
                finally {
                    updateLock.writeLock().unlock();
                }
            }
        });
    }

    private Runnable inserter(AtomicReferenceArray<List<ValueIndexEntryUpdate<?>>> lastBatches, Generator[] generators, CountDownLatch insertersDone, ReadWriteLock updateLock, int slot) {
        int worstCaseEntriesPerThread = 10000;
        return Race.throwing(() -> {
            try {
                Generator generator = generators[slot] = new Generator(100, this.random.seed() + (long)slot, slot * worstCaseEntriesPerThread);
                for (int j = 0; j < 100; ++j) {
                    List<ValueIndexEntryUpdate<?>> batch = generator.batch(this.descriptor);
                    updateLock.readLock().lock();
                    try {
                        this.populator.add(batch, CursorContext.NULL);
                    }
                    finally {
                        updateLock.readLock().unlock();
                    }
                    lastBatches.set(slot, batch);
                }
            }
            finally {
                insertersDone.countDown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildReferencePopulatorSingleThreaded(Generator[] generators, Collection<ValueIndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        IndexPopulator referencePopulator = this.indexProvider.getPopulator(this.descriptor2, this.samplingConfig, ByteBufferFactory.heapBufferFactory((int)((int)ByteUnit.kibiBytes((long)40L))), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        referencePopulator.create();
        boolean referenceSuccess = false;
        try {
            for (Generator generator : generators) {
                generator.reset();
                for (int i = 0; i < 100; ++i) {
                    referencePopulator.add(generator.batch(this.descriptor2), CursorContext.NULL);
                }
            }
            try (IndexUpdater updater = referencePopulator.newPopulatingUpdater(this.nodePropertyAccessor, CursorContext.NULL);){
                for (ValueIndexEntryUpdate<?> update : updates) {
                    updater.process(update);
                }
            }
            referenceSuccess = true;
            referencePopulator.scanCompleted(PhaseTracker.nullInstance, (IndexPopulator.PopulationWorkScheduler)this.scheduler, CursorContext.NULL);
        }
        finally {
            referencePopulator.close(referenceSuccess, CursorContext.NULL);
        }
    }

    private static class IndexRecord {
        private final long entityId;
        private final Value[] values;

        IndexRecord(long entityId, Value[] values) {
            this.entityId = entityId;
            this.values = values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexRecord that = (IndexRecord)o;
            return this.entityId == that.entityId && Arrays.equals(this.values, that.values);
        }

        public int hashCode() {
            int result = Objects.hash(this.entityId);
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }
    }

    private static class RecordingClient
    extends SimpleEntityClient
    implements IndexProgressor.EntityValueClient {
        final List<IndexRecord> records = new ArrayList<IndexRecord>();

        private RecordingClient() {
        }

        public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, AccessMode accessMode, boolean indexIncludesTransactionState, IndexQueryConstraints constraints, PropertyIndexQuery ... query) {
            this.initialize(progressor);
        }

        public boolean acceptEntity(long reference, float score, Value ... values) {
            this.acceptEntity(reference);
            this.records.add(new IndexRecord(reference, values));
            return true;
        }

        public boolean needsValues() {
            return true;
        }
    }

    private static class Scheduler
    implements IndexPopulator.PopulationWorkScheduler {
        private final JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();

        private Scheduler() {
        }

        public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
            return this.jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(null, null, null), job);
        }

        void shutdown() throws Exception {
            this.jobScheduler.shutdown();
        }
    }

    private class Generator {
        private final int maxBatchSize;
        private final long seed;
        private final long startEntityId;
        private RandomValues randomValues;
        private long nextEntityId;

        Generator(int maxBatchSize, long seed, long startEntityId) {
            this.startEntityId = startEntityId;
            this.nextEntityId = startEntityId;
            this.maxBatchSize = maxBatchSize;
            this.seed = seed;
            this.reset();
        }

        private void reset() {
            this.randomValues = RandomValues.create((Random)new Random(this.seed));
            this.nextEntityId = this.startEntityId;
        }

        List<ValueIndexEntryUpdate<?>> batch(IndexDescriptor descriptor) {
            int n = this.randomValues.nextInt(this.maxBatchSize) + 1;
            ArrayList updates = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                updates.add(IndexEntryUpdate.add((long)this.nextEntityId++, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{IndexPopulationStressTest.this.valueGenerator.apply(this.randomValues)}));
            }
            return updates;
        }
    }
}

