/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulatorTest;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.PointBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.PointIndexAccessor;
import org.neo4j.kernel.impl.index.schema.PointKey;
import org.neo4j.kernel.impl.index.schema.PointLayout;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
public class PointBlockBasedIndexPopulatorTest
extends BlockBasedIndexPopulatorTest<PointKey> {
    private static final StandardConfiguration CONFIGURATION = new StandardConfiguration();
    private static final Config CONFIG = Config.defaults((Setting)GraphDatabaseInternalSettings.index_populator_merge_factor, (Object)2);
    private static final IndexSpecificSpaceFillingCurveSettings SPATIAL_SETTINGS = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)CONFIG);
    private static final PointLayout LAYOUT = new PointLayout(SPATIAL_SETTINGS);
    private static final Set<ValueType> UNSUPPORTED_TYPES = Collections.unmodifiableSet(Arrays.stream(ValueType.values()).filter(type -> type.valueGroup.category() != ValueCategory.GEOMETRY).collect(Collectors.toCollection(() -> EnumSet.noneOf(ValueType.class))));
    @Inject
    private RandomSupport random;

    @Override
    IndexType indexType() {
        return IndexType.POINT;
    }

    PointBlockBasedIndexPopulator instantiatePopulator(BlockStorage.Monitor monitor, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker) throws IOException {
        PointBlockBasedIndexPopulator populator = new PointBlockBasedIndexPopulator(this.databaseIndexContext, this.indexFiles, (IndexLayout)LAYOUT, this.INDEX_DESCRIPTOR, SPATIAL_SETTINGS, (SpaceFillingCurveConfiguration)CONFIGURATION, false, bufferFactory, CONFIG, memoryTracker, monitor);
        populator.create();
        return populator;
    }

    PointLayout layout() {
        return LAYOUT;
    }

    @Override
    protected Value supportedValue(int i) {
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{i, i});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    final void shouldIgnoreAddedUnsupportedValueTypes() throws Exception {
        try (PointIndexAccessor accessor = this.pointAccessor();
             BoundedIterable reader = accessor.newAllEntriesValueReader(CursorContext.NULL);){
            Assertions.assertThat((Iterator)reader.iterator()).isExhausted();
        }
        BlockBasedIndexPopulator populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR);
        try {
            LongSupplier idGen = PointBlockBasedIndexPopulatorTest.idGenerator();
            RandomValues randomValues = this.random.randomValues();
            List updates = UNSUPPORTED_TYPES.stream().map(arg_0 -> ((RandomValues)randomValues).nextValueOfType(arg_0)).map(value -> IndexEntryUpdate.add((long)idGen.getAsLong(), (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{value})).collect(Collectors.toUnmodifiableList());
            populator.add(updates, CursorContext.NULL);
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
        try (PointIndexAccessor accessor = this.pointAccessor();
             BoundedIterable reader = accessor.newAllEntriesValueReader(CursorContext.NULL);){
            Assertions.assertThat((Iterator)reader.iterator()).isExhausted();
        }
    }

    private static LongSupplier idGenerator() {
        return new AtomicLong(0L)::incrementAndGet;
    }

    private PointIndexAccessor pointAccessor() {
        RecoveryCleanupWorkCollector cleanup = RecoveryCleanupWorkCollector.immediate();
        return new PointIndexAccessor(this.databaseIndexContext, this.indexFiles, (IndexLayout)LAYOUT, cleanup, this.INDEX_DESCRIPTOR, SPATIAL_SETTINGS, (SpaceFillingCurveConfiguration)CONFIGURATION);
    }
}

