/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulatorUpdatesTest;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.PointBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.PointIndexAccessor;
import org.neo4j.kernel.impl.index.schema.PointKey;
import org.neo4j.kernel.impl.index.schema.PointLayout;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
public class PointBlockBasedIndexPopulatorUpdatesTest
extends BlockBasedIndexPopulatorUpdatesTest<PointKey> {
    private static final StandardConfiguration CONFIGURATION = new StandardConfiguration();
    private static final Config CONFIG = Config.defaults();
    private static final IndexSpecificSpaceFillingCurveSettings SPATIAL_SETTINGS = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)CONFIG);
    private static final PointLayout LAYOUT = new PointLayout(SPATIAL_SETTINGS);
    private static final Set<ValueType> UNSUPPORTED_TYPES = Collections.unmodifiableSet(Arrays.stream(ValueType.values()).filter(type -> type.valueGroup.category() != ValueCategory.GEOMETRY).collect(Collectors.toCollection(() -> EnumSet.noneOf(ValueType.class))));
    @Inject
    private RandomSupport random;

    @Override
    IndexType indexType() {
        return IndexType.POINT;
    }

    @Override
    BlockBasedIndexPopulator<PointKey> instantiatePopulator(IndexDescriptor indexDescriptor) throws IOException {
        PointBlockBasedIndexPopulator populator = new PointBlockBasedIndexPopulator(this.databaseIndexContext, this.indexFiles, (IndexLayout)LAYOUT, indexDescriptor, SPATIAL_SETTINGS, (SpaceFillingCurveConfiguration)CONFIGURATION, false, ByteBufferFactory.heapBufferFactory((int)((int)ByteUnit.kibiBytes((long)40L))), CONFIG, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        populator.create();
        return populator;
    }

    @Override
    Value supportedValue(int identifier) {
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{identifier, identifier});
    }

    @Test
    void shouldIgnoreUnsupportedValueTypesInScan() throws Exception {
        BlockBasedIndexPopulator<PointKey> populator = this.instantiatePopulator(this.INDEX_DESCRIPTOR);
        try {
            UNSUPPORTED_TYPES.forEach(unsupportedType -> {
                ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{this.random.nextValue(unsupportedType)});
                populator.add(Collections.singleton(update), CursorContext.NULL);
            });
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
        try (PointIndexAccessor accessor = this.pointAccessor();
             BoundedIterable reader = accessor.newAllEntriesValueReader(CursorContext.NULL);){
            Assertions.assertThat((Iterator)reader.iterator()).isExhausted();
        }
    }

    @ParameterizedTest
    @EnumSource(value=ScanUpdateOrder.class)
    final void shouldIgnoreAddedUnsupportedValueTypes(ScanUpdateOrder scanUpdateOrder) throws Exception {
        Collection<IndexEntryUpdate<?>> updates = this.generateUpdatesToIgnore((id, value) -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{value}));
        this.test(scanUpdateOrder, updates, 0L);
    }

    @ParameterizedTest
    @EnumSource(value=ScanUpdateOrder.class)
    final void shouldIgnoreRemovedUnsupportedValueTypes(ScanUpdateOrder scanUpdateOrder) throws Exception {
        Collection<IndexEntryUpdate<?>> updates = this.generateUpdatesToIgnore((id, value) -> IndexEntryUpdate.remove((long)id, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{value}));
        this.test(scanUpdateOrder, updates, 0L);
    }

    @ParameterizedTest
    @EnumSource(value=ScanUpdateOrder.class)
    final void shouldIgnoreChangesBetweenUnsupportedValueTypes(ScanUpdateOrder scanUpdateOrder) throws Exception {
        Value otherValue = this.random.randomValues().nextValueOfTypes((ValueType[])UNSUPPORTED_TYPES.toArray(ValueType[]::new));
        Collection<IndexEntryUpdate<?>> updates = this.generateUpdatesToIgnore((id, value) -> IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value)value, (Value)otherValue));
        this.test(scanUpdateOrder, updates, 0L);
    }

    @ParameterizedTest
    @EnumSource(value=ScanUpdateOrder.class)
    final void shouldNotIgnoreChangesUnsupportedValueTypesToSupportedValueTypes(ScanUpdateOrder scanUpdateOrder) throws Exception {
        Value supportedValue = this.supportedValue(this.random.nextInt());
        Collection<IndexEntryUpdate<?>> updates = this.generateUpdatesToIgnore((id, value) -> IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value)value, (Value)supportedValue));
        this.test(scanUpdateOrder, updates, updates.size());
    }

    @ParameterizedTest
    @EnumSource(value=ScanUpdateOrder.class)
    final void shouldNotIgnoreChangesSupportedValueTypesToUnsupportedValueTypes(ScanUpdateOrder scanUpdateOrder) throws Exception {
        Value supportedValue = this.supportedValue(this.random.nextInt());
        Collection<IndexEntryUpdate<?>> updates = this.generateUpdatesToIgnore((id, value) -> IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value)supportedValue, (Value)value));
        this.test(scanUpdateOrder, updates, updates.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(ScanUpdateOrder scanUpdateOrder, Collection<IndexEntryUpdate<?>> updates, long expectedUpdateCount) throws Exception {
        try (PointIndexAccessor accessor = this.pointAccessor();
             BoundedIterable reader = accessor.newAllEntriesValueReader(CursorContext.NULL);){
            Assertions.assertThat((Iterator)reader.iterator()).isExhausted();
        }
        BlockBasedIndexPopulator<PointKey> populator = this.instantiatePopulator(this.INDEX_DESCRIPTOR);
        scanUpdateOrder.beforeUpdates((IndexPopulator)populator, this.populationWorkScheduler);
        try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
            for (IndexEntryUpdate<?> update : updates) {
                updater.process(update);
            }
            scanUpdateOrder.afterUpdates((IndexPopulator)populator, this.populationWorkScheduler);
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
        IndexSample sample = populator.sample(CursorContext.NULL);
        Assertions.assertThat((long)sample.indexSize()).isEqualTo(0L);
        Assertions.assertThat((long)sample.updates()).isEqualTo(expectedUpdateCount);
    }

    private Collection<IndexEntryUpdate<?>> generateUpdatesToIgnore(BiFunction<Long, Value, IndexEntryUpdate<?>> updateFunction) {
        LongSupplier idGen = PointBlockBasedIndexPopulatorUpdatesTest.idGenerator();
        RandomValues randomValues = this.random.randomValues();
        return UNSUPPORTED_TYPES.stream().map(arg_0 -> ((RandomValues)randomValues).nextValueOfType(arg_0)).map(value -> (IndexEntryUpdate)updateFunction.apply(idGen.getAsLong(), (Value)value)).collect(Collectors.toUnmodifiableList());
    }

    private static LongSupplier idGenerator() {
        return new AtomicLong(0L)::incrementAndGet;
    }

    private PointIndexAccessor pointAccessor() {
        RecoveryCleanupWorkCollector cleanup = RecoveryCleanupWorkCollector.immediate();
        return new PointIndexAccessor(this.databaseIndexContext, this.indexFiles, (IndexLayout)LAYOUT, cleanup, this.INDEX_DESCRIPTOR, SPATIAL_SETTINGS, (SpaceFillingCurveConfiguration)CONFIGURATION);
    }

    private static enum ScanUpdateOrder {
        UPDATES_BEFORE_SCAN_COMPLETE{

            @Override
            void beforeUpdates(IndexPopulator populator, IndexPopulator.PopulationWorkScheduler populationWorkScheduler) {
            }

            @Override
            void afterUpdates(IndexPopulator populator, IndexPopulator.PopulationWorkScheduler populationWorkScheduler) throws IndexEntryConflictException {
                populator.scanCompleted(PhaseTracker.nullInstance, populationWorkScheduler, CursorContext.NULL);
            }
        }
        ,
        UPDATES_AFTER_SCAN_COMPLETE{

            @Override
            void beforeUpdates(IndexPopulator populator, IndexPopulator.PopulationWorkScheduler populationWorkScheduler) throws IndexEntryConflictException {
                populator.scanCompleted(PhaseTracker.nullInstance, populationWorkScheduler, CursorContext.NULL);
            }

            @Override
            void afterUpdates(IndexPopulator populator, IndexPopulator.PopulationWorkScheduler populationWorkScheduler) {
            }
        };


        abstract void beforeUpdates(IndexPopulator var1, IndexPopulator.PopulationWorkScheduler var2) throws IndexEntryConflictException;

        abstract void afterUpdates(IndexPopulator var1, IndexPopulator.PopulationWorkScheduler var2) throws IndexEntryConflictException;
    }
}

