/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessorTests;
import org.neo4j.kernel.impl.index.schema.PointIndexAccessor;
import org.neo4j.kernel.impl.index.schema.PointIndexProvider;
import org.neo4j.kernel.impl.index.schema.PointKey;
import org.neo4j.kernel.impl.index.schema.PointLayout;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

class PointIndexAccessorTest
extends NativeIndexAccessorTests<PointKey> {
    private static final IndexSpecificSpaceFillingCurveSettings SPACE_FILLING_CURVE_SETTINGS = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    private static final StandardConfiguration CONFIGURATION = new StandardConfiguration();
    private static final IndexDescriptor INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)42, (int[])new int[]{666})).withIndexType(IndexType.POINT).withIndexProvider(PointIndexProvider.DESCRIPTOR).withName("index").materialise(0L);
    private static final PointLayout LAYOUT = new PointLayout(SPACE_FILLING_CURVE_SETTINGS);
    private static final ValueType[] SUPPORTED_TYPES = (ValueType[])Stream.of(ValueType.values()).filter(type -> type.valueGroup.category() == ValueCategory.GEOMETRY).toArray(ValueType[]::new);
    private static final ValueType[] UNSUPPORTED_TYPES = (ValueType[])Stream.of(ValueType.values()).filter(type -> type.valueGroup.category() != ValueCategory.GEOMETRY).toArray(ValueType[]::new);

    PointIndexAccessorTest() {
    }

    @Override
    ValueCreatorUtil<PointKey> createValueCreatorUtil() {
        return new ValueCreatorUtil<PointKey>(INDEX_DESCRIPTOR, SUPPORTED_TYPES, 0.1);
    }

    @Override
    boolean supportsGeometryRangeQueries() {
        return true;
    }

    @Override
    IndexAccessor createAccessor(PageCache pageCache) {
        RecoveryCleanupWorkCollector cleanup = RecoveryCleanupWorkCollector.immediate();
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").withReadOnlyChecker(DatabaseReadOnlyChecker.writable()).build();
        return new PointIndexAccessor(context, this.indexFiles, (IndexLayout)this.layout, cleanup, INDEX_DESCRIPTOR, SPACE_FILLING_CURVE_SETTINGS, (SpaceFillingCurveConfiguration)CONFIGURATION);
    }

    @Override
    IndexDescriptor indexDescriptor() {
        return INDEX_DESCRIPTOR;
    }

    @Override
    PointLayout layout() {
        return LAYOUT;
    }

    @ParameterizedTest
    @MethodSource(value={"unsupportedPredicates"})
    void readerShouldThrowOnUnsupportedPredicates(PropertyIndexQuery predicate) {
        try (ValueIndexReader reader = this.accessor.newValueReader();){
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> reader.query((IndexProgressor.EntityValueClient)new SimpleEntityValueClient(), QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.ACCESS, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{predicate}), (String)"%s is an unsupported query", (Object[])new Object[]{predicate}).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Tried to query index with illegal query. Only %s, %s, and %s %s queries are supported by a point index", new Object[]{IndexQuery.IndexQueryType.ALL_ENTRIES, IndexQuery.IndexQueryType.EXACT, ValueGroup.GEOMETRY, IndexQuery.IndexQueryType.RANGE});
        }
    }

    @ParameterizedTest
    @MethodSource(value={"unsupportedOrders"})
    void readerShouldThrowOnUnsupportedOrder(IndexOrder indexOrder) {
        try (ValueIndexReader reader = this.accessor.newValueReader();){
            PropertyIndexQuery.ExactPredicate query = PropertyIndexQuery.exact((int)0, (Object)PointValue.MAX_VALUE);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> reader.query((IndexProgressor.EntityValueClient)new SimpleEntityValueClient(), QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.ACCESS, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)false), new PropertyIndexQuery[]{query}), (String)"order is not supported with point index", (Object[])new Object[0]).isInstanceOf(IllegalArgumentException.class)).hasMessageContainingAll(new CharSequence[]{"Tried to query a point index with order", "Order is not supported by a point index"});
        }
    }

    @ParameterizedTest
    @MethodSource(value={"unsupportedTypes"})
    void updaterShouldIgnoreUnsupportedTypes(ValueType unsupportedType) throws Exception {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            Value unsupportedValue = this.random.randomValues().nextValueOfType(unsupportedType);
            updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)PointIndexAccessorTest.idGenerator().getAsLong(), (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{unsupportedValue}));
        }
        try (BoundedIterable reader = this.accessor.newAllEntriesValueReader(CursorContext.NULL);){
            Assertions.assertThat((Iterable)reader).isEmpty();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"unsupportedTypes"})
    void updaterShouldChangeUnsupportedToSupportedByAdd(ValueType unsupportedType) throws Exception {
        long entityId = PointIndexAccessorTest.idGenerator().getAsLong();
        Value unsupportedValue = this.random.randomValues().nextValueOfType(unsupportedType);
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)entityId, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{unsupportedValue}));
        }
        try (BoundedIterable reader = this.accessor.newAllEntriesValueReader(CursorContext.NULL);){
            Assertions.assertThat((Iterable)reader).isEmpty();
        }
        updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
        try {
            Value supportedValue = this.random.randomValues().nextValueOfTypes(SUPPORTED_TYPES);
            updater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)entityId, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value)unsupportedValue, (Value)supportedValue));
        }
        finally {
            if (updater != null) {
                updater.close();
            }
        }
        reader = this.accessor.newAllEntriesValueReader(CursorContext.NULL);
        try {
            Assertions.assertThat((Iterable)reader).containsExactlyInAnyOrder((Object[])new Long[]{entityId});
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"unsupportedTypes"})
    void updaterShouldChangeSupportedToUnsupportedByRemove(ValueType unsupportedType) throws Exception {
        long entityId = PointIndexAccessorTest.idGenerator().getAsLong();
        Value supportedValue = this.random.randomValues().nextValueOfTypes(SUPPORTED_TYPES);
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)entityId, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{supportedValue}));
        }
        try (BoundedIterable reader = this.accessor.newAllEntriesValueReader(CursorContext.NULL);){
            Assertions.assertThat((Iterable)reader).containsExactlyInAnyOrder((Object[])new Long[]{entityId});
        }
        updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
        try {
            Value unsupportedValue = this.random.randomValues().nextValueOfType(unsupportedType);
            updater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)entityId, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value)supportedValue, (Value)unsupportedValue));
        }
        finally {
            if (updater != null) {
                updater.close();
            }
        }
        reader = this.accessor.newAllEntriesValueReader(CursorContext.NULL);
        try {
            Assertions.assertThat((Iterable)reader).isEmpty();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static LongSupplier idGenerator() {
        return new AtomicLong(0L)::incrementAndGet;
    }

    private static Stream<PropertyIndexQuery> unsupportedPredicates() {
        return Stream.of(PropertyIndexQuery.exists((int)0), PropertyIndexQuery.range((int)0, (ValueGroup)ValueGroup.UNKNOWN), PropertyIndexQuery.stringPrefix((int)0, (TextValue)Values.stringValue((String)"myValue")), PropertyIndexQuery.stringSuffix((int)0, (TextValue)Values.stringValue((String)"myValue")), PropertyIndexQuery.stringContains((int)0, (TextValue)Values.stringValue((String)"myValue")), PropertyIndexQuery.fulltextSearch((String)"myValue"));
    }

    private static Stream<IndexOrder> unsupportedOrders() {
        return Stream.of(IndexOrder.DESCENDING, IndexOrder.ASCENDING);
    }

    private static Stream<ValueType> unsupportedTypes() {
        return Arrays.stream(UNSUPPORTED_TYPES);
    }
}

