/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.index.schema.SpatialIndexConfig;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.CoordinateReferenceSystem;

@ExtendWith(value={RandomExtension.class})
class SpatialIndexConfigTest {
    @Inject
    RandomSupport random;

    SpatialIndexConfigTest() {
    }

    @Test
    void mustAddSpatialConfigToMap() {
        HashMap map = new HashMap();
        for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
            Config config = Config.defaults();
            SpaceFillingCurveSettings spaceFillingCurveSettings = new ConfiguredSpaceFillingCurveSettingsCache(config).forCRS(crs);
            SpatialIndexConfig.addSpatialConfig(map, (CoordinateReferenceSystem)crs, (SpaceFillingCurveSettings)spaceFillingCurveSettings);
            Assertions.assertNotNull(map.remove(IndexSettingUtil.spatialMinSettingForCrs((CoordinateReferenceSystem)crs).getSettingName()));
            Assertions.assertNotNull(map.remove(IndexSettingUtil.spatialMaxSettingForCrs((CoordinateReferenceSystem)crs).getSettingName()));
            Assertions.assertTrue((boolean)map.isEmpty());
        }
    }

    @Test
    void mustAddAndExtractSpatialConfigToIndexConfig() {
        IndexConfig indexConfig = IndexConfig.empty();
        HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> expectedMap = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
        for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
            Config config = Config.defaults();
            SpaceFillingCurveSettings spaceFillingCurveSettings = new ConfiguredSpaceFillingCurveSettingsCache(config).forCRS(crs);
            expectedMap.put(crs, spaceFillingCurveSettings);
            indexConfig = SpatialIndexConfig.addSpatialConfig((IndexConfig)indexConfig, (CoordinateReferenceSystem)crs, (SpaceFillingCurveSettings)spaceFillingCurveSettings);
        }
        Map extractedMap = SpatialIndexConfig.extractSpatialConfig((IndexConfig)indexConfig);
        Assertions.assertEquals(expectedMap, (Object)extractedMap);
    }
}

