/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.BitSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeBuilder;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.EntityRange;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.DefaultTokenIndexReader;
import org.neo4j.kernel.impl.index.schema.TokenIndex;
import org.neo4j.kernel.impl.index.schema.TokenIndexUpdater;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityTokenClient;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@ExtendWith(value={RandomExtension.class})
@PageCacheExtension
class TokenIndexReaderTest {
    @Inject
    private RandomSupport random;
    @Inject
    private PageCache pageCache;
    @Inject
    private TestDirectory directory;
    private GBPTree<TokenScanKey, TokenScanValue> tree;

    TokenIndexReaderTest() {
    }

    @BeforeEach
    void openTree() {
        this.tree = new GBPTreeBuilder(this.pageCache, this.directory.file("file"), (Layout)new TokenScanLayout()).build();
    }

    @AfterEach
    void closeTree() throws IOException {
        this.tree.close();
    }

    @Test
    void shouldTracePageCacheAccess() throws Exception {
        int expectedNodes = 5;
        int labelId = 1;
        try (TokenIndexUpdater writer = new TokenIndexUpdater(expectedNodes, TokenIndex.EMPTY);){
            writer.initialize(this.tree.writer(CursorContext.NULL));
            for (int i = 0; i < expectedNodes; ++i) {
                writer.process((IndexEntryUpdate)TokenIndexEntryUpdate.change((long)i, null, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId}));
            }
        }
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        CursorContext cursorContext = new CursorContext(cacheTracer.createPageCursorTracer("tracePageCache"));
        DefaultTokenIndexReader reader = new DefaultTokenIndexReader(this.tree);
        SimpleEntityTokenClient tokenClient = new SimpleEntityTokenClient();
        reader.query((IndexProgressor.EntityTokenClient)tokenClient, IndexQueryConstraints.unconstrained(), new TokenPredicate(labelId), cursorContext);
        int actualNodes = 0;
        while (tokenClient.next()) {
            ++actualNodes;
        }
        Assertions.assertThat((int)actualNodes).isEqualTo(expectedNodes);
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(1L);
        Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(1L);
        Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(1L);
        Assertions.assertThat((long)cursorTracer.faults()).isEqualTo(0L);
    }

    @Test
    void shouldStartFromGivenIdDense() throws IOException, IndexEntryConflictException {
        this.shouldStartFromGivenId(10);
    }

    @Test
    void shouldStartFromGivenIdSparse() throws IOException, IndexEntryConflictException {
        this.shouldStartFromGivenId(100);
    }

    @Test
    void shouldStartFromGivenIdSuperSparse() throws IOException, IndexEntryConflictException {
        this.shouldStartFromGivenId(1000);
    }

    private void shouldStartFromGivenId(int sparsity) throws IOException, IndexEntryConflictException {
        int labelId = 1;
        int highNodeId = 100000;
        BitSet expected = new BitSet(highNodeId);
        try (TokenIndexUpdater writer = new TokenIndexUpdater(highNodeId, TokenIndex.EMPTY);){
            writer.initialize(this.tree.writer(CursorContext.NULL));
            int updates = highNodeId / sparsity;
            for (int i = 0; i < updates; ++i) {
                int nodeId = this.random.nextInt(highNodeId);
                writer.process((IndexEntryUpdate)TokenIndexEntryUpdate.change((long)nodeId, null, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId}));
                expected.set(nodeId);
            }
        }
        long fromId = this.random.nextInt(highNodeId);
        int nextExpectedId = expected.nextSetBit(Math.toIntExact(fromId));
        DefaultTokenIndexReader reader = new DefaultTokenIndexReader(this.tree);
        SimpleEntityTokenClient tokenClient = new SimpleEntityTokenClient();
        reader.query((IndexProgressor.EntityTokenClient)tokenClient, IndexQueryConstraints.unconstrained(), new TokenPredicate(labelId), EntityRange.from((long)fromId), CursorContext.NULL);
        while (nextExpectedId != -1) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tokenClient.next());
            Assertions.assertThat((int)Math.toIntExact(tokenClient.reference)).isEqualTo(nextExpectedId);
            nextExpectedId = expected.nextSetBit(nextExpectedId + 1);
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tokenClient.next());
    }
}

