/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.kernel.impl.index.schema.TokenScanWriteMonitor;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
class TokenScanWriteMonitorTest {
    @Inject
    private DefaultFileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private RandomSupport random;
    private String baseName;

    TokenScanWriteMonitorTest() {
    }

    @BeforeEach
    void before() {
        this.baseName = TokenScanWriteMonitor.writeLogBaseFile((DatabaseLayout)this.databaseLayout, (EntityType)EntityType.NODE).getFileName().toString();
    }

    @Test
    void shouldRotateExistingFileOnOpen() throws IOException {
        Config config = Config.defaults();
        TokenScanWriteMonitor writeMonitor = new TokenScanWriteMonitor((FileSystemAbstraction)this.fs, this.databaseLayout, EntityType.NODE, config);
        writeMonitor.close();
        TokenScanWriteMonitor secondWriteMonitor = new TokenScanWriteMonitor((FileSystemAbstraction)this.fs, this.databaseLayout, EntityType.NODE, config);
        secondWriteMonitor.close();
        long count = 0L;
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(this.databaseLayout.databaseDirectory(), this.baseName + "*");){
            for (Path path : paths) {
                ++count;
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)count);
    }

    @Test
    void shouldLogAndDumpData() throws IOException {
        TokenScanWriteMonitor writeMonitor = new TokenScanWriteMonitor((FileSystemAbstraction)this.fs, this.databaseLayout, EntityType.NODE, Config.defaults());
        TokenScanValue value = new TokenScanValue();
        writeMonitor.range(3L, 0);
        writeMonitor.prepareAdd(123L, 4);
        writeMonitor.prepareAdd(123L, 5);
        writeMonitor.mergeAdd(new TokenScanValue(), value.set(4).set(5));
        writeMonitor.flushPendingUpdates();
        writeMonitor.prepareRemove(124L, 5);
        writeMonitor.mergeRemove(value, new TokenScanValue().set(5));
        writeMonitor.writeSessionEnded();
        writeMonitor.range(5L, 1);
        writeMonitor.prepareAdd(125L, 10);
        writeMonitor.mergeAdd(new TokenScanValue().set(9), new TokenScanValue().set(10));
        writeMonitor.flushPendingUpdates();
        writeMonitor.writeSessionEnded();
        writeMonitor.close();
        TokenScanWriteMonitor.Dumper dumper = (TokenScanWriteMonitor.Dumper)Mockito.mock(TokenScanWriteMonitor.Dumper.class);
        TokenScanWriteMonitor.dump((FileSystemAbstraction)this.fs, (DatabaseLayout)this.databaseLayout, (TokenScanWriteMonitor.Dumper)dumper, null, (EntityType)EntityType.NODE);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{dumper});
        ((TokenScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).prepare(true, 0L, 0L, 123L, 196L, 0);
        ((TokenScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).prepare(true, 0L, 0L, 123L, 197L, 0);
        ((TokenScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).merge(true, 0L, 0L, 3L, 0, 0L, 48L);
        ((TokenScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).prepare(false, 0L, 1L, 124L, 197L, 0);
        ((TokenScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).merge(false, 0L, 1L, 3L, 0, 48L, 32L);
        ((TokenScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).prepare(true, 1L, 0L, 125L, 330L, 1);
        ((TokenScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).merge(true, 1L, 0L, 5L, 1, 512L, 1024L);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldParseSimpleSingleTxFilter() {
        TokenScanWriteMonitor.TxFilter txFilter = TokenScanWriteMonitor.parseTxFilter((String)"123");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)txFilter.contains(122L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(123L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)txFilter.contains(124L));
    }

    @Test
    void shouldParseRangedSingleTxFilter() {
        TokenScanWriteMonitor.TxFilter txFilter = TokenScanWriteMonitor.parseTxFilter((String)"123-126");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)txFilter.contains(122L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(123L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(124L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(125L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(126L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)txFilter.contains(127L));
    }

    @Test
    void shouldParseSimpleMultipleTxFilters() {
        TokenScanWriteMonitor.TxFilter txFilter = TokenScanWriteMonitor.parseTxFilter((String)"123,146,123456");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)txFilter.contains(122L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(123L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(146L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(123456L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)txFilter.contains(147L));
    }

    @Test
    void shouldParseRangedMultipleTxFilters() {
        TokenScanWriteMonitor.TxFilter txFilter = TokenScanWriteMonitor.parseTxFilter((String)"123-125,345-567");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)txFilter.contains(122L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(123L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(124L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(125L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)txFilter.contains(201L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(345L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(405L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txFilter.contains(567L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)txFilter.contains(568L));
    }

    @Test
    void shouldRotateAtConfiguredThreshold() throws IOException {
        Path storeDir = this.databaseLayout.databaseDirectory();
        int rotationThreshold = 1000;
        RecordingMonitor monitor = new RecordingMonitor();
        TokenScanWriteMonitor writeMonitor = new TokenScanWriteMonitor((FileSystemAbstraction)this.fs, this.databaseLayout, (long)rotationThreshold, ByteUnit.Byte, 1L, TimeUnit.DAYS, EntityType.NODE, (TokenScanWriteMonitor.Monitor)monitor, Clocks.nanoClock());
        int i = 0;
        while (TokenScanWriteMonitorTest.numberOfFilesIn(storeDir) < 5L) {
            writeMonitor.range((long)i, 1);
            writeMonitor.prepareAdd((long)i, 5);
            writeMonitor.mergeAdd(new TokenScanValue(), new TokenScanValue().set(5));
            writeMonitor.writeSessionEnded();
            ++i;
        }
        writeMonitor.close();
        Assertions.assertThat(monitor.rotations).isNotEmpty();
        monitor.rotations.forEach(e -> Assertions.assertThat((long)e.fileSize).isGreaterThanOrEqualTo((long)rotationThreshold));
    }

    @Test
    void shouldPruneAtConfiguredThreshold() {
        long pruneThreshold = 200L;
        RecordingMonitor monitor = new RecordingMonitor();
        FakeClock clock = Clocks.fakeClock();
        TokenScanWriteMonitor writeMonitor = new TokenScanWriteMonitor((FileSystemAbstraction)this.fs, this.databaseLayout, 500L, ByteUnit.Byte, pruneThreshold, TimeUnit.MILLISECONDS, EntityType.NODE, (TokenScanWriteMonitor.Monitor)monitor, (SystemNanoClock)clock);
        long startTime = clock.millis();
        long endTime = startTime + TimeUnit.SECONDS.toMillis(1L);
        int i = 0;
        while (clock.millis() < endTime) {
            long timeLeft = endTime - clock.millis();
            clock.forward(Long.min(timeLeft, this.random.nextInt(1, 10)), TimeUnit.MILLISECONDS);
            writeMonitor.range((long)i, 1);
            writeMonitor.prepareAdd((long)i, 5);
            writeMonitor.mergeAdd(new TokenScanValue(), new TokenScanValue().set(5));
            writeMonitor.writeSessionEnded();
            ++i;
        }
        writeMonitor.close();
        List<Entry> remainingFiles = monitor.rotations.stream().filter(r -> monitor.prunes.stream().noneMatch(p -> r.timestamp == p.timestamp)).collect(Collectors.toList());
        Assertions.assertThat(remainingFiles).isNotEmpty();
        Assertions.assertThat((int)monitor.rotations.size()).isGreaterThan(remainingFiles.size());
        Assertions.assertThat(monitor.prunes).isNotEmpty();
        remainingFiles.forEach(e -> Assertions.assertThat((long)(endTime - e.timestamp)).isLessThan(pruneThreshold * 2L));
    }

    @Test
    void shouldUseTargetRelationshipTypeScanStoreIfEntityTypeRelationship() throws IOException {
        Assertions.assertThat((int)this.fs.listFiles(this.databaseLayout.databaseDirectory()).length).isEqualTo(0);
        TokenScanWriteMonitor writeMonitor = new TokenScanWriteMonitor((FileSystemAbstraction)this.fs, this.databaseLayout, EntityType.RELATIONSHIP, Config.defaults());
        writeMonitor.close();
        List<Path> filesAfter = Arrays.asList(this.fs.listFiles(this.databaseLayout.databaseDirectory()));
        Assertions.assertThat((int)filesAfter.size()).isEqualTo(1);
        Assertions.assertThat((String)filesAfter.get(0).getFileName().toString()).contains(new CharSequence[]{this.databaseLayout.relationshipTypeScanStore().getFileName().toString()});
    }

    private static long numberOfFilesIn(Path storeDir) throws IOException {
        try (Stream<Path> list = Files.list(storeDir);){
            long l = list.count();
            return l;
        }
    }

    private static class Entry {
        private final long timestamp;
        private final long fileSize;

        Entry(long timestamp, long fileSize) {
            this.timestamp = timestamp;
            this.fileSize = fileSize;
        }
    }

    private static class RecordingMonitor
    implements TokenScanWriteMonitor.Monitor {
        private final List<Entry> rotations = new ArrayList<Entry>();
        private final List<Entry> prunes = new ArrayList<Entry>();

        private RecordingMonitor() {
        }

        public void rotated(Path file, long timestamp, long fileSize) {
            this.rotations.add(new Entry(timestamp, fileSize));
        }

        public void pruned(Path file, long timestamp) {
            this.prunes.add(new Entry(timestamp, 0L));
        }
    }
}

