/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.EnumMap;
import java.util.function.Function;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

abstract class FusionIndexUpdaterTest {
    private final FusionVersion fusionVersion;
    private IndexUpdater[] aliveUpdaters;
    private EnumMap<IndexSlot, IndexUpdater> updaters;
    private FusionIndexUpdater fusionIndexUpdater;
    private static final Function<IndexSlot, IndexUpdater> THROWING_FACTORY = i -> {
        throw new IllegalStateException("All updaters should exist already");
    };

    FusionIndexUpdaterTest(FusionVersion fusionVersion) {
        this.fusionVersion = fusionVersion;
    }

    @BeforeEach
    void setup() {
        this.initiateMocks();
    }

    private void initiateMocks() {
        IndexSlot[] activeSlots = this.fusionVersion.aliveSlots();
        this.updaters = new EnumMap(IndexSlot.class);
        FusionIndexTestHelp.fill(this.updaters, SwallowingIndexUpdater.INSTANCE);
        this.aliveUpdaters = new IndexUpdater[activeSlots.length];
        block4: for (int i = 0; i < activeSlots.length; ++i) {
            IndexUpdater mock;
            this.aliveUpdaters[i] = mock = (IndexUpdater)Mockito.mock(IndexUpdater.class);
            switch (activeSlots[i]) {
                case GENERIC: {
                    this.updaters.put(IndexSlot.GENERIC, mock);
                    continue block4;
                }
                case LUCENE: {
                    this.updaters.put(IndexSlot.LUCENE, mock);
                    continue block4;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexUpdater = new FusionIndexUpdater(this.fusionVersion.slotSelector(), new LazyInstanceSelector(this.updaters, THROWING_FACTORY));
    }

    private void resetMocks() {
        for (IndexUpdater updater : this.aliveUpdaters) {
            Mockito.reset((Object[])new IndexUpdater[]{updater});
        }
    }

    @Test
    void processMustSelectCorrectForAdd() throws Exception {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (IndexSlot indexSlot : IndexSlot.values()) {
            for (Value value : values.get(indexSlot)) {
                this.verifyAddWithCorrectUpdater(this.orLucene(this.updaters.get(indexSlot)), value);
            }
        }
        for (IndexSlot indexSlot : allValues) {
            for (Value secondValue : allValues) {
                this.verifyAddWithCorrectUpdater(this.updaters.get(IndexSlot.GENERIC), new Value[]{indexSlot, secondValue});
            }
        }
    }

    @Test
    void processMustSelectCorrectForRemove() throws Exception {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (IndexSlot indexSlot : IndexSlot.values()) {
            for (Value value : values.get(indexSlot)) {
                this.verifyRemoveWithCorrectUpdater(this.orLucene(this.updaters.get(indexSlot)), value);
            }
        }
        for (IndexSlot indexSlot : allValues) {
            for (Value secondValue : allValues) {
                this.verifyRemoveWithCorrectUpdater(this.updaters.get(IndexSlot.GENERIC), new Value[]{indexSlot, secondValue});
            }
        }
    }

    @Test
    void processMustSelectCorrectForChange() throws Exception {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        for (IndexSlot slot : IndexSlot.values()) {
            for (Value before : values.get(slot)) {
                for (Value after : values.get(slot)) {
                    this.verifyChangeWithCorrectUpdaterNotMixed(this.orLucene(this.updaters.get(slot)), before, after);
                }
            }
        }
    }

    @Test
    void processMustSelectCorrectForChangeFromOneGroupToAnother() throws Exception {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        for (IndexSlot from : IndexSlot.values()) {
            for (IndexSlot to : IndexSlot.values()) {
                if (from != to) {
                    this.verifyChangeWithCorrectUpdaterMixed(this.orLucene(this.updaters.get(from)), this.orLucene(this.updaters.get(to)), values.get(from), values.get(to));
                } else {
                    this.verifyChangeWithCorrectUpdaterNotMixed(this.orLucene(this.updaters.get(from)), values.get(from));
                }
                this.resetMocks();
            }
        }
    }

    private IndexUpdater orLucene(IndexUpdater updater) {
        return updater != SwallowingIndexUpdater.INSTANCE ? updater : this.updaters.get(IndexSlot.LUCENE);
    }

    private void verifyAddWithCorrectUpdater(IndexUpdater correctPopulator, Value ... numberValues) throws IndexEntryConflictException {
        ValueIndexEntryUpdate<SchemaDescriptorSupplier> update = FusionIndexTestHelp.add(numberValues);
        this.fusionIndexUpdater.process(update);
        ((IndexUpdater)Mockito.verify((Object)correctPopulator)).process(update);
        for (IndexUpdater populator : this.aliveUpdaters) {
            if (populator == correctPopulator) continue;
            ((IndexUpdater)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).process(update);
        }
    }

    private void verifyRemoveWithCorrectUpdater(IndexUpdater correctPopulator, Value ... numberValues) throws IndexEntryConflictException {
        ValueIndexEntryUpdate<SchemaDescriptorSupplier> update = FusionIndexTestHelp.remove(numberValues);
        this.fusionIndexUpdater.process(update);
        ((IndexUpdater)Mockito.verify((Object)correctPopulator)).process(update);
        for (IndexUpdater populator : this.aliveUpdaters) {
            if (populator == correctPopulator) continue;
            ((IndexUpdater)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).process(update);
        }
    }

    private void verifyChangeWithCorrectUpdaterNotMixed(IndexUpdater correctPopulator, Value before, Value after) throws IndexEntryConflictException {
        ValueIndexEntryUpdate<SchemaDescriptorSupplier> update = FusionIndexTestHelp.change(before, after);
        this.fusionIndexUpdater.process(update);
        ((IndexUpdater)Mockito.verify((Object)correctPopulator)).process(update);
        for (IndexUpdater populator : this.aliveUpdaters) {
            if (populator == correctPopulator) continue;
            ((IndexUpdater)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).process(update);
        }
    }

    private void verifyChangeWithCorrectUpdaterNotMixed(IndexUpdater updater, Value[] supportedValues) throws IndexEntryConflictException {
        for (Value before : supportedValues) {
            for (Value after : supportedValues) {
                this.verifyChangeWithCorrectUpdaterNotMixed(updater, before, after);
            }
        }
    }

    private void verifyChangeWithCorrectUpdaterMixed(IndexUpdater expectRemoveFrom, IndexUpdater expectAddTo, Value[] beforeValues, Value[] afterValues) throws IndexEntryConflictException {
        for (int beforeIndex = 0; beforeIndex < beforeValues.length; ++beforeIndex) {
            Value before = beforeValues[beforeIndex];
            for (int afterIndex = 0; afterIndex < afterValues.length; ++afterIndex) {
                Value after = afterValues[afterIndex];
                ValueIndexEntryUpdate<SchemaDescriptorSupplier> change = FusionIndexTestHelp.change(before, after);
                this.fusionIndexUpdater.process(change);
                if (expectRemoveFrom != expectAddTo) {
                    ((IndexUpdater)Mockito.verify((Object)expectRemoveFrom, (VerificationMode)Mockito.times((int)(afterIndex + 1)))).process(FusionIndexTestHelp.remove(before));
                    ((IndexUpdater)Mockito.verify((Object)expectAddTo, (VerificationMode)Mockito.times((int)(beforeIndex + 1)))).process(FusionIndexTestHelp.add(after));
                    continue;
                }
                ((IndexUpdater)Mockito.verify((Object)expectRemoveFrom)).process(FusionIndexTestHelp.change(before, after));
            }
        }
    }

    @Test
    void closeMustCloseAll() throws Exception {
        this.fusionIndexUpdater.close();
        for (IndexUpdater updater : this.aliveUpdaters) {
            ((IndexUpdater)Mockito.verify((Object)updater)).close();
        }
    }

    @Test
    void closeMustThrowIfAnyThrow() throws Exception {
        for (IndexSlot indexSlot : this.fusionVersion.aliveSlots()) {
            FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow((AutoCloseable)this.updaters.get(indexSlot), (AutoCloseable)this.fusionIndexUpdater);
            this.initiateMocks();
        }
    }

    @Test
    void closeMustCloseOthersIfAnyThrow() throws Exception {
        for (IndexSlot indexSlot : this.fusionVersion.aliveSlots()) {
            IndexUpdater failingUpdater = this.updaters.get(indexSlot);
            FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)failingUpdater, (AutoCloseable)this.fusionIndexUpdater, (AutoCloseable[])ArrayUtil.without((Object[])this.aliveUpdaters, (Object[])new IndexUpdater[]{failingUpdater}));
            this.initiateMocks();
        }
    }

    @Test
    void closeMustThrowIfAllThrow() throws Exception {
        FusionIndexTestHelp.verifyFusionCloseThrowIfAllThrow((AutoCloseable)this.fusionIndexUpdater, (AutoCloseable[])this.aliveUpdaters);
    }

    @Test
    void shouldInstantiatePartLazilyForSpecificValueGroupUpdates() throws IndexEntryConflictException {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        for (IndexSlot i : IndexSlot.values()) {
            if (this.updaters.get(i) != SwallowingIndexUpdater.INSTANCE) {
                Value value = values.get(i)[0];
                this.fusionIndexUpdater.process(FusionIndexTestHelp.add(value));
                for (IndexSlot j : IndexSlot.values()) {
                    if (this.updaters.get(j) == SwallowingIndexUpdater.INSTANCE) continue;
                    if (i == j) {
                        ((IndexUpdater)Mockito.verify((Object)this.updaters.get(i))).process((IndexEntryUpdate)ArgumentMatchers.any(IndexEntryUpdate.class));
                        continue;
                    }
                    Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updaters.get(j)});
                }
            }
            this.initiateMocks();
        }
    }
}

