/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;

class InstanceSelectorTest {
    InstanceSelectorTest() {
    }

    @Test
    void shouldSelect() {
        InstanceSelector<String> selector = InstanceSelectorTest.selector(IndexSlot.LUCENE, "0", IndexSlot.GENERIC, "1");
        String select0 = (String)selector.select(IndexSlot.LUCENE);
        Assertions.assertEquals((Object)"0", (Object)select0);
        String select1 = (String)selector.select(IndexSlot.GENERIC);
        Assertions.assertEquals((Object)"1", (Object)select1);
    }

    @Test
    void shouldThrowOnNonInstantiatedSelect() {
        InstanceSelector<String> selector = InstanceSelectorTest.selector(IndexSlot.LUCENE, "0");
        Assertions.assertThrows(IllegalStateException.class, () -> selector.select(IndexSlot.GENERIC));
    }

    @Test
    void shouldThrowOnNonInstantiatedFlatMap() {
        InstanceSelector<String> selector = InstanceSelectorTest.selector(IndexSlot.LUCENE, "0");
        Assertions.assertThrows(IllegalStateException.class, () -> selector.transform(Integer::parseInt));
    }

    @Test
    void shouldThrowOnNonInstantiatedMap() {
        InstanceSelector<String> selector = InstanceSelectorTest.selector(IndexSlot.LUCENE, "0");
        Assertions.assertThrows(IllegalStateException.class, () -> selector.map(Integer::parseInt));
    }

    @Test
    void shouldFlatMap() {
        InstanceSelector<String> selector = InstanceSelectorTest.selectorFilledWithOrdinal();
        List actual = Iterables.asList((Iterable)selector.transform(Integer::parseInt));
        List expected = Arrays.stream(IndexSlot.values()).map(Enum::ordinal).collect(Collectors.toList());
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        for (Integer i : expected) {
            Assertions.assertTrue((boolean)actual.contains(i));
        }
    }

    @Test
    void shouldMap() {
        InstanceSelector<String> selector = InstanceSelectorTest.selectorFilledWithOrdinal();
        EnumMap actual = selector.map(Integer::parseInt);
        for (IndexSlot slot : IndexSlot.values()) {
            Assertions.assertEquals((int)slot.ordinal(), (int)((Integer)actual.get(slot)));
        }
    }

    @Test
    void shouldThrowOnNonInstantiatedForAll() {
        InstanceSelector<String> selector = InstanceSelectorTest.selector(IndexSlot.LUCENE, "0");
        Assertions.assertThrows(IllegalStateException.class, () -> selector.forAll(Integer::parseInt));
    }

    @Test
    void shouldForAll() {
        InstanceSelector<String> selector = InstanceSelectorTest.selectorFilledWithOrdinal();
        MutableInt count = new MutableInt();
        selector.forAll(s -> count.increment());
        Assertions.assertEquals((int)IndexSlot.values().length, (int)count.intValue());
    }

    @Test
    void shouldNotThrowOnNonInstantiatedClose() {
        InstanceSelector<String> selector = InstanceSelectorTest.selector(IndexSlot.LUCENE, "0");
        selector.close(Integer::parseInt);
    }

    @Test
    void shouldCloseAll() {
        InstanceSelector<String> selector = InstanceSelectorTest.selectorFilledWithOrdinal();
        MutableInt count = new MutableInt();
        selector.close(s -> count.increment());
        Assertions.assertEquals((int)IndexSlot.values().length, (int)count.intValue());
    }

    private static InstanceSelector<String> selector(Object ... mapping) {
        EnumMap<IndexSlot, String> map = new EnumMap<IndexSlot, String>(IndexSlot.class);
        int i = 0;
        while (i < mapping.length) {
            map.put((IndexSlot)mapping[i++], (String)mapping[i++]);
        }
        return new InstanceSelector(map);
    }

    private static InstanceSelector<String> selectorFilledWithOrdinal() {
        EnumMap<IndexSlot, String> map = new EnumMap<IndexSlot, String>(IndexSlot.class);
        for (IndexSlot slot : IndexSlot.values()) {
            map.put(slot, Integer.toString(slot.ordinal()));
        }
        return new InstanceSelector(map);
    }
}

