/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.locking.LockCompatibilityTestSupport;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

abstract class ActiveLocksListingCompatibility
extends LockCompatibilityTestSupport {
    ActiveLocksListingCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    void activeLockShouldContainUserTransactionFromClient() {
        this.clientA.initialize(LeaseService.NO_LEASES.newClient(), 15L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        Assertions.assertEquals((long)1L, (long)this.clientA.activeLockCount());
        ActiveLock lock = (ActiveLock)this.clientA.activeLocks().findFirst().get();
        Assertions.assertEquals((long)15L, (long)lock.transactionId());
    }

    @Test
    void visitedExclusiveLockPreserveOwningTransaction() {
        int userTransactionId = 15;
        this.clientA.initialize(LeaseService.NO_LEASES.newClient(), (long)userTransactionId, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        MutableInt observedLocks = new MutableInt();
        this.locks.accept((lockType, resourceType, transactionId, resourceId, description, estimatedWaitTime, lockIdentityHashCode) -> {
            Assertions.assertEquals((long)userTransactionId, (long)transactionId);
            Assertions.assertSame((Object)ResourceTypes.NODE, (Object)resourceType);
            observedLocks.increment();
        });
        Assertions.assertEquals((int)1, (int)observedLocks.intValue());
    }

    @Test
    void visitedSharedLockPreserveOwningTransaction() {
        int userTransactionId = 15;
        this.clientA.initialize(LeaseService.NO_LEASES.newClient(), (long)userTransactionId, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        MutableInt observedLocks = new MutableInt();
        this.locks.accept((lockType, resourceType, transactionId, resourceId, description, estimatedWaitTime, lockIdentityHashCode) -> {
            Assertions.assertEquals((long)userTransactionId, (long)transactionId);
            Assertions.assertSame((Object)ResourceTypes.NODE, (Object)resourceType);
            observedLocks.increment();
        });
        Assertions.assertEquals((int)1, (int)observedLocks.intValue());
    }

    @Test
    void visitedSharedLockLockOwningByMultipleClients() {
        int userTransactionIdA = 15;
        int userTransactionIdB = 16;
        this.clientA.initialize(LeaseService.NO_LEASES.newClient(), (long)userTransactionIdA, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientB.initialize(LeaseService.NO_LEASES.newClient(), (long)userTransactionIdB, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
        this.clientB.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        MutableInt observedLocks = new MutableInt();
        MutableLongSet observedTransactions = LongSets.mutable.empty();
        this.locks.accept((lockType, resourceType, transactionId, resourceId, description, estimatedWaitTime, lockIdentityHashCode) -> {
            observedTransactions.add(transactionId);
            Assertions.assertSame((Object)ResourceTypes.NODE, (Object)resourceType);
            observedLocks.increment();
        });
        Assertions.assertEquals((int)2, (int)observedLocks.intValue());
        Assertions.assertTrue((boolean)observedTransactions.containsAll(new long[]{userTransactionIdA, userTransactionIdB}), (String)("Observer set: " + observedTransactions));
    }

    @Test
    void shouldListLocksHeldByTheCurrentClient() {
        this.clientA.initialize(LeaseService.NO_LEASES.newClient(), 1L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
        this.clientA.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L, 2L, 3L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L, 4L, 5L});
        Stream locks = this.clientA.activeLocks();
        Assertions.assertEquals(new HashSet<ActiveLock>(Arrays.asList(new ActiveLock((ResourceType)ResourceTypes.NODE, LockType.EXCLUSIVE, 1L, 1L), new ActiveLock((ResourceType)ResourceTypes.NODE, LockType.EXCLUSIVE, 1L, 2L), new ActiveLock((ResourceType)ResourceTypes.NODE, LockType.EXCLUSIVE, 1L, 3L), new ActiveLock((ResourceType)ResourceTypes.NODE, LockType.SHARED, 1L, 4L), new ActiveLock((ResourceType)ResourceTypes.NODE, LockType.SHARED, 1L, 5L))), locks.collect(Collectors.toSet()));
    }

    @Test
    void shouldCountNumberOfActiveLocks() {
        this.clientA.initialize(LeaseService.NO_LEASES.newClient(), 1L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{0L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{17L});
        this.clientA.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{12L});
        long count = this.clientA.activeLockCount();
        Assertions.assertEquals((long)3L, (long)count);
    }
}

