/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.helpers.StubPropertyCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdaterTestBase;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class RelationshipIndexTxStateUpdaterTest
extends IndexTxStateUpdaterTestBase {
    private static final int REL_ID = 1234;
    private static final int TYPE_ID = 10;
    private static final int UN_INDEXED_TYPE_ID = 11;
    private final IndexDescriptor indexOn_1 = TestIndexDescriptorFactory.forRelType((int)10, (int[])new int[]{20});
    private final IndexDescriptor indexOn_new = TestIndexDescriptorFactory.forRelType((int)10, (int[])new int[]{23});
    private final IndexDescriptor indexOn_2 = TestIndexDescriptorFactory.forRelType((int)10, (int[])new int[]{21});
    private final IndexDescriptor indexOn_1_new = TestIndexDescriptorFactory.forRelType((int)10, (int[])new int[]{20, 23});
    private final IndexDescriptor indexOn_2_3 = TestIndexDescriptorFactory.forRelType((int)10, (int[])new int[]{21, 22});
    private final List<IndexDescriptor> indexes = Arrays.asList(this.indexOn_1, this.indexOn_new, this.indexOn_2, this.indexOn_1_new, this.indexOn_2_3);
    private final RelationshipScanCursor relationship = (RelationshipScanCursor)Mockito.mock(RelationshipScanCursor.class);

    @BeforeEach
    void setup() throws IndexNotFoundKernelException {
        this.setUp(this.indexes);
        HashMap<Integer, Value> map = new HashMap<Integer, Value>();
        map.put(20, Values.of((Object)"hi1"));
        map.put(21, Values.of((Object)"hi2"));
        map.put(22, Values.of((Object)"hi3"));
        Mockito.when((Object)this.relationship.reference()).thenReturn((Object)1234L);
        ((RelationshipScanCursor)Mockito.doAnswer(invocationOnMock -> {
            ((StubPropertyCursor)invocationOnMock.getArgument(0, StubPropertyCursor.class)).init(map, (PropertySelection)invocationOnMock.getArgument(1, PropertySelection.class));
            return null;
        }).when((Object)this.relationship)).properties((PropertyCursor)ArgumentMatchers.any(), (PropertySelection)ArgumentMatchers.any());
        this.relationship.next();
    }

    @Test
    void shouldNotUpdateIndexesOnChangedIrrelevantProperty() {
        this.indexTxUpdater.onPropertyAdd(this.relationship, (PropertyCursor)this.propertyCursor, 10, 24, PROPS, Values.of((Object)"whAt"));
        this.indexTxUpdater.onPropertyRemove(this.relationship, (PropertyCursor)this.propertyCursor, 10, 24, PROPS, Values.of((Object)"whAt"));
        this.indexTxUpdater.onPropertyChange(this.relationship, (PropertyCursor)this.propertyCursor, 10, 24, PROPS, Values.of((Object)"whAt"), Values.of((Object)"whAt2"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.never())).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), (long)ArgumentMatchers.anyInt(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.any());
    }

    @Test
    void shouldNotUpdateIndexesOnChangedChangedPropertyOnIrrelevantType() {
        this.indexTxUpdater.onPropertyAdd(this.relationship, (PropertyCursor)this.propertyCursor, 11, 20, PROPS, Values.of((Object)"whAt"));
        this.indexTxUpdater.onPropertyRemove(this.relationship, (PropertyCursor)this.propertyCursor, 11, 20, PROPS, Values.of((Object)"whAt"));
        this.indexTxUpdater.onPropertyChange(this.relationship, (PropertyCursor)this.propertyCursor, 11, 20, PROPS, Values.of((Object)"whAt"), Values.of((Object)"whAt2"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.never())).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), (long)ArgumentMatchers.anyInt(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.any());
    }

    @Test
    void shouldUpdateIndexesOnAddedProperty() {
        this.indexTxUpdater.onPropertyAdd(this.relationship, (PropertyCursor)this.propertyCursor, 10, 23, PROPS, Values.of((Object)"newHi"));
        this.verifyIndexUpdate(this.indexOn_new.schema(), 1234L, null, RelationshipIndexTxStateUpdaterTest.values("newHi"));
        this.verifyIndexUpdate(this.indexOn_1_new.schema(), 1234L, null, RelationshipIndexTxStateUpdaterTest.values("hi1", "newHi"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.isNull(), (ValueTuple)ArgumentMatchers.any());
    }

    @Test
    void shouldUpdateIndexesOnRemovedProperty() {
        this.indexTxUpdater.onPropertyRemove(this.relationship, (PropertyCursor)this.propertyCursor, 10, 21, PROPS, Values.of((Object)"hi2"));
        this.verifyIndexUpdate(this.indexOn_2.schema(), 1234L, RelationshipIndexTxStateUpdaterTest.values("hi2"), null);
        this.verifyIndexUpdate(this.indexOn_2_3.schema(), 1234L, RelationshipIndexTxStateUpdaterTest.values("hi2", "hi3"), null);
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.isNull());
    }

    @Test
    void shouldUpdateIndexesOnChangedProperty() {
        this.indexTxUpdater.onPropertyChange(this.relationship, (PropertyCursor)this.propertyCursor, 10, 21, PROPS, Values.of((Object)"hi2"), Values.of((Object)"new2"));
        this.verifyIndexUpdate(this.indexOn_2.schema(), 1234L, RelationshipIndexTxStateUpdaterTest.values("hi2"), RelationshipIndexTxStateUpdaterTest.values("new2"));
        this.verifyIndexUpdate(this.indexOn_2_3.schema(), 1234L, RelationshipIndexTxStateUpdaterTest.values("hi2", "hi3"), RelationshipIndexTxStateUpdaterTest.values("new2", "hi3"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.any());
    }
}

