/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.values.AnyValue;

public class RecordingQuerySubscriber
implements QuerySubscriber {
    private List<AnyValue[]> all = new ArrayList<AnyValue[]>();
    private AnyValue[] current;
    private Throwable throwable;
    private QueryStatistics statistics = QueryStatistics.EMPTY;

    public void onResult(int numberOfFields) {
        this.current = new AnyValue[numberOfFields];
    }

    public void onRecord() {
    }

    public void onField(int offset, AnyValue value) {
        this.current[offset] = value;
    }

    public void onRecordCompleted() {
        this.all.add(Arrays.copyOf(this.current, this.current.length));
    }

    public void onError(Throwable throwable) {
        if (this.throwable == null) {
            this.throwable = throwable;
        }
    }

    public void onResultCompleted(QueryStatistics statistics) {
        this.statistics = statistics;
    }

    public List<AnyValue[]> getOrThrow() throws Throwable {
        this.assertNoErrors();
        return this.all;
    }

    public void assertNoErrors() throws Throwable {
        if (this.throwable != null) {
            throw this.throwable;
        }
    }

    public QueryStatistics queryStatistics() {
        return this.statistics;
    }
}

