/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.concurrent.ExecutionException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.scheduler.FailedJobRunsStore;
import org.neo4j.kernel.impl.scheduler.ThreadPool;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.time.Clocks;

class ThreadPoolTest {
    private ThreadPool threadPool;

    ThreadPoolTest() {
    }

    @BeforeEach
    void setup() {
        this.threadPool = new ThreadPool(Group.TESTING, new ThreadGroup("TestPool"), new ThreadPool.ThreadPoolParameters(), Clocks.nanoClock(), new FailedJobRunsStore(10), () -> 9999L);
    }

    @AfterEach
    public void teardown() {
        if (this.threadPool != null) {
            this.threadPool.shutDown();
        }
    }

    @Test
    void poolDoesNotLeakFastJobs() throws ExecutionException, InterruptedException {
        JobHandle fastJob = this.threadPool.submit(new JobMonitoringParams(null, null, null), () -> {});
        fastJob.waitTermination();
        Assertions.assertEquals((int)0, (int)this.threadPool.activeJobCount(), (String)"Active job count should be 0 when job is terminated");
    }
}

