/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.kernel.impl.security.URLAccessRules;

class FileURLAccessRuleTest {
    FileURLAccessRuleTest() {
    }

    @Test
    void shouldThrowWhenFileAccessIsDisabled() throws Exception {
        URL url = new URL("file:///dir/file.csv");
        Config config = Config.defaults((Setting)GraphDatabaseSettings.allow_file_urls, (Object)false);
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.fileAccess().validate((Configuration)config, url));
        Assertions.assertThat((String)error.getMessage()).isEqualTo("configuration property 'dbms.security.allow_csv_import_from_file_urls' is false");
    }

    @ParameterizedTest
    @MethodSource(value={"queryStringIsNotAllowed", "fragmentIsNotAllowed", "authorityIsNotAllowed", "pathsThatResembleAuthorities", "pathsWhichAreEmpty", "pathsWithLeadingSlashes", "pathsWithTrailingSlashes", "pathsWithTraversal", "charactersReservedFromUriProtocol", "charactersReservedFromApplicationForms", "charactersEscapedLowerCase", "charactersEscapedUpperCase"})
    void testWithAndWithoutTrailingSlash(ValidationStatus status, String location, String expected) throws Exception {
        this.testValidation(status, "/import/", location, expected);
        this.testValidation(status, "/import", location, expected);
    }

    private static Stream<Arguments> queryStringIsNotAllowed() {
        return FileURLAccessRuleTest.buildTestCases(new NonPercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.ERR_QUERY, "file:/file?csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_QUERY, "file:/?csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_QUERY, "file:///?csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:/?", null)), new SinglePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%3Fcsv", "file:/import/file%3Fcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%3Fcsv", "file:/import/%3Fcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%3F", "file:/import/%3F"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%3F", "file:/import/%3F")), new DoublePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%253Fcsv", "file:/import/file%253Fcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%253Fcsv", "file:/import/%253Fcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%253F", "file:/import/%253F"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%253F", "file:/import/%253F")), new TripleOrMorePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25253Fcsv", "file:/import/file%25253Fcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2525253Fcsv", "file:/import/file%2525253Fcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252525253Fcsv", "file:/import/file%252525253Fcsv")));
    }

    private static Stream<Arguments> fragmentIsNotAllowed() {
        return FileURLAccessRuleTest.buildTestCases(new NonPercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.ERR_FRAGMENT, "file:/file#csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_FRAGMENT, "file:/#csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_FRAGMENT, "file:///#csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:/#", null)), new SinglePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%23csv", "file:/import/file%23csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%23csv", "file:/import/%23csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%23csv", "file:/import/%23csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%23", "file:/import/%23")), new DoublePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2523csv", "file:/import/file%2523csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2523csv", "file:/import/%2523csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%2523csv", "file:/import/%2523csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2523", "file:/import/%2523")), new TripleOrMorePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252523csv", "file:/import/file%252523csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25252523csv", "file:/import/file%25252523csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2525252523csv", "file:/import/file%2525252523csv")));
    }

    private static Stream<Arguments> authorityIsNotAllowed() {
        return FileURLAccessRuleTest.buildTestCases(new NonPercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://dir1/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://:/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://./file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://../file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://.file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://..file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://...file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://localhost/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://localhost:80/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://me.com/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://w.me.com:80/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://256.1.1.25/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://256.1.1.25:80/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://[::]/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://[::]:80/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://[1:1:1:1:1:1:1:1]/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://[1:1:1:1:1:1:1:1]:80/file.csv", null)), new SinglePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%2F/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%2F%2Ffile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%2F%2F//file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%2Ffile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%2F///////file.csv", null)), new DoublePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%252F%252Ffile.csv", "file:/import/%252F%252Ffile.csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%252F%252F%252Ffile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%252Ffile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%252F//%2EF////file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%252Efile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%252E%252Efile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%253A/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://me.com/file%252Ecsv", null)), new TripleOrMorePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%25252F%252Ffile.csv", "file:/import/%25252F%252Ffile.csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%25252F%252F%252Ffile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%25252Ffile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%2525252Efile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%2525252E%25252Efile.csv", null)));
    }

    private static Stream<Arguments> pathsThatResembleAuthorities() {
        return FileURLAccessRuleTest.buildTestCases(new NonPercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/:file.csv", "file:/import/:file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/:80/file.csv", "file:/import/:80/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/..:/file.csv", "file:/import/..:/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/localhost/file.csv", "file:/import/localhost/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/localhost:80/file.csv", "file:/import/localhost:80/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/me.com/file.csv", "file:/import/me.com/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/256.1.1.25/file.csv", "file:/import/256.1.1.25/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/256.1.1.25:80/file.csv", "file:/import/256.1.1.25:80/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/w.me.com:80/file.csv", "file:/import/w.me.com:80/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///w.me.com:80/file.csv", "file:/import/w.me.com:80/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///:file.csv", "file:/import/:file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/:/file.csv", "file:/import/:/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/:/:file.csv", "file:/import/:/:file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///:/file.csv", "file:/import/:/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/::file.csv", "file:/import/::file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///:::file.csv", "file:/import/:::file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file::/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URL, "file://:file.csv", "file://:file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URL, "file://::file.csv", null)), new SinglePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2Efile.csv", "file:/import/.file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2E%2Efile.csv", "file:/import/..file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%3Afile.csv", "file:/import/:file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%3A/file.csv", "file:/import/:/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%3Afile.csv", "file:/import/:file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/:%3A:file.csv", "file:/import/:::file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%3A:file.csv", "file:/import/::file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%3A80%2Ffile.csv", "file:/import/:80/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/localhost%3A80/file.csv", "file:/import/localhost:80/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/me%2Ecom%3A80/file.csv", "file:/import/me.com:80/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%5B1%3A1:1:1:1:1%3A1:1%5D/csv", "file:/import/%5B1:1:1:1:1:1:1:1%5D/csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%5B1:1:1:1:1:1:1:1%5D%3A80/c", "file:/import/%5B1:1:1:1:1:1:1:1%5D:80/c"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%3Afile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%3A%3Afile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URL, "file%3A%3A/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URL, "file%3A/file.csv", null)), new DoublePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/w%252Eme.com%253A80/csv", "file:/import/w%252Eme.com%253A80/csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///w.me%252Ecom:%252Fcsv", "file:/import/w.me%252Ecom:%252Fcsv")), new TripleOrMorePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/w%25252Eme.com%25253A80/csv", "file:/import/w%25252Eme.com%25253A80/csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///w.me.com%2525253A80/csv", "file:/import/w.me.com%2525253A80/csv")));
    }

    private static Stream<Arguments> pathsWhichAreEmpty() {
        return FileURLAccessRuleTest.buildTestCases(new NonPercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/", "file:/import"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///", "file:/import"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URL, "file", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URI, "file:", null)), new SinglePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F%2F", "file:/import"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%2F", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URL, "file%3A", null)), new DoublePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%252F%252F", "file:/import/%252F%252F"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%252F", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URL, "file%253A", null)), new TripleOrMorePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2525252F%252F", "file:/import/%2525252F%252F"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%25252F", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URL, "file%25253A", null)));
    }

    private static Stream<Arguments> pathsWithLeadingSlashes() {
        return FileURLAccessRuleTest.buildTestCases(new NonPercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///////file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/dir1/file.csv", "file:/import/dir1/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///dir1/file.csv", "file:/import/dir1/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////dir1/file.csv", "file:/import/dir1/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///////dir1/file.csv", "file:/import/dir1/file.csv")), new SinglePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%2F//%2F///file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F////%2F/////file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F%2F%2F%2F%2F%2F%2F%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%2F%2F%2F%2F%2F%2F%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%2Ffile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%2F//file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%2F/%2Ffile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%2F%2F/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%2F%2F%2Ffile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%2Fdir1/file.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%2Ffile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%2F///////file.csv", null)), new DoublePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%252Ffile%252Ecsv", "file:/import/%252Ffile%252Ecsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%252Ffile%2520csv", "file:/import/%252Ffile%2520csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%252Ffile.csv", "file:/import/%252Ffile.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%252Ffile.csv", "file:/import/%252Ffile.csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%252F//file.csv", null)), new TripleOrMorePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%25252Ffile%2520csv", "file:/import/%25252Ffile%2520csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%25252Ffile%25252520csv", "file:/import/%25252Ffile%25252520csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%25252Ffile%20csv", "file:/import/%25252Ffile%20csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_ARG, "file:%25252F//file.csv", null)));
    }

    private static Stream<Arguments> pathsWithTrailingSlashes() {
        return FileURLAccessRuleTest.buildTestCases(new NonPercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv/", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv//", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv///", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv////", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///file.csv/", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///file.csv//", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///file.csv///", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///file.csv////", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////file.csv/", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////file.csv//", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////file.csv///", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////file.csv////", "file:/import/file.csv")), new SinglePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv%2F", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv%2F%2F%2F%2F", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///file.csv%2F", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///file.csv%2F%2F%2F%2F%2F", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F%2Ffile.csv%2F", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F%2Ffile.csv%2F%2F%2F%2F%2F", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////file.csv%2F%2F", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////file.csv%2F%2F%2F%2F", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F%2F%2Ffile.csv//", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2F%2F%2Ffile.csv%2F%2F%2F%2F", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///%2F%2F%2Ffile.csv//", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///%2F%2F%2Ffile.csv%2F%2F%2F%2F", "file:/import/file.csv")), new DoublePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv%252F", "file:/import/file.csv%252F"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv%252F%2F%2F%2F", "file:/import/file.csv%252F"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///file.csv%252F", "file:/import/file.csv%252F"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%252F%252Ffile.csv%252F", "file:/import/%252F%252Ffile.csv%252F"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////file.csv%252F%252F", "file:/import/file.csv%252F%252F"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%252F%252F%252Ffile.csv//", "file:/import/%252F%252F%252Ffile.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///%252F%252F%252Ffile.csv//", "file:/import/%252F%252F%252Ffile.csv")), new TripleOrMorePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv%25252F", "file:/import/file.csv%25252F"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file.csv%2525252F%252F", "file:/import/file.csv%2525252F%252F"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%25252F%25252Ffile.csv", "file:/import/%25252F%25252Ffile.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////file.csv%25252F%25252F", "file:/import/file.csv%25252F%25252F"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%25252Ffile.csv%25252F", "file:/import/%25252Ffile.csv%25252F"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///%25252F%25252Ffile.csv//", "file:/import/%25252F%25252Ffile.csv")));
    }

    private static Stream<Arguments> pathsWithTraversal() {
        return FileURLAccessRuleTest.buildTestCases(new NonPercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/.file.csv", "file:/import/.file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/..file.csv", "file:/import/..file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/...file.csv", "file:/import/...file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///.file.csv", "file:/import/.file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///..file.csv", "file:/import/..file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///...file.csv", "file:/import/...file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/./file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/~file.csv", "file:/import/~file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/~/file.csv", "file:/import/~/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/../../~file.csv", "file:/import/~file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/../~/../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///./file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/../../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///../../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/dir1/../../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///dir1/../../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/..//dir1/../../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/../../dir1/../../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///import/../../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/../import/file.csv", "file:/import/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///../import/file.csv", "file:/import/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///////../import/file.csv", "file:/import/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/..//..//..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/..//..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/..//..//..//..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///..//..//..//..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////..//..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////..//..//..//..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////..//..//..//../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////..//..//../..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////../..//../..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////../../../..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////../../../../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////..//../..//../../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///..//..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///..//..//..//..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://////..//..//..//..//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/..///..///..///file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///..///file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///..///..///file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file://///..///..///..///file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////.//.//file.csv", "file:/import/file.csv")), new SinglePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2E%2E/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%2E%2E%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2E%2E/%2E%2E/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2E%2E/%2E%2E/%2E%2E/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2E%2E%2F%2E%2E%2F%2E%2E%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2E%2E%2Fimport/file.csv", "file:/import/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2efile.csv", "file:/import/.file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2Efile.csv", "file:/import/.file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2Efile%2Ecsv", "file:/import/.file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%2Efile.csv", "file:/import/.file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%7Efile.csv", "file:/import/~file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2E/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%2E/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/../%7E/../file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2E/%2E/%2E/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2E/%2E/%2E/%2Efile.csv", "file:/import/.file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%2Efile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_AUTH, "file://%2E%2Efile.csv", null), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2E%2E%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2E./file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/..%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%2e%2e//%2e%2e//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////..//..%2F%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////../%2F..%2F/file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////%2e%2e//%2e%2e//file.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////..%2F%2F..%2F%2Ffile.csv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////%2E%2E%2F%2F%2E%2E%2F%2Ffile.csv", "file:/import/file.csv")), new DoublePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%252E%252E/file.csv", "file:/import/%252E%252E/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%252E%252E%252Ffile.csv", "file:/import/%252E%252E%252Ffile.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%252E%252E/%252E/file.csv", "file:/import/%252E%252E/%252E/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%252E%252E%252Fimport/csv", "file:/import/%252E%252E%252Fimport/csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////..//..%252F%2Ffile.csv", "file:/import/..%252F/file.csv")), new TripleOrMorePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/%25252E%25252E/file.csv", "file:/import/%25252E%25252E/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:///%2525252E%25252Ffile.csv", "file:/import/%2525252E%25252Ffile.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:////..//..%25252F%2Ffile.csv", "file:/import/..%25252F/file.csv")));
    }

    private static Stream<Arguments> charactersReservedFromUriProtocol() {
        return FileURLAccessRuleTest.buildTestCases(new NonPercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.ERR_URI, "file:/file%csv", null), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file:csv", "file:/import/file:csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file/csv", "file:/import/file/csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_QUERY, "file:/file?csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_FRAGMENT, "file:/file#csv", null), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file@csv", "file:/import/file@csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file!csv", "file:/import/file!csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file$csv", "file:/import/file$csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file&csv", "file:/import/file&csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file'csv", "file:/import/file'csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file(csv", "file:/import/file(csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file)csv", "file:/import/file)csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file*csv", "file:/import/file*csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file+csv", "file:/import/file+csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file,csv", "file:/import/file,csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file;csv", "file:/import/file;csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file=csv", "file:/import/file=csv"), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URI, "file:/file[csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URI, "file:/file]csv", null), FileURLAccessRuleTest.arg(ValidationStatus.ERR_URI, "file:/file csv", null)), new SinglePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25csv", "file:/import/file%25csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%3Acsv", "file:/import/file:csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2Fcsv", "file:/import/file/csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%3Fcsv", "file:/import/file%3Fcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%23csv", "file:/import/file%23csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%40csv", "file:/import/file@csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%21csv", "file:/import/file!csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%24csv", "file:/import/file$csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%26csv", "file:/import/file&csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%27csv", "file:/import/file'csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%28csv", "file:/import/file(csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%29csv", "file:/import/file)csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2Acsv", "file:/import/file*csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2Bcsv", "file:/import/file+csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2Ccsv", "file:/import/file,csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%3Bcsv", "file:/import/file;csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%3Dcsv", "file:/import/file=csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%5Bcsv", "file:/import/file%5Bcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%5Dcsv", "file:/import/file%5Dcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%20csv", "file:/import/file%20csv")), new DoublePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2525csv", "file:/import/file%2525csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%253Acsv", "file:/import/file%253Acsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252Fcsv", "file:/import/file%252Fcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%253Fcsv", "file:/import/file%253Fcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2523csv", "file:/import/file%2523csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2540csv", "file:/import/file%2540csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2521csv", "file:/import/file%2521csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2524csv", "file:/import/file%2524csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2526csv", "file:/import/file%2526csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2527csv", "file:/import/file%2527csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2528csv", "file:/import/file%2528csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2529csv", "file:/import/file%2529csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252Acsv", "file:/import/file%252Acsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252Bcsv", "file:/import/file%252Bcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252Ccsv", "file:/import/file%252Ccsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%253Bcsv", "file:/import/file%253Bcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%253Dcsv", "file:/import/file%253Dcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%255Bcsv", "file:/import/file%255Bcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%255Dcsv", "file:/import/file%255Dcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2520csv", "file:/import/file%2520csv")), new TripleOrMorePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252525csv", "file:/import/file%252525csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25253Acsv", "file:/import/file%25253Acsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25252Fcsv", "file:/import/file%25252Fcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25253Fcsv", "file:/import/file%25253Fcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252523csv", "file:/import/file%252523csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252540csv", "file:/import/file%252540csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252521csv", "file:/import/file%252521csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252524csv", "file:/import/file%252524csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252526csv", "file:/import/file%252526csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252527csv", "file:/import/file%252527csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252528csv", "file:/import/file%252528csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252529csv", "file:/import/file%252529csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25252Acsv", "file:/import/file%25252Acsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25252Bcsv", "file:/import/file%25252Bcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25252Ccsv", "file:/import/file%25252Ccsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25253Bcsv", "file:/import/file%25253Bcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25253Dcsv", "file:/import/file%25253Dcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25255Bcsv", "file:/import/file%25255Bcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25255Dcsv", "file:/import/file%25255Dcsv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252520csv", "file:/import/file%252520csv")));
    }

    private static Stream<Arguments> charactersReservedFromApplicationForms() {
        return FileURLAccessRuleTest.buildTestCases(new NonPercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.ERR_URI, "file:/file csv", null), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file+csv", "file:/import/file+csv")), new SinglePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%20csv", "file:/import/file%20csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2Bcsv", "file:/import/file+csv")), new DoublePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2520csv", "file:/import/file%2520csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252Bcsv", "file:/import/file%252Bcsv")), new TripleOrMorePercentEncoded(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%252520csv", "file:/import/file%252520csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%25252Bcsv", "file:/import/file%25252Bcsv")));
    }

    private static Stream<Arguments> charactersEscapedLowerCase() {
        return Stream.of(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2ecsv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2fcsv", "file:/import/file/csv"));
    }

    private static Stream<Arguments> charactersEscapedUpperCase() {
        return Stream.of(FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2Ecsv", "file:/import/file.csv"), FileURLAccessRuleTest.arg(ValidationStatus.OK, "file:/file%2Fcsv", "file:/import/file/csv"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testValidation(ValidationStatus status, String root, String url, String expected) throws Exception {
        if (status.equals((Object)ValidationStatus.OK)) {
            URL accessURL = this.validate(root, url);
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)accessURL.toString());
            return;
        } else if (status.equals((Object)ValidationStatus.ERR_AUTH)) {
            URLAccessValidationError err = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> this.validate(root, url));
            MatcherAssert.assertThat((Object)err.getMessage(), (Matcher)Matchers.containsString((String)"URL may not contain an authority section"));
            return;
        } else if (status.equals((Object)ValidationStatus.ERR_QUERY)) {
            URLAccessValidationError err = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> this.validate(root, url));
            MatcherAssert.assertThat((Object)err.getMessage(), (Matcher)Matchers.containsString((String)"file URL may not contain a query component"));
            return;
        } else if (status.equals((Object)ValidationStatus.ERR_FRAGMENT)) {
            IllegalArgumentException err = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.validate(root, url));
            MatcherAssert.assertThat((Object)err.getMessage(), (Matcher)Matchers.containsString((String)"URI has a fragment component"));
            return;
        } else if (status.equals((Object)ValidationStatus.ERR_ARG)) {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.validate(root, url));
            return;
        } else if (status.equals((Object)ValidationStatus.ERR_PATH)) {
            org.junit.jupiter.api.Assertions.assertThrows(InvalidPathException.class, () -> this.validate(root, url));
            return;
        } else if (status.equals((Object)ValidationStatus.ERR_URL)) {
            org.junit.jupiter.api.Assertions.assertThrows(MalformedURLException.class, () -> this.validate(root, url));
            return;
        } else {
            if (!status.equals((Object)ValidationStatus.ERR_URI)) throw new Exception("Unexpected test result");
            Exception err = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> this.validate(root, url));
            if (err instanceof RuntimeException) {
                org.junit.jupiter.api.Assertions.assertEquals(err.getCause().getClass(), URISyntaxException.class);
                return;
            } else {
                if (!(err instanceof URISyntaxException)) throw new Exception("Unpexcted test result");
                org.junit.jupiter.api.Assertions.assertThrows(URISyntaxException.class, () -> this.validate(root, url));
            }
        }
    }

    private URL validate(String root, String url) throws MalformedURLException, URLAccessValidationError {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.load_csv_file_url_root, (Object)Path.of(root, new String[0]));
        return URLAccessRules.fileAccess().validate((Configuration)config, new URL(url));
    }

    private static Stream<Arguments> buildTestCases(NonPercentEncoded nonEncoded, SinglePercentEncoded singleEncoded, DoublePercentEncoded doubleEncoded, TripleOrMorePercentEncoded tripleOrMoreEncoded) {
        return Stream.concat(Stream.of(nonEncoded.entries), Stream.concat(Stream.of(singleEncoded.entries), Stream.concat(Stream.of(doubleEncoded.entries), Stream.of(tripleOrMoreEncoded.entries))));
    }

    private static Arguments arg(ValidationStatus status, String location, String result) {
        return FileURLAccessRuleTest.isWindows() ? ArgTransformerWindows.transform(status, location, result) : ArgTransformerIdentity.transform(status, location, result);
    }

    private static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    private static class ArgTransformerIdentity {
        private ArgTransformerIdentity() {
        }

        public static Arguments transform(ValidationStatus status, String location, String result) {
            return Arguments.of((Object[])new Object[]{status, location, result});
        }
    }

    private static class ArgTransformerWindows {
        private ArgTransformerWindows() {
        }

        public static Arguments transform(ValidationStatus status, String location, String result) {
            if (status != ValidationStatus.OK) {
                return Arguments.of((Object[])new Object[]{status, location, null});
            }
            if (ArgTransformerWindows.urlContainsEncodedLeadingSlashes(location)) {
                return Arguments.of((Object[])new Object[]{ValidationStatus.ERR_PATH, location, null});
            }
            if (ArgTransformerWindows.urlContainsWindowsReservedCharactersInPath(location)) {
                return Arguments.of((Object[])new Object[]{ValidationStatus.ERR_PATH, location, null});
            }
            if (ArgTransformerWindows.urlContainsEncodedUnicodeC0RangeCharacters(location)) {
                return Arguments.of((Object[])new Object[]{ValidationStatus.ERR_PATH, location, null});
            }
            String resultWithDrive = ArgTransformerWindows.urlWithDefaultDrive(result);
            return Arguments.of((Object[])new Object[]{status, location, resultWithDrive});
        }

        private static boolean urlContainsEncodedLeadingSlashes(String url) {
            Pattern pattern = Pattern.compile("file:/+%2F.*");
            java.util.regex.Matcher matcher = pattern.matcher(url);
            return matcher.matches();
        }

        private static boolean urlContainsWindowsReservedCharactersInPath(String url) {
            try {
                Pattern pattern = Pattern.compile(".*(<|>|:|\"|\\|\\?|\\*|%3C|%3E|%3A|%22|%5C|%3F|%2A).*");
                java.util.regex.Matcher matcher = pattern.matcher(new URL(url).getPath());
                return matcher.matches();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        private static boolean urlContainsEncodedUnicodeC0RangeCharacters(String url) {
            Pattern pattern = Pattern.compile(".*%[01][0-9A-F].*");
            java.util.regex.Matcher matcher = pattern.matcher(url);
            return matcher.matches();
        }

        private static String urlWithDefaultDrive(String url) {
            String root = ((Path)GraphDatabaseSettings.neo4j_home.defaultValue()).toString().substring(0, 2);
            return "file:/" + root + "/" + url.substring("file:/".length());
        }
    }

    private static class TripleOrMorePercentEncoded {
        public Arguments[] entries;

        TripleOrMorePercentEncoded(Arguments ... entries) {
            this.entries = entries;
        }
    }

    private static class DoublePercentEncoded {
        public Arguments[] entries;

        DoublePercentEncoded(Arguments ... entries) {
            this.entries = entries;
        }
    }

    private static class SinglePercentEncoded {
        public Arguments[] entries;

        SinglePercentEncoded(Arguments ... entries) {
            this.entries = entries;
        }
    }

    private static class NonPercentEncoded {
        public Arguments[] entries;

        NonPercentEncoded(Arguments ... entries) {
            this.entries = entries;
        }
    }

    protected static enum ValidationStatus {
        OK,
        ERR_AUTH,
        ERR_QUERY,
        ERR_FRAGMENT,
        ERR_URL,
        ERR_URI,
        ERR_PATH,
        ERR_ARG;

    }
}

