/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.Dependencies;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.store.DefaultStoreSnapshotFactory;
import org.neo4j.kernel.impl.store.StoreFileListing;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.logging.internal.DatabaseLogProvider;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreResource;
import org.neo4j.storageengine.api.StoreSnapshot;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class DefaultStoreSnapshotFactoryTest {
    @Inject
    public TestDirectory testDirectory;
    private DefaultStoreSnapshotFactory defaultStoreSnapshotFactory;
    private DatabaseLayout databaseLayout;
    private StoreFileListing.Builder fileListingBuilder;

    DefaultStoreSnapshotFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        Database database = (Database)Mockito.mock(Database.class);
        this.fileListingBuilder = (StoreFileListing.Builder)Mockito.mock(StoreFileListing.Builder.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.databaseLayout = DatabaseLayout.ofFlat((Path)this.testDirectory.directory("neo4j", new String[]{"data", "databases"}));
        Mockito.when((Object)database.getDatabaseLayout()).thenReturn((Object)this.databaseLayout);
        DatabaseAvailabilityGuard availabilityGuard = (DatabaseAvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
        Mockito.when((Object)availabilityGuard.isAvailable()).thenReturn((Object)true);
        StoreFileListing storeFileListing = (StoreFileListing)Mockito.mock(StoreFileListing.class);
        Mockito.when((Object)storeFileListing.builder()).thenReturn((Object)this.fileListingBuilder);
        Mockito.when((Object)database.getStoreFileListing()).thenReturn((Object)storeFileListing);
        Mockito.when((Object)database.getInternalLogProvider()).thenReturn((Object)DatabaseLogProvider.nullDatabaseLogProvider());
        CheckPointer checkPointer = (CheckPointer)Mockito.mock(CheckPointer.class);
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)checkPointer);
        Mockito.when((Object)database.getDependencyResolver()).thenReturn((Object)dependencies);
        Mockito.when((Object)database.getDatabaseAvailabilityGuard()).thenReturn((Object)availabilityGuard);
        StoreCopyCheckPointMutex storeCopyCheckPointMutex = new StoreCopyCheckPointMutex();
        Mockito.when((Object)database.getStoreCopyCheckPointMutex()).thenReturn((Object)storeCopyCheckPointMutex);
        this.defaultStoreSnapshotFactory = new DefaultStoreSnapshotFactory(database, this.testDirectory.getFileSystem());
    }

    @Test
    void shouldHanldeEmptyListOfFilesForeEachType() throws Exception {
        this.setExpectedFiles(new StoreFileMetadata[0]);
        StoreSnapshot prepareStoreCopyFiles = (StoreSnapshot)this.defaultStoreSnapshotFactory.createStoreSnapshot().get();
        Path[] files = prepareStoreCopyFiles.recoverableFiles();
        long atomicFilesSnapshotLength = prepareStoreCopyFiles.unrecoverableFiles().count();
        Assertions.assertEquals((int)0, (int)files.length);
        Assertions.assertEquals((long)0L, (long)atomicFilesSnapshotLength);
    }

    private void setExpectedFiles(StoreFileMetadata[] expectedFiles) throws IOException {
        ((StoreFileListing.Builder)Mockito.doAnswer(invocation -> Iterators.asResourceIterator((Iterator)Iterators.iterator((Object[])expectedFiles))).when((Object)this.fileListingBuilder)).build();
    }

    @Test
    void shouldReturnExpectedListOfFileNamesForEachType() throws Exception {
        StoreFileMetadata[] expectedFiles = new StoreFileMetadata[]{new StoreFileMetadata(this.databaseLayout.file("a"), 1), new StoreFileMetadata(this.databaseLayout.file("b"), 2)};
        this.setExpectedFiles(expectedFiles);
        StoreSnapshot prepareStoreCopyFiles = (StoreSnapshot)this.defaultStoreSnapshotFactory.createStoreSnapshot().get();
        Object[] files = prepareStoreCopyFiles.recoverableFiles();
        StoreResource[] atomicFilesSnapshot = (StoreResource[])prepareStoreCopyFiles.unrecoverableFiles().toArray(StoreResource[]::new);
        Object[] expectedFilesConverted = (Path[])Arrays.stream(expectedFiles).map(StoreFileMetadata::path).toArray(Path[]::new);
        StoreResource[] expectedAtomicFilesConverted = (StoreResource[])Arrays.stream(expectedFiles).map(f -> new StoreResource(f.path(), this.getRelativePath((StoreFileMetadata)f), f.recordSize(), this.testDirectory.getFileSystem())).toArray(StoreResource[]::new);
        Assertions.assertArrayEquals((Object[])expectedFilesConverted, (Object[])files);
        Assertions.assertEquals((int)expectedAtomicFilesConverted.length, (int)atomicFilesSnapshot.length);
        for (int i = 0; i < expectedAtomicFilesConverted.length; ++i) {
            StoreResource expected = expectedAtomicFilesConverted[i];
            StoreResource actual = atomicFilesSnapshot[i];
            Path relativePath = this.databaseLayout.databaseDirectory().relativize(actual.path());
            Assertions.assertEquals((Object)expected.relativePath(), (Object)relativePath.toString());
            Assertions.assertEquals((int)expected.recordSize(), (int)actual.recordSize());
        }
    }

    private String getRelativePath(StoreFileMetadata f) {
        return this.databaseLayout.databaseDirectory().relativize(f.path()).toString();
    }
}

