/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;

@Neo4jLayoutExtension
class LegacyTransactionLogsLocatorTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private Neo4jLayout neo4jLayout;

    LegacyTransactionLogsLocatorTest() {
    }

    @Test
    void transactionLogsDirectoryEqualsToDatabaseDirectoryWithDefaultConfiguration() {
        LegacyTransactionLogsLocator logsLocator = new LegacyTransactionLogsLocator(Config.defaults(), this.databaseLayout);
        Assertions.assertEquals((Object)this.databaseLayout.databaseDirectory(), (Object)logsLocator.getTransactionLogsDirectory());
    }

    @Test
    void transactionLogsDirectoryEqualsToLogicalLogLegacySettingsWhenConfigured() {
        Path customDirectory = this.testDirectory.directory("customDirectory");
        Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.logical_logs_location, (Object)customDirectory.toAbsolutePath());
        LegacyTransactionLogsLocator logsLocator = new LegacyTransactionLogsLocator(config, this.databaseLayout);
        Assertions.assertEquals((Object)customDirectory, (Object)logsLocator.getTransactionLogsDirectory());
    }

    @Test
    void transactionLogsDirectoryEqualsToDatabaseDirectoryForSystemDatabase() {
        Path customDirectory = this.testDirectory.directory("customDirectory");
        Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.logical_logs_location, (Object)customDirectory.toAbsolutePath());
        DatabaseLayout systemDbLayout = this.neo4jLayout.databaseLayout("system");
        LegacyTransactionLogsLocator logsLocator = new LegacyTransactionLogsLocator(config, systemDbLayout);
        Assertions.assertEquals((Object)systemDbLayout.databaseDirectory(), (Object)logsLocator.getTransactionLogsDirectory());
    }
}

