/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.ClassGuardedAdversary;
import org.neo4j.adversaries.CountingAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemLifecycleAdapter;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionAppenderFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.DatabasePanicEventGenerator;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.Race;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@EphemeralNeo4jLayoutExtension
@ExtendWith(value={LifeExtension.class})
public class TransactionAppenderConcurrencyTest {
    private static ExecutorService executor;
    private static ThreadPoolJobScheduler jobScheduler;
    @Inject
    private LifeSupport life;
    @Inject
    private DatabaseLayout databaseLayout;
    private final LogFiles logFiles = (LogFiles)Mockito.mock(TransactionLogFiles.class);
    private final LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
    private final LogRotation logRotation = LogRotation.NO_ROTATION;
    private final TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache();
    private final TransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
    private final SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();

    @BeforeAll
    static void setUpExecutor() {
        jobScheduler = new ThreadPoolJobScheduler();
        executor = Executors.newCachedThreadPool();
    }

    @AfterAll
    static void tearDownExecutor() {
        executor.shutdown();
        executor = null;
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.logFiles.getLogFile()).thenReturn((Object)this.logFile);
        jobScheduler = new ThreadPoolJobScheduler();
    }

    @AfterEach
    void tearDown() {
        this.life.shutdown();
        jobScheduler.close();
    }

    @Test
    void shouldHaveAllConcurrentAppendersSeePanic() throws Throwable {
        ClassGuardedAdversary adversary = new ClassGuardedAdversary((Adversary)new CountingAdversary(1, true), TransactionAppenderConcurrencyTest.failMethod(TransactionLogFile.class, "force"));
        EphemeralFileSystemAbstraction efs = new EphemeralFileSystemAbstraction();
        AdversarialFileSystemAbstraction fs = new AdversarialFileSystemAbstraction((Adversary)adversary, (FileSystemAbstraction)efs);
        this.life.add((Lifecycle)new FileSystemLifecycleAdapter((FileSystemAbstraction)fs));
        DatabaseHealth databaseHealth = new DatabaseHealth((PanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), (Log)NullLog.getInstance());
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fs).withLogVersionRepository((LogVersionRepository)this.logVersionRepository).withTransactionIdStore(this.transactionIdStore).withDatabaseHealth(databaseHealth).withLogEntryReader((LogEntryReader)new VersionAwareLogEntryReader((CommandReaderFactory)new TestCommandReaderFactory())).withStoreId(StoreId.UNKNOWN).build();
        this.life.add((Lifecycle)logFiles);
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)this.createTransactionAppender(databaseHealth, logFiles, (JobScheduler)jobScheduler));
        this.life.start();
        int numberOfAppenders = 10;
        final CountDownLatch trap = new CountDownLatch(numberOfAppenders);
        LogAppendEvent.Empty beforeForceTrappingEvent = new LogAppendEvent.Empty(){

            public LogForceWaitEvent beginLogForceWait() {
                trap.countDown();
                DoubleLatch.awaitLatch((CountDownLatch)trap);
                return super.beginLogForceWait();
            }
        };
        Race race = new Race();
        for (int i = 0; i < numberOfAppenders; ++i) {
            race.addContestant(() -> TransactionAppenderConcurrencyTest.lambda$shouldHaveAllConcurrentAppendersSeePanic$1(appender, (LogAppendEvent)beforeForceTrappingEvent));
        }
        race.go();
    }

    @Test
    void databasePanicShouldHandleOutOfMemoryErrors() throws IOException, InterruptedException, ExecutionException {
        CountDownLatch panicLatch = new CountDownLatch(1);
        final CountDownLatch adversaryLatch = new CountDownLatch(1);
        OutOfMemoryAwareFileSystem fs = new OutOfMemoryAwareFileSystem();
        this.life.add((Lifecycle)new FileSystemLifecycleAdapter((FileSystemAbstraction)fs));
        SlowPanickingDatabaseHealth slowPanicDatabaseHealth = new SlowPanickingDatabaseHealth(panicLatch, adversaryLatch);
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fs).withLogVersionRepository((LogVersionRepository)this.logVersionRepository).withTransactionIdStore(this.transactionIdStore).withDatabaseHealth((DatabaseHealth)slowPanicDatabaseHealth).withLogEntryReader((LogEntryReader)new VersionAwareLogEntryReader((CommandReaderFactory)new TestCommandReaderFactory())).withStoreId(StoreId.UNKNOWN).build();
        this.life.add((Lifecycle)logFiles);
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)this.createTransactionAppender(slowPanicDatabaseHealth, logFiles, (JobScheduler)jobScheduler));
        this.life.start();
        appender.append(TransactionAppenderConcurrencyTest.tx(), LogAppendEvent.NULL);
        fs.shouldOOM = true;
        Future<Long> failingTransaction = executor.submit(() -> appender.append(TransactionAppenderConcurrencyTest.tx(), LogAppendEvent.NULL));
        panicLatch.await();
        fs.shouldOOM = false;
        IOException e = (IOException)org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> appender.append(TransactionAppenderConcurrencyTest.tx(), (LogAppendEvent)new LogAppendEvent.Empty(){

            public LogForceWaitEvent beginLogForceWait() {
                adversaryLatch.countDown();
                return super.beginLogForceWait();
            }
        }));
        Assertions.assertThat((Throwable)e).hasMessageContaining("The database has encountered a critical error");
        ExecutionException executionException = (ExecutionException)org.junit.jupiter.api.Assertions.assertThrows(ExecutionException.class, failingTransaction::get);
        Assertions.assertThat((Throwable)executionException).hasCauseInstanceOf(OutOfMemoryError.class);
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader((CommandReaderFactory)new TestCommandReaderFactory());
        LogFile logFile = logFiles.getLogFile();
        Assertions.assertThat((long)logFile.getLowestLogVersion()).isEqualTo(logFile.getHighestLogVersion());
        long version = logFile.getHighestLogVersion();
        try (PhysicalLogVersionedStoreChannel channel = logFile.openForVersion(version);
             ReadAheadLogChannel readAheadLogChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)channel, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
             LogEntryCursor cursor = new LogEntryCursor((LogEntryReader)logEntryReader, (ReadableClosablePositionAwareChecksumChannel)readAheadLogChannel);){
            long numberOfTransactions = 0L;
            while (cursor.next()) {
                LogEntry entry = cursor.get();
                if (!(entry instanceof LogEntryCommit)) continue;
                ++numberOfTransactions;
            }
            Assertions.assertThat((long)numberOfTransactions).isEqualTo(1L);
        }
    }

    private TransactionAppender createTransactionAppender(DatabaseHealth databaseHealth, LogFiles logFiles, JobScheduler scheduler) {
        return TransactionAppenderFactory.createTransactionAppender((LogFiles)logFiles, (TransactionIdStore)this.transactionIdStore, (TransactionMetadataCache)this.transactionMetadataCache, (Config)Config.defaults((Setting)GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)false), (Health)databaseHealth, (JobScheduler)scheduler, (LogProvider)NullLogProvider.getInstance());
    }

    protected static TransactionToApply tx() {
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(Collections.singletonList(new TestCommand()));
        tx.setHeader(new byte[0], 0L, 0L, 0L, 0, AuthSubject.ANONYMOUS);
        return new TransactionToApply((TransactionRepresentation)tx, CursorContext.NULL, StoreCursors.NULL);
    }

    private static Predicate<StackWalker.StackFrame> failMethod(Class<?> klass, String methodName) {
        return frame -> frame.getClassName().equals(klass.getName()) && frame.getMethodName().equals(methodName);
    }

    private static /* synthetic */ void lambda$shouldHaveAllConcurrentAppendersSeePanic$1(TransactionAppender appender, LogAppendEvent beforeForceTrappingEvent) {
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> appender.append(TransactionAppenderConcurrencyTest.tx(), beforeForceTrappingEvent));
    }

    private static class SlowPanickingDatabaseHealth
    extends DatabaseHealth {
        private final CountDownLatch panicLatch;
        private final CountDownLatch adversaryLatch;

        SlowPanickingDatabaseHealth(CountDownLatch panicLatch, CountDownLatch adversaryLatch) {
            super((PanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), (Log)NullLog.getInstance());
            this.panicLatch = panicLatch;
            this.adversaryLatch = adversaryLatch;
        }

        public void panic(Throwable cause) {
            this.panicLatch.countDown();
            try {
                this.adversaryLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            super.panic(cause);
        }
    }

    private static class OutOfMemoryAwareFileSystem
    extends EphemeralFileSystemAbstraction {
        private volatile boolean shouldOOM;

        private OutOfMemoryAwareFileSystem() {
        }

        public synchronized StoreChannel write(Path fileName) throws IOException {
            return new DelegatingStoreChannel<StoreChannel>(super.write(fileName)){

                public void writeAll(ByteBuffer src) throws IOException {
                    if (shouldOOM) {
                        throw new OutOfMemoryError("Temporary buffer allocation failed");
                    }
                    super.writeAll(src);
                }
            };
        }
    }
}

