/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;

class CheckPointThresholdDescriptionTest {
    CheckPointThresholdDescriptionTest() {
    }

    @Test
    void shouldCallConsumerProvidingTheDescriptionWhenThresholdIsTrue() {
        String description = "description";
        TheAbstractCheckPointThreshold threshold = new TheAbstractCheckPointThreshold(true, description);
        AtomicReference calledWith = new AtomicReference();
        LogPosition logPosition = new LogPosition(99L, 100L);
        threshold.isCheckPointingNeeded(42L, logPosition, calledWith::set);
        Assertions.assertEquals((Object)description, calledWith.get());
    }

    @Test
    void shouldNotCallConsumerProvidingTheDescriptionWhenThresholdIsFalse() {
        TheAbstractCheckPointThreshold threshold = new TheAbstractCheckPointThreshold(false, null);
        LogPosition logPosition = new LogPosition(1L, 100L);
        Assertions.assertDoesNotThrow(() -> threshold.isCheckPointingNeeded(42L, logPosition, s -> {
            throw new IllegalStateException("nooooooooo!");
        }));
    }

    private static class TheAbstractCheckPointThreshold
    extends AbstractCheckPointThreshold {
        private final boolean reached;

        TheAbstractCheckPointThreshold(boolean reached, String description) {
            super(description);
            this.reached = reached;
        }

        public void initialize(long transactionId, LogPosition logPosition) {
        }

        public void checkPointHappened(long transactionId, LogPosition logPosition) {
        }

        public long checkFrequencyMillis() {
            return DEFAULT_CHECKING_FREQUENCY_MILLIS;
        }

        protected boolean thresholdReached(long lastCommittedTransactionId, LogPosition logPosition) {
            return this.reached;
        }
    }
}

