/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThresholdTestSupport;

class CheckPointThresholdTest
extends CheckPointThresholdTestSupport {
    CheckPointThresholdTest() {
    }

    @Test
    void mustCreateThresholdThatTriggersAfterTransactionCount() {
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(1L, LogPosition.UNSPECIFIED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded((long)(this.intervalTx - 1), ARBITRARY_LOG_POSITION, this.notTriggered));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded((long)this.intervalTx.intValue(), ARBITRARY_LOG_POSITION, this.notTriggered));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded((long)(this.intervalTx + 1), ARBITRARY_LOG_POSITION, this.triggered));
        this.verifyTriggered("every 100000 transactions");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustCreateThresholdThatTriggersAfterTime() {
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(1L, LogPosition.UNSPECIFIED);
        this.clock.forward(this.intervalTime.toMillis(), TimeUnit.MILLISECONDS);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(2L, ARBITRARY_LOG_POSITION, this.notTriggered));
        this.clock.forward(this.intervalTime.toMillis(), TimeUnit.MILLISECONDS);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(4L, ARBITRARY_LOG_POSITION, this.triggered));
        this.verifyTriggered("every 15 minutes threshold");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustNotTriggerBeforeTimeWithTooFewCommittedTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L, LogPosition.UNSPECIFIED);
        this.clock.forward(50L, TimeUnit.MILLISECONDS);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(42L, ARBITRARY_LOG_POSITION, this.notTriggered));
    }

    @Test
    void mustTriggerWhenTimeThresholdIsReachedAndThereAreCommittedTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L, LogPosition.UNSPECIFIED);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(42L, ARBITRARY_LOG_POSITION, this.triggered));
        this.verifyTriggered("every 100 milliseconds");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustTriggerWhenWeirdTimeThresholdIsReachedAndThereAreCommittedTransactions() {
        this.withIntervalTime("1100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L, LogPosition.UNSPECIFIED);
        this.clock.forward(2199L, TimeUnit.MILLISECONDS);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(42L, ARBITRARY_LOG_POSITION, this.triggered));
        this.verifyTriggered("every 1 seconds 100 milliseconds");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustNotTriggerWhenTimeThresholdIsReachedAndThereAreNoCommittedTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(42L, LogPosition.UNSPECIFIED);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(42L, ARBITRARY_LOG_POSITION, this.notTriggered));
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustNotTriggerPastTimeThresholdSinceLastCheckpointWithNoNewTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L, LogPosition.UNSPECIFIED);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        threshold.checkPointHappened(42L, LogPosition.UNSPECIFIED);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(42L, ARBITRARY_LOG_POSITION, this.notTriggered));
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustTriggerPastTimeThresholdSinceLastCheckpointWithNewTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L, LogPosition.UNSPECIFIED);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        threshold.checkPointHappened(42L, LogPosition.UNSPECIFIED);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(43L, ARBITRARY_LOG_POSITION, this.triggered));
        this.verifyTriggered("every 100 milliseconds");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustNotTriggerOnTransactionCountWhenThereAreNoNewTransactions() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L, LogPosition.UNSPECIFIED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(2L, ARBITRARY_LOG_POSITION, this.notTriggered));
    }

    @Test
    void mustNotTriggerOnTransactionCountWhenCountIsBellowThreshold() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L, LogPosition.UNSPECIFIED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(3L, ARBITRARY_LOG_POSITION, this.notTriggered));
    }

    @Test
    void mustTriggerOnTransactionCountWhenCountIsAtThreshold() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L, LogPosition.UNSPECIFIED);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(4L, ARBITRARY_LOG_POSITION, this.triggered));
        this.verifyTriggered("every 2 transactions");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustNotTriggerOnTransactionCountAtThresholdIfCheckPointAlreadyHappened() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L, LogPosition.UNSPECIFIED);
        threshold.checkPointHappened(4L, LogPosition.UNSPECIFIED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(4L, ARBITRARY_LOG_POSITION, this.notTriggered));
    }

    @Test
    void mustNotTriggerWhenTransactionCountIsWithinThresholdSinceLastTrigger() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L, LogPosition.UNSPECIFIED);
        threshold.checkPointHappened(4L, LogPosition.UNSPECIFIED);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(5L, ARBITRARY_LOG_POSITION, this.notTriggered));
    }

    @Test
    void mustTriggerOnTransactionCountWhenCountIsAtThresholdSinceLastCheckPoint() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L, LogPosition.UNSPECIFIED);
        threshold.checkPointHappened(4L, LogPosition.UNSPECIFIED);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(6L, ARBITRARY_LOG_POSITION, this.triggered));
        this.verifyTriggered("2 transactions");
        this.verifyNoMoreTriggers();
    }

    @Test
    void timeBasedThresholdMustSuggestSchedulingFrequency() {
        Assertions.assertThat((long)this.createThreshold().checkFrequencyMillis()).isEqualTo(CheckPointThreshold.DEFAULT_CHECKING_FREQUENCY_MILLIS);
        this.withIntervalTime("100ms");
        Assertions.assertThat((long)this.createThreshold().checkFrequencyMillis()).isEqualTo(100L);
    }
}

