/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.AbstractLogTailScannerTest;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StoreId;

class DetachedLogTailScannerTest
extends AbstractLogTailScannerTest {
    DetachedLogTailScannerTest() {
    }

    @Override
    protected LogFiles createLogFiles() throws IOException {
        return LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (PageCache)this.pageCache).withLogVersionRepository(this.logVersionRepository).withTransactionIdStore(this.transactionIdStore).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).withLogProvider((LogProvider)this.logProvider).withConfig(Config.defaults((Setting)GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false)).build();
    }

    @Test
    void includeWrongPositionInException() throws Exception {
        Path[] matchedFiles;
        this.logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (PageCache)this.pageCache).withLogVersionRepository(this.logVersionRepository).withTransactionIdStore(this.transactionIdStore).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).withLogProvider((LogProvider)this.logProvider).withConfig(Config.defaults((Setting)GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)true)).build();
        long txId = 6L;
        AbstractLogTailScannerTest.PositionEntry position = DetachedLogTailScannerTest.position();
        DetachedLogTailScannerTest.setupLogFiles(10L, this.logFile(DetachedLogTailScannerTest.start(), DetachedLogTailScannerTest.commit(txId - 1L), position), this.logFile(DetachedLogTailScannerTest.checkPoint(position)), this.logFile(DetachedLogTailScannerTest.start(), DetachedLogTailScannerTest.commit(txId)));
        for (Path matchedFile : matchedFiles = this.logFiles.getLogFile().getMatchedFiles()) {
            this.fs.delete(matchedFile);
        }
        RuntimeException e = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> this.logFiles.getTailInformation());
        Assertions.assertThat((Throwable)e).getRootCause().hasMessageContaining("LogPosition{logVersion=8,").hasMessageContaining("checkpoint does not point to a valid location in transaction logs.");
    }

    @Override
    protected void writeCheckpoint(LogEntryWriter transactionLogWriter, CheckpointFile separateCheckpointFile, LogPosition logPosition) throws IOException {
        separateCheckpointFile.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, logPosition, Instant.now(), "test");
    }
}

