/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;

class FileSizeThresholdTest {
    private FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LogFileInformation source = (LogFileInformation)Mockito.mock(LogFileInformation.class);
    private final Path file = (Path)Mockito.mock(Path.class);
    private final long version = 1L;

    FileSizeThresholdTest() {
    }

    @Test
    void shouldReturnFalseWhenFileSizeIsLowerThanMaxSize() throws IOException {
        long maxSize = 10L;
        FileSizeThreshold threshold = new FileSizeThreshold(this.fs, 10L);
        Mockito.when((Object)this.fs.getFileSize(this.file)).thenReturn((Object)5L);
        threshold.init();
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void shouldReturnTrueWhenASingleFileSizeIsGreaterOrEqualThanMaxSize() throws IOException {
        long sixteenGigabytes = 0x400000000L;
        FileSizeThreshold threshold = new FileSizeThreshold(this.fs, sixteenGigabytes);
        Mockito.when((Object)this.fs.getFileSize(this.file)).thenReturn((Object)sixteenGigabytes);
        threshold.init();
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void shouldSumSizeWhenCalledMultipleTimes() throws IOException {
        long maxSize = 10L;
        FileSizeThreshold threshold = new FileSizeThreshold(this.fs, 10L);
        Mockito.when((Object)this.fs.getFileSize(this.file)).thenReturn((Object)5L);
        threshold.init();
        threshold.reached(this.file, 1L, this.source);
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void shouldForgetPreviousValuesAfterAInitCall() throws IOException {
        long maxSize = 10L;
        FileSizeThreshold threshold = new FileSizeThreshold(this.fs, 10L);
        Mockito.when((Object)this.fs.getFileSize(this.file)).thenReturn((Object)5L);
        threshold.init();
        threshold.reached(this.file, 1L, this.source);
        threshold.reached(this.file, 1L, this.source);
        threshold.init();
        boolean result = threshold.reached(this.file, 1L, this.source);
        Assertions.assertFalse((boolean)result);
    }
}

