/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruningImpl;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.SystemNanoClock;

class LogPruningTest {
    private final Config config = Config.defaults();
    private FileSystemAbstraction fs;
    private LogFiles logFiles;
    private AssertableLogProvider logProvider;
    private SystemNanoClock clock;
    private LogPruneStrategyFactory factory;

    LogPruningTest() {
    }

    @BeforeEach
    void setUp() {
        this.fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        this.logFiles = (LogFiles)Mockito.mock(LogFiles.class);
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        Mockito.when((Object)this.logFiles.getLogFile()).thenReturn((Object)logFile);
        Mockito.when((Object)this.logFiles.getCheckpointFile()).thenReturn((Object)((CheckpointFile)Mockito.mock(CheckpointFile.class)));
        ((LogFile)Mockito.doAnswer(inv -> Path.of(String.valueOf(inv.getArguments()[0]), new String[0])).when((Object)logFile)).getLogFileForVersion(ArgumentMatchers.anyLong());
        this.logProvider = new AssertableLogProvider();
        this.clock = (SystemNanoClock)Mockito.mock(SystemNanoClock.class);
        this.factory = (LogPruneStrategyFactory)Mockito.mock(LogPruneStrategyFactory.class);
    }

    @Test
    void mustDeleteLogFilesThatCanBePruned() throws IOException {
        Mockito.when((Object)this.factory.strategyFromConfigValue((FileSystemAbstraction)ArgumentMatchers.eq((Object)this.fs), (LogFiles)ArgumentMatchers.eq((Object)this.logFiles), (LogProvider)ArgumentMatchers.eq((Object)this.logProvider), (Clock)ArgumentMatchers.eq((Object)this.clock), ArgumentMatchers.anyString())).thenReturn(upTo -> LongRange.range((long)3L, (long)(upTo - 1L)));
        LogPruningImpl pruning = new LogPruningImpl(this.fs, this.logFiles, (LogProvider)this.logProvider, this.factory, (Clock)this.clock, this.config, (Lock)new ReentrantLock());
        pruning.pruneLogs(5L);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.fs});
        ((FileSystemAbstraction)order.verify((Object)this.fs)).deleteFile(Path.of("3", new String[0]));
        ((FileSystemAbstraction)order.verify((Object)this.fs)).deleteFile(Path.of("4", new String[0]));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fs});
    }

    @Test
    void mustHaveLogFilesToPruneIfStrategyFindsFiles() {
        Mockito.when((Object)this.factory.strategyFromConfigValue((FileSystemAbstraction)ArgumentMatchers.eq((Object)this.fs), (LogFiles)ArgumentMatchers.eq((Object)this.logFiles), (LogProvider)ArgumentMatchers.eq((Object)this.logProvider), (Clock)ArgumentMatchers.eq((Object)this.clock), ArgumentMatchers.anyString())).thenReturn(upTo -> LongRange.range((long)3L, (long)upTo));
        Mockito.when((Object)this.logFiles.getLogFile().getHighestLogVersion()).thenReturn((Object)4L);
        LogPruningImpl pruning = new LogPruningImpl(this.fs, this.logFiles, (LogProvider)this.logProvider, this.factory, (Clock)this.clock, this.config, (Lock)new ReentrantLock());
        Assertions.assertTrue((boolean)pruning.mightHaveLogsToPrune(this.logFiles.getLogFile().getHighestLogVersion()));
    }

    @Test
    void mustNotHaveLogsFilesToPruneIfStrategyFindsNoFiles() {
        Mockito.when((Object)this.factory.strategyFromConfigValue((FileSystemAbstraction)ArgumentMatchers.eq((Object)this.fs), (LogFiles)ArgumentMatchers.eq((Object)this.logFiles), (LogProvider)ArgumentMatchers.eq((Object)this.logProvider), (Clock)ArgumentMatchers.eq((Object)this.clock), ArgumentMatchers.anyString())).thenReturn(x -> LongRange.EMPTY_RANGE);
        LogPruningImpl pruning = new LogPruningImpl(this.fs, this.logFiles, (LogProvider)this.logProvider, this.factory, (Clock)this.clock, this.config, (Lock)new ReentrantLock());
        Assertions.assertFalse((boolean)pruning.mightHaveLogsToPrune(this.logFiles.getLogFile().getHighestLogVersion()));
    }

    @Test
    void mustDescribeCurrentStrategy() {
        this.factory = new LogPruneStrategyFactory();
        this.config.setDynamic(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all", "");
        LogPruningImpl pruning = new LogPruningImpl(this.fs, this.logFiles, (LogProvider)this.logProvider, this.factory, (Clock)this.clock, this.config, (Lock)new ReentrantLock());
        Assertions.assertEquals((Object)"keep_all", (Object)pruning.describeCurrentStrategy());
        this.config.setDynamic(GraphDatabaseSettings.keep_logical_logs, (Object)"10 files", "");
        Assertions.assertEquals((Object)"10 files", (Object)pruning.describeCurrentStrategy());
    }

    @Test
    void mustLogLatestPreservedCheckpointVersion() throws IOException {
        Mockito.when((Object)this.factory.strategyFromConfigValue((FileSystemAbstraction)ArgumentMatchers.eq((Object)this.fs), (LogFiles)ArgumentMatchers.eq((Object)this.logFiles), (LogProvider)ArgumentMatchers.eq((Object)this.logProvider), (Clock)ArgumentMatchers.eq((Object)this.clock), ArgumentMatchers.anyString())).thenReturn(x -> LongRange.EMPTY_RANGE);
        int checkpointLogFilesToKeep = (Integer)this.config.get(GraphDatabaseInternalSettings.checkpoint_logical_log_keep_threshold);
        CheckpointFile checkpointFile = (CheckpointFile)Mockito.mock(CheckpointFile.class);
        Path[] checkpointFiles = new Path[checkpointLogFilesToKeep + 2];
        for (int i = 0; i < checkpointFiles.length; ++i) {
            checkpointFiles[i] = Paths.get(String.valueOf(i), new String[0]);
        }
        Mockito.when((Object)checkpointFile.getDetachedCheckpointFiles()).thenReturn((Object)checkpointFiles);
        Mockito.when((Object)checkpointFile.getDetachedCheckpointLogFileVersion((Path)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> {
            Path file = (Path)invocationOnMock.getArgument(0);
            return Long.parseLong(file.getFileName().toString());
        });
        Mockito.when((Object)checkpointFile.getCurrentDetachedLogVersion()).thenReturn((Object)((long)checkpointFiles.length - 1L));
        Mockito.when((Object)this.logFiles.getCheckpointFile()).thenReturn((Object)checkpointFile);
        LogPruningImpl pruning = new LogPruningImpl(this.fs, this.logFiles, (LogProvider)this.logProvider, this.factory, (Clock)this.clock, this.config, (Lock)new ReentrantLock());
        pruning.pruneLogs(1L);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteFile(checkpointFiles[0]);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteFile(checkpointFiles[1]);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forLevel(AssertableLogProvider.Level.INFO).forClass(LogPruningImpl.class).containsMessages(new String[]{"Pruned 2 checkpoint log files. Lowest preserved version: 2"});
    }
}

