/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.util.Bits;

class TestBits {
    TestBits() {
    }

    @Test
    void asBytes() {
        byte numberOfBytes = 14;
        Bits bits = Bits.bits((int)numberOfBytes);
        for (byte i = 0; i < numberOfBytes; i = (byte)(i + 1)) {
            bits.put(i);
        }
        byte[] bytes = bits.asBytes();
        for (byte i = 0; i < numberOfBytes; i = (byte)(i + 1)) {
            org.junit.jupiter.api.Assertions.assertEquals((byte)i, (byte)bytes[i]);
        }
    }

    @Test
    void doubleAsBytes() {
        double[] array1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        Bits bits = Bits.bits((int)(array1.length * 8));
        for (double value : array1) {
            bits.put(Double.doubleToRawLongBits(value));
        }
        String first = bits.toString();
        byte[] asBytes = bits.asBytes();
        String other = Bits.bitsFromBytes((byte[])asBytes).toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)first, (Object)other);
    }

    @Test
    void doubleAsBytesWithOffset() {
        double[] array1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        Bits bits = Bits.bits((int)(array1.length * 8));
        for (double value : array1) {
            bits.put(Double.doubleToRawLongBits(value));
        }
        int offset = 6;
        byte[] asBytesOffset = bits.asBytes(offset);
        byte[] asBytes = bits.asBytes();
        org.junit.jupiter.api.Assertions.assertEquals((int)asBytes.length, (int)(array1.length * 8));
        org.junit.jupiter.api.Assertions.assertEquals((int)asBytesOffset.length, (int)(array1.length * 8 + offset));
        for (int i = 0; i < asBytes.length; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((byte)asBytesOffset[i + offset], (byte)asBytes[i]);
        }
    }

    @Test
    void writeAndRead() {
        Bits bits;
        for (int b = 5; b <= 8; ++b) {
            bits = Bits.bits((int)16);
            for (byte value = 0; value < 16; value = (byte)(value + 1)) {
                bits.put(value, b);
            }
            byte expected = 0;
            while (bits.available()) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expected, (byte)bits.getByte(b));
                expected = (byte)(expected + 1);
            }
        }
        for (byte value = -128; value < 127; value = (byte)(value + 1)) {
            bits = Bits.bits((int)8);
            bits.put(value);
            org.junit.jupiter.api.Assertions.assertEquals((byte)value, (byte)bits.getByte());
        }
    }

    @Test
    void writeAndReadByteBuffer() {
        byte[] bytes = new byte[512];
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(123456789L);
        buffer.flip();
        Bits bits = Bits.bitsFromBytes((byte[])bytes, (int)0, (int)buffer.limit());
        org.junit.jupiter.api.Assertions.assertEquals((long)123456789L, (long)bits.getLong());
    }

    @Test
    void numberToStringSeparatesAfter8Bits() {
        StringBuilder builder = new StringBuilder();
        Bits.numberToString((StringBuilder)builder, (long)255L, (int)2);
        Assertions.assertThat((String)builder.toString()).isEqualTo("[00000000,11111111]");
    }
}

