/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.util.collection.CachingOffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class CachingOffHeapBlockAllocatorTest {
    private static final int CACHE_SIZE = 4;
    private static final int MAX_CACHEABLE_BLOCK_SIZE = 128;
    private final MemoryTracker memoryTracker = (MemoryTracker)Mockito.spy((Object)new LocalMemoryTracker());
    private final CachingOffHeapBlockAllocator allocator = new CachingOffHeapBlockAllocator(128L, 4);

    CachingOffHeapBlockAllocatorTest() {
    }

    @AfterEach
    void afterEach() {
        this.allocator.release();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedNativeMemory(), (String)"Native memory is leaking");
    }

    @Test
    void allocateAfterRelease() {
        this.allocator.release();
        Assertions.assertThrows(IllegalStateException.class, () -> this.allocator.allocate(128L, this.memoryTracker));
    }

    @Test
    void freeAfterRelease() {
        OffHeapBlockAllocator.MemoryBlock block = this.allocator.allocate(128L, this.memoryTracker);
        this.allocator.release();
        this.allocator.free(block, this.memoryTracker);
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker)).allocateNative(ArgumentMatchers.eq((long)128L));
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker)).releaseNative(ArgumentMatchers.eq((long)128L));
    }

    @Test
    void allocateAndFree() {
        OffHeapBlockAllocator.MemoryBlock block1 = this.allocator.allocate(128L, this.memoryTracker);
        Assertions.assertEquals((long)128L, (long)block1.size);
        Assertions.assertEquals((long)128L, (long)block1.size);
        Assertions.assertEquals((long)block1.size, (long)this.memoryTracker.usedNativeMemory());
        OffHeapBlockAllocator.MemoryBlock block2 = this.allocator.allocate(256L, this.memoryTracker);
        Assertions.assertEquals((long)256L, (long)block2.size);
        Assertions.assertEquals((long)256L, (long)block2.size);
        Assertions.assertEquals((long)(block1.size + block2.size), (long)this.memoryTracker.usedNativeMemory());
        this.allocator.free(block1, this.memoryTracker);
        this.allocator.free(block2, this.memoryTracker);
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedNativeMemory());
    }

    @ParameterizedTest
    @ValueSource(longs={10L, 100L, 256L})
    void allocateNonCacheableSize(long bytes) {
        OffHeapBlockAllocator.MemoryBlock block1 = this.allocator.allocate(bytes, this.memoryTracker);
        this.allocator.free(block1, this.memoryTracker);
        OffHeapBlockAllocator.MemoryBlock block2 = this.allocator.allocate(bytes, this.memoryTracker);
        this.allocator.free(block2, this.memoryTracker);
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)2))).allocateNative(ArgumentMatchers.eq((long)bytes));
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedNativeMemory());
    }

    @ParameterizedTest
    @ValueSource(longs={8L, 64L, 128L})
    void allocateCacheableSize(long bytes) {
        OffHeapBlockAllocator.MemoryBlock block1 = this.allocator.allocate(bytes, this.memoryTracker);
        this.allocator.free(block1, this.memoryTracker);
        OffHeapBlockAllocator.MemoryBlock block2 = this.allocator.allocate(bytes, this.memoryTracker);
        this.allocator.free(block2, this.memoryTracker);
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)2))).allocateNative(ArgumentMatchers.eq((long)bytes));
        Assertions.assertEquals((long)1L, (long)this.allocator.numberOfCachedBlocks());
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedNativeMemory());
    }

    @Test
    void cacheCapacityPerBlockSize() {
        int EXTRA = 3;
        ArrayList<OffHeapBlockAllocator.MemoryBlock> blocks64 = new ArrayList<OffHeapBlockAllocator.MemoryBlock>();
        ArrayList<OffHeapBlockAllocator.MemoryBlock> blocks128 = new ArrayList<OffHeapBlockAllocator.MemoryBlock>();
        for (int i = 0; i < 7; ++i) {
            blocks64.add(this.allocator.allocate(64L, this.memoryTracker));
            blocks128.add(this.allocator.allocate(128L, this.memoryTracker));
        }
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)7))).allocateNative(ArgumentMatchers.eq((long)64L));
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)7))).allocateNative(ArgumentMatchers.eq((long)128L));
        Assertions.assertEquals((long)1344L, (long)this.memoryTracker.usedNativeMemory());
        blocks64.forEach(it -> this.allocator.free(it, this.memoryTracker));
        Assertions.assertEquals((long)896L, (long)this.memoryTracker.usedNativeMemory());
        blocks128.forEach(it -> this.allocator.free(it, this.memoryTracker));
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)8L, (long)this.allocator.numberOfCachedBlocks());
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)14))).releaseNative(ArgumentMatchers.anyLong());
    }
}

