/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.HeapTrackingMapValueBuilder;
import org.neo4j.values.virtual.MapValue;

class HeapTrackingMapValueBuilderTest {
    private final MemoryMeter meter = new MemoryMeter();
    private MemoryTracker memoryTracker;
    private HeapTrackingMapValueBuilder builder;

    HeapTrackingMapValueBuilderTest() {
    }

    @BeforeEach
    void setup() {
        this.memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING);
        this.builder = HeapTrackingMapValueBuilder.newHeapTrackingMapValueBuilder((MemoryTracker)this.memoryTracker);
    }

    @AfterEach
    void tearDown() {
        this.builder.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void calculateEmptySize() {
        this.assertExactEstimation(0L);
    }

    @Test
    void calculateSingleItem() {
        String key = "a";
        this.builder.put("a", (AnyValue)Values.stringValue((String)"a".repeat(128)));
        this.assertExactEstimation(HeapEstimator.sizeOf((String)"a"));
    }

    @Test
    void addAndIterateElements() {
        int iterations = 10;
        long unaccounted = 0L;
        for (int i = 0; i < iterations; ++i) {
            String key = String.valueOf(i);
            this.builder.put(key, (AnyValue)Values.of((Object)i));
            unaccounted += HeapEstimator.sizeOf((String)key);
        }
        this.assertExactEstimation(unaccounted);
        MapValue mapValue = this.builder.build();
        Assertions.assertEquals((int)iterations, (int)mapValue.size());
        for (int i = 0; i < iterations; ++i) {
            Assertions.assertTrue((boolean)mapValue.containsKey(String.valueOf(i)));
            Assertions.assertEquals((int)i, (int)((IntValue)mapValue.get(String.valueOf(i))).intValue());
        }
    }

    void assertExactEstimation(long unaccounted) {
        Assertions.assertEquals((long)(this.meter.measureDeep((Object)this.builder) - this.meter.measureDeep((Object)this.memoryTracker)), (long)(this.memoryTracker.estimatedHeapMemory() + this.builder.getUnAllocatedHeapSize() + unaccounted));
    }
}

