/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.internal.Version;

class VersionTest {
    VersionTest() {
    }

    @Test
    void shouldExposeCleanAndDetailedVersions() {
        Assertions.assertThat((String)VersionTest.version("1.2.3-M01,abcdef012345").getReleaseVersion()).isEqualTo("1.2.3-M01");
        Assertions.assertThat((String)VersionTest.version("1.2.3-M01,abcdef012345").getVersion()).isEqualTo("1.2.3-M01,abcdef012345");
        Assertions.assertThat((String)VersionTest.version("1.2.3-M01,abcdef012345-dirty").getVersion()).isEqualTo("1.2.3-M01,abcdef012345-dirty");
        Assertions.assertThat((String)VersionTest.version("1.2.3,abcdef012345").getReleaseVersion()).isEqualTo("1.2.3");
        Assertions.assertThat((String)VersionTest.version("1.2.3,abcdef012345").getVersion()).isEqualTo("1.2.3,abcdef012345");
        Assertions.assertThat((String)VersionTest.version("1.2.3,abcdef012345-dirty").getVersion()).isEqualTo("1.2.3,abcdef012345-dirty");
        Assertions.assertThat((String)VersionTest.version("1.2.3-GA,abcdef012345").getReleaseVersion()).isEqualTo("1.2.3-GA");
        Assertions.assertThat((String)VersionTest.version("1.2.3-GA,abcdef012345").getVersion()).isEqualTo("1.2.3-GA,abcdef012345");
        Assertions.assertThat((String)VersionTest.version("1.2.3-GA,abcdef012345-dirty").getVersion()).isEqualTo("1.2.3-GA,abcdef012345-dirty");
        Assertions.assertThat((String)VersionTest.version("1.2.3M01,abcdef012345").getReleaseVersion()).isEqualTo("1.2.3M01");
        Assertions.assertThat((String)VersionTest.version("1.2.3M01,abcdef012345").getVersion()).isEqualTo("1.2.3M01,abcdef012345");
        Assertions.assertThat((String)VersionTest.version("1.2.3M01,abcdef012345-dirty").getVersion()).isEqualTo("1.2.3M01,abcdef012345-dirty");
        Assertions.assertThat((String)VersionTest.version("1.2").getReleaseVersion()).isEqualTo("1.2");
        Assertions.assertThat((String)VersionTest.version("1.2").getVersion()).isEqualTo("1.2");
        Assertions.assertThat((String)VersionTest.version("0").getReleaseVersion()).isEqualTo("0");
        Assertions.assertThat((String)VersionTest.version("0").getVersion()).isEqualTo("0");
    }

    @Test
    void versionWithCustomString() {
        String planetExpress = "planetExpress";
        Version planetExpressVersion = VersionTest.version(planetExpress);
        Assertions.assertThat((String)planetExpressVersion.getVersion()).isEqualTo(planetExpress);
        Assertions.assertThat((String)planetExpressVersion.getReleaseVersion()).isEqualTo(planetExpress);
    }

    @Test
    void versionStringSelection() {
        String planetExpress = "planetExpress";
        try {
            System.setProperty("unsupported.neo4j.custom.version", planetExpress);
            org.junit.jupiter.api.Assertions.assertEquals((Object)planetExpress, (Object)Version.selectVersion());
        }
        finally {
            System.clearProperty("unsupported.neo4j.custom.version");
        }
    }

    private static Version version(String version) {
        return new Version("test-component", version);
    }
}

