/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring.tracing;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.tracer.DefaultTracer;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssertions;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

class TracersTest {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final SystemNanoClock clock = Clocks.nanoClock();
    private final Monitors monitors = new Monitors();
    private Log log;

    TracersTest() {
    }

    @BeforeEach
    void setUp() {
        this.log = this.logProvider.getLog(this.getClass());
    }

    @Test
    void mustProduceNullImplementationsWhenRequested() {
        Tracers tracers = this.createTracers("null");
        LogAssertions.assertThat((Object)tracers.getPageCacheTracer()).isEqualTo((Object)PageCacheTracer.NULL);
        LogAssertions.assertThat((Object)tracers.getDatabaseTracer()).isEqualTo((Object)DatabaseTracer.NULL);
        this.assertNoWarning();
    }

    @Test
    void mustProduceDefaultImplementationForNullConfiguration() {
        Tracers tracers = this.createTracers(null);
        TracersTest.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    void mustProduceDefaultImplementationWhenRequested() {
        Tracers tracers = this.createTracers("default");
        TracersTest.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    void mustProduceDefaultImplementationWhenRequestingUnknownImplementation() {
        Tracers tracers = this.createTracers("there's nothing like this");
        TracersTest.assertDefaultImplementation(tracers);
        this.assertWarning("there's nothing like this");
    }

    private Tracers createTracers(String s) {
        return new Tracers(s, this.log, this.monitors, this.jobScheduler, this.clock, Config.defaults());
    }

    private static void assertDefaultImplementation(Tracers tracers) {
        LogAssertions.assertThat((Object)tracers.getPageCacheTracer()).isInstanceOf(DefaultPageCacheTracer.class);
        LogAssertions.assertThat((Object)tracers.getDatabaseTracer()).isInstanceOf(DefaultTracer.class);
    }

    private void assertNoWarning() {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotHaveAnyLogs();
    }

    private void assertWarning(String tracerName) {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(this.getClass()).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithArguments("Using default tracer implementations instead of '%s'", new Object[]{tracerName});
    }
}

