/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.DatabaseLogProvider;
import org.neo4j.logging.internal.DatabaseLogService;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.PrefixedLog;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;

class DatabaseLogServiceTest {
    private LogProvider logProvider;
    private DatabaseLogService logService;
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final NamedDatabaseId namedDatabaseId = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());

    DatabaseLogServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.logProvider = new Log4jLogProvider((OutputStream)this.outContent, Level.DEBUG);
        this.logService = new DatabaseLogService(this.namedDatabaseId, (LogService)new SimpleLogService(this.logProvider));
    }

    @Test
    void shouldReturnUserLogProvider() {
        DatabaseLogProvider logProvider = this.logService.getUserLogProvider();
        PrefixedLog log = (PrefixedLog)logProvider.getLog("log_name");
        log.info("message");
        this.assertLogged("[log_name] [" + this.namedDatabaseId.logPrefix() + "] message");
    }

    @Test
    void shouldReturnInternalLogProvider() {
        DatabaseLogProvider logProvider = this.logService.getInternalLogProvider();
        PrefixedLog log = (PrefixedLog)logProvider.getLog(Object.class);
        log.info("message");
        this.assertLogged("[j.l.Object] [" + this.namedDatabaseId.logPrefix() + "] message");
    }

    @Test
    void shouldReturnDifferentUserAndInternalLogProviders() {
        DatabaseLogProvider userLogProvider = this.logService.getUserLogProvider();
        DatabaseLogProvider internalLogProvider = this.logService.getInternalLogProvider();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)userLogProvider, (Object)internalLogProvider);
    }

    @Test
    void shouldAlwaysReturnSameUserLogProvider() {
        DatabaseLogProvider logProvider1 = this.logService.getUserLogProvider();
        DatabaseLogProvider logProvider2 = this.logService.getUserLogProvider();
        org.junit.jupiter.api.Assertions.assertSame((Object)logProvider1, (Object)logProvider2);
    }

    @Test
    void shouldAlwaysReturnSameInternalLogProvider() {
        DatabaseLogProvider logProvider1 = this.logService.getInternalLogProvider();
        DatabaseLogProvider logProvider2 = this.logService.getInternalLogProvider();
        org.junit.jupiter.api.Assertions.assertSame((Object)logProvider1, (Object)logProvider2);
    }

    private void assertLogged(String message) {
        Assertions.assertThat((String)this.outContent.toString()).contains(new CharSequence[]{message});
    }
}

