/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class TestEphemeralFileChannel {
    @Inject
    private EphemeralFileSystemAbstraction fileSystem;

    TestEphemeralFileChannel() {
    }

    @Test
    void smoke() throws Exception {
        StoreChannel channel = this.fileSystem.write(Path.of("yo", new String[0]));
        ByteBuffer buffer = ByteBuffers.allocate((int)23, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        buffer.put(new byte[23]);
        buffer.flip();
        channel.write(buffer);
        channel = this.fileSystem.write(Path.of("yo", new String[0]));
        long longValue = 1234567890L;
        buffer.clear();
        buffer.limit(1);
        buffer.put((byte)1);
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
        buffer.limit(1);
        buffer.put((byte)2);
        buffer.flip();
        channel.position(6L);
        channel.write(buffer);
        buffer.clear();
        buffer.limit(8);
        buffer.putLong(longValue);
        buffer.flip();
        channel.position(15L);
        channel.write(buffer);
        org.junit.jupiter.api.Assertions.assertEquals((long)23L, (long)channel.size());
        buffer.clear();
        buffer.limit(1);
        channel.read(buffer, 0L);
        buffer.flip();
        org.junit.jupiter.api.Assertions.assertEquals((byte)1, (byte)buffer.get());
        buffer.clear();
        buffer.limit(3);
        channel.read(buffer, 5L);
        buffer.flip();
        org.junit.jupiter.api.Assertions.assertEquals((byte)0, (byte)buffer.get());
        org.junit.jupiter.api.Assertions.assertEquals((byte)2, (byte)buffer.get());
        org.junit.jupiter.api.Assertions.assertEquals((byte)0, (byte)buffer.get());
        buffer.clear();
        buffer.limit(8);
        channel.read(buffer, 15L);
        buffer.flip();
        org.junit.jupiter.api.Assertions.assertEquals((long)longValue, (long)buffer.getLong());
    }

    @Test
    void absoluteVersusRelative() throws Exception {
        Path file = Path.of("myfile", new String[0]).toAbsolutePath();
        StoreChannel channel = this.fileSystem.write(file);
        byte[] bytes = "test".getBytes();
        channel.write(ByteBuffer.wrap(bytes));
        channel.close();
        channel = this.fileSystem.read(file);
        byte[] readBytes = new byte[bytes.length];
        channel.readAll(ByteBuffer.wrap(readBytes));
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])bytes, (byte[])readBytes);
    }

    @Test
    void listFiles() throws Exception {
        Path root = Path.of("/root", new String[0]).toAbsolutePath().normalize();
        Path dir1 = root.resolve("dir1");
        Path dir2 = root.resolve("dir2");
        Path subdir1 = dir1.resolve("sub");
        Path file1 = dir1.resolve("file");
        Path file2 = dir1.resolve("file2");
        Path file3 = dir2.resolve("file");
        Path file4 = subdir1.resolve("file");
        this.fileSystem.mkdirs(dir2);
        this.fileSystem.mkdirs(dir1);
        this.fileSystem.mkdirs(subdir1);
        this.fileSystem.write(file1);
        this.fileSystem.write(file2);
        this.fileSystem.write(file3);
        this.fileSystem.write(file4);
        Assertions.assertThat((Object[])this.fileSystem.listFiles(root)).containsExactlyInAnyOrder((Object[])new Path[]{dir1, dir2});
        Assertions.assertThat((Object[])this.fileSystem.listFiles(dir1)).containsExactlyInAnyOrder((Object[])new Path[]{subdir1, file1, file2});
        Assertions.assertThat((Object[])this.fileSystem.listFiles(dir2)).containsExactly((Object[])new Path[]{file3});
        Assertions.assertThat((Object[])this.fileSystem.listFiles(subdir1)).containsExactly((Object[])new Path[]{file4});
    }
}

