/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.io.pagecache.ByteArrayPageCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.PointKey;
import org.neo4j.kernel.impl.index.schema.PointLayout;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class PointKeyStateTest {
    private final IndexSpecificSpaceFillingCurveSettings noSpecificIndexSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    @Inject
    private RandomSupport random;

    @ParameterizedTest
    @MethodSource(value={"valueGenerators"})
    void readWhatIsWritten(ValueGenerator valueGenerator) {
        PageCursor cursor = PointKeyStateTest.newPageCursor();
        PointKey writeState = this.newKeyState();
        Value value = valueGenerator.next();
        int offset = cursor.getOffset();
        writeState.initialize(123L);
        writeState.writeValue(-1, value, NativeIndexKey.Inclusion.NEUTRAL);
        writeState.writeToCursor(cursor);
        PointKey readState = this.newKeyState();
        int size = writeState.size();
        cursor.setOffset(offset);
        readState.readFromCursor(cursor, size);
        Assertions.assertEquals((int)0, (int)readState.compareValueTo(writeState));
        Value readValue = readState.asValues()[0];
        Assertions.assertEquals((Object)value, (Object)readValue);
        Assertions.assertEquals((long)123L, (long)readState.getEntityId());
    }

    @ParameterizedTest
    @MethodSource(value={"valueGenerators"})
    void copyShouldCopy(ValueGenerator valueGenerator) {
        PointKey from = this.newKeyState();
        Value value = valueGenerator.next();
        from.initialize(123L);
        from.writeValue(-1, value, NativeIndexKey.Inclusion.NEUTRAL);
        PointKey to = this.pointKeyStateWithSomePreviousState(valueGenerator);
        to.copyFrom(from);
        Assertions.assertEquals((int)0, (int)from.compareValueTo(to));
        Assertions.assertEquals((long)123L, (long)to.getEntityId());
    }

    @Test
    void copyShouldCopyExtremeValues() {
        PointKey extreme = this.newKeyState();
        PointKey copy = this.newKeyState();
        extreme.initValueAsLowest(-1, null);
        copy.copyFrom(extreme);
        Assertions.assertEquals((int)0, (int)extreme.compareValueTo(copy));
        extreme.initValueAsHighest(-1, null);
        copy.copyFrom(extreme);
        Assertions.assertEquals((int)0, (int)extreme.compareValueTo(copy));
    }

    @Test
    void comparePointsMustOnlyReturnZeroForEqualPoints() {
        PointValue firstPoint = this.random.randomValues().nextPointValue();
        PointValue equalPoint = Values.point((Point)firstPoint);
        CoordinateReferenceSystem crs = firstPoint.getCoordinateReferenceSystem();
        SpaceFillingCurve curve = this.noSpecificIndexSettings.forCrs(crs);
        Long spaceFillingCurveValue = curve.derivedValueFor(firstPoint.coordinate());
        PointValue centerPoint = Values.pointValue((CoordinateReferenceSystem)crs, (double[])curve.centerPointFor(spaceFillingCurveValue.longValue()));
        PointKey firstKey = this.newKeyState();
        firstKey.writeValue(-1, (Value)firstPoint, NativeIndexKey.Inclusion.NEUTRAL);
        PointKey equalKey = this.newKeyState();
        equalKey.writeValue(-1, (Value)equalPoint, NativeIndexKey.Inclusion.NEUTRAL);
        PointKey centerKey = this.newKeyState();
        centerKey.writeValue(-1, (Value)centerPoint, NativeIndexKey.Inclusion.NEUTRAL);
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo(equalKey));
        Assertions.assertEquals((Object)(firstPoint.compareTo(centerPoint) != 0 ? 1 : 0), (Object)(firstKey.compareValueTo(centerKey) != 0 ? 1 : 0));
    }

    @ParameterizedTest
    @MethodSource(value={"valueGenerators"})
    void mustReportCorrectSize(ValueGenerator valueGenerator) {
        PageCursor cursor = PointKeyStateTest.newPageCursor();
        Value value = valueGenerator.next();
        PointKey state = this.newKeyState();
        state.initialize(123L);
        state.writeValue(-1, value, NativeIndexKey.Inclusion.NEUTRAL);
        int offsetBefore = cursor.getOffset();
        int reportedSize = state.size();
        state.writeToCursor(cursor);
        int offsetAfter = cursor.getOffset();
        int actualSize = offsetAfter - offsetBefore;
        Assertions.assertEquals((int)reportedSize, (int)actualSize);
    }

    @ParameterizedTest
    @MethodSource(value={"valueGenerators"})
    void mustProduceValidMinimalSplittersWhenValuesAreNotEqual(ValueGenerator valueGenerator) {
        PointKey key2;
        PointKey key1 = this.newKeyState();
        Value value1 = valueGenerator.next();
        key1.writeValue(-1, value1, NativeIndexKey.Inclusion.NEUTRAL);
        do {
            key2 = this.newKeyState();
            Value value2 = valueGenerator.next();
            key2.writeValue(-1, value2, NativeIndexKey.Inclusion.NEUTRAL);
        } while (key1.compareValueTo(key2) == 0);
        List keys = Stream.of(key1, key2).sorted(PointKey::compareValueTo).collect(Collectors.toList());
        PointKey splitter = this.newKeyState();
        this.newLayout().minimalSplitter((PointKey)keys.get(0), (PointKey)keys.get(1), splitter);
        Assertions.assertEquals((int)0, (int)((PointKey)keys.get(1)).compareValueTo(splitter));
    }

    @ParameterizedTest
    @MethodSource(value={"valueGenerators"})
    void mustProduceValidMinimalSplittersWhenValuesAreEqual(ValueGenerator valueGenerator) {
        Value value = valueGenerator.next();
        PointLayout layout = this.newLayout();
        PointKey left = layout.newKey();
        PointKey right = layout.newKey();
        PointKey minimalSplitter = layout.newKey();
        left.initialize(123L);
        left.initFromValue(-1, value, NativeIndexKey.Inclusion.NEUTRAL);
        right.initialize(234L);
        right.initFromValue(-1, value, NativeIndexKey.Inclusion.NEUTRAL);
        layout.minimalSplitter(left, right, minimalSplitter);
        Assertions.assertTrue((layout.compare((NativeIndexKey)left, (NativeIndexKey)minimalSplitter) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((layout.compare((NativeIndexKey)minimalSplitter, (NativeIndexKey)right) <= 0 ? 1 : 0) != 0);
        Assertions.assertEquals((long)234L, (long)minimalSplitter.getEntityId());
    }

    @ParameterizedTest
    @MethodSource(value={"valueGenerators"})
    void minimalSplitterShouldRemoveEntityIdIfPossible(ValueGenerator valueGenerator) {
        PointKey key2;
        PointKey key1 = this.newKeyState();
        Value value1 = valueGenerator.next();
        key1.initialize(123L);
        key1.writeValue(-1, value1, NativeIndexKey.Inclusion.NEUTRAL);
        do {
            key2 = this.newKeyState();
            Value value2 = valueGenerator.next();
            key1.initialize(234L);
            key2.writeValue(-1, value2, NativeIndexKey.Inclusion.NEUTRAL);
        } while (key1.compareValueTo(key2) == 0);
        List keys = Stream.of(key1, key2).sorted(PointKey::compareValueTo).collect(Collectors.toList());
        PointKey splitter = this.newKeyState();
        this.newLayout().minimalSplitter((PointKey)keys.get(0), (PointKey)keys.get(1), splitter);
        Assertions.assertEquals((long)-1L, (long)splitter.getEntityId());
    }

    private PointKey pointKeyStateWithSomePreviousState(ValueGenerator valueGenerator) {
        PointKey to = this.newKeyState();
        if (this.random.nextBoolean()) {
            to.setEntityId(this.random.nextLong(1000000L));
            NativeIndexKey.Inclusion inclusion = (NativeIndexKey.Inclusion)this.random.among((Object[])NativeIndexKey.Inclusion.values());
            Value value = valueGenerator.next();
            to.writeValue(-1, value, inclusion);
        }
        return to;
    }

    private Stream<ValueGenerator> valueGenerators() {
        return Stream.of(new ValueGenerator(() -> this.random.randomValues().nextPointValue(), "point"), new ValueGenerator(() -> this.random.randomValues().nextGeographicPoint(), "geographic point"), new ValueGenerator(() -> this.random.randomValues().nextGeographic3DPoint(), "geographic point 3D"), new ValueGenerator(() -> this.random.randomValues().nextCartesianPoint(), "cartesian point"), new ValueGenerator(() -> this.random.randomValues().nextCartesian3DPoint(), "cartesian point 3D"));
    }

    private static PageCursor newPageCursor() {
        return ByteArrayPageCursor.wrap((int)8192);
    }

    private PointKey newKeyState() {
        return new PointKey(this.noSpecificIndexSettings);
    }

    private PointLayout newLayout() {
        return new PointLayout(this.noSpecificIndexSettings);
    }

    private static class ValueGenerator {
        private final Supplier<Value> valueSupplier;
        private final String description;

        ValueGenerator(Supplier<Value> valueSupplier, String description) {
            this.valueSupplier = valueSupplier;
            this.description = description;
        }

        Value next() {
            return this.valueSupplier.get();
        }

        public String toString() {
            return this.description;
        }
    }
}

