/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.BaseAccessorTilesTest;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.PointIndexAccessor;
import org.neo4j.kernel.impl.index.schema.PointIndexProvider;
import org.neo4j.kernel.impl.index.schema.PointKey;
import org.neo4j.kernel.impl.index.schema.PointLayout;

class PointAccessorTilesTest
extends BaseAccessorTilesTest<PointKey> {
    PointAccessorTilesTest() {
    }

    @Override
    IndexDescriptor createDescriptor() {
        return TestIndexDescriptorFactory.forLabel((IndexType)IndexType.POINT, (int)1, (int[])new int[]{1});
    }

    @Override
    NativeIndexAccessor<PointKey> createAccessor() {
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)this.directory.homePath()).forProvider(PointIndexProvider.DESCRIPTOR);
        IndexFiles.Directory indexFiles = new IndexFiles.Directory(this.fs, directoryStructure, this.descriptor.getId());
        PointLayout layout = new PointLayout(indexSettings);
        RecoveryCleanupWorkCollector collector = RecoveryCleanupWorkCollector.ignore();
        DatabaseIndexContext databaseIndexContext = DatabaseIndexContext.builder((PageCache)this.pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").build();
        StandardConfiguration configuration = new StandardConfiguration();
        return new PointIndexAccessor(databaseIndexContext, (IndexFiles)indexFiles, (IndexLayout)layout, collector, this.descriptor, indexSettings, (SpaceFillingCurveConfiguration)configuration);
    }
}

