/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class LockWorkerState {
    private static final AtomicLong TRANSACTION_ID = new AtomicLong();
    final Locks grabber;
    final Locks.Client client;
    final List<String> completedOperations = new ArrayList<String>();
    String doing;

    LockWorkerState(Locks locks) {
        this.grabber = locks;
        this.client = locks.newClient();
        this.client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, TRANSACTION_ID.getAndIncrement(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
    }

    public void doing(String doing) {
        this.doing = doing;
    }

    public void done() {
        this.completedOperations.add(this.doing);
        this.doing = null;
    }
}

