/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;

class TransactionMetadataCacheTest {
    TransactionMetadataCacheTest() {
    }

    @Test
    void shouldReturnNullWhenMissingATxInTheCache() {
        TransactionMetadataCache cache = new TransactionMetadataCache();
        TransactionMetadataCache.TransactionMetadata metadata = cache.getTransactionMetadata(42L);
        Assertions.assertNull((Object)metadata);
    }

    @Test
    void shouldReturnTheTxValueTIfInTheCached() {
        TransactionMetadataCache cache = new TransactionMetadataCache();
        LogPosition position = new LogPosition(3L, 4L);
        int txId = 42;
        cache.cacheTransactionMetadata(42L, position);
        TransactionMetadataCache.TransactionMetadata metadata = cache.getTransactionMetadata(42L);
        Assertions.assertEquals((Object)new TransactionMetadataCache.TransactionMetadata(position), (Object)metadata);
    }

    @Test
    void shouldThrowWhenCachingATxWithNegativeOffsetPosition() {
        TransactionMetadataCache cache = new TransactionMetadataCache();
        LogPosition position = new LogPosition(3L, -1L);
        int txId = 42;
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> cache.cacheTransactionMetadata(42L, position));
        Assertions.assertEquals((Object)("StartEntry.position is " + position), (Object)e.getMessage());
    }

    @Test
    void shouldClearTheCache() {
        TransactionMetadataCache cache = new TransactionMetadataCache();
        LogPosition position = new LogPosition(3L, 4L);
        int txId = 42;
        cache.cacheTransactionMetadata(42L, position);
        cache.clear();
        TransactionMetadataCache.TransactionMetadata metadata = cache.getTransactionMetadata(42L);
        Assertions.assertNull((Object)metadata);
    }
}

