/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvents;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
@ExtendWith(value={LifeExtension.class})
class CompositeCheckpointLogFileTest {
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    private final long rotationThreshold = ByteUnit.mebiBytes((long)1L);
    private final DatabaseHealth databaseHealth = new DatabaseHealth(PanicEventGenerator.NO_OP, (Log)NullLog.getInstance());
    private final LogVersionRepository logVersionRepository = new SimpleLogVersionRepository(1L);
    private final TransactionIdStore transactionIdStore = new SimpleTransactionIdStore(2L, 0, 0L, 0L, 0L);
    private CheckpointFile checkpointFile;
    private TransactionLogWriter transactionLogWriter;
    private LogFiles logFiles;
    private final FakeKernelVersionProvider versionProvider = new FakeKernelVersionProvider();

    CompositeCheckpointLogFileTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.logFiles = this.buildLogFiles();
        this.life.add((Lifecycle)this.logFiles);
        this.life.start();
        this.checkpointFile = this.logFiles.getCheckpointFile();
        this.transactionLogWriter = this.logFiles.getLogFile().getTransactionLogWriter();
    }

    @Test
    void findLogTailShouldWorkForLegacyCheckpoints() throws IOException {
        LogPosition logPosition = new LogPosition(0L, 1L);
        this.writeLegacyCheckpoint(logPosition);
        this.logFiles.getLogFile().forceAfterAppend((LogForceEvents)LogAppendEvent.NULL);
        CheckpointInfo lastCheckPoint = this.checkpointFile.getTailInformation().lastCheckPoint;
        Assertions.assertThat((Comparable)lastCheckPoint.getTransactionLogPosition()).isEqualTo((Object)logPosition);
    }

    @Test
    void findLogTailShouldWorkForDetachedCheckpoints() throws IOException {
        LogPosition logPosition = new LogPosition(this.logVersionRepository.getCurrentLogVersion(), 64L);
        this.checkpointFile.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, logPosition, Instant.now(), "detached");
        CheckpointInfo lastCheckPoint = this.checkpointFile.getTailInformation().lastCheckPoint;
        Assertions.assertThat((Comparable)lastCheckPoint.getTransactionLogPosition()).isEqualTo((Object)logPosition);
    }

    @Test
    void findLogTailShouldWorkForBothLegacyAndDetachedCheckpoints() throws IOException {
        LogPosition logPosition = new LogPosition(0L, 1L);
        this.writeLegacyCheckpoint(logPosition);
        this.logFiles.getLogFile().forceAfterAppend((LogForceEvents)LogAppendEvent.NULL);
        LogPosition logPosition2 = new LogPosition(this.logVersionRepository.getCurrentLogVersion(), 64L);
        this.checkpointFile.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, logPosition2, Instant.now(), "detached");
        CheckpointInfo lastCheckPoint = this.checkpointFile.getTailInformation().lastCheckPoint;
        Assertions.assertThat((Comparable)lastCheckPoint.getTransactionLogPosition()).isEqualTo((Object)logPosition2);
    }

    @Test
    void findLatestCheckpointShouldWorkForBothLegacyAndDetachedCheckpoints() throws IOException {
        LogPosition logPosition = new LogPosition(0L, 1L);
        this.writeLegacyCheckpoint(logPosition);
        this.logFiles.getLogFile().forceAfterAppend((LogForceEvents)LogAppendEvent.NULL);
        Assertions.assertThat((Comparable)((CheckpointInfo)this.checkpointFile.findLatestCheckpoint().orElseThrow()).getTransactionLogPosition()).isEqualTo((Object)logPosition);
        LogPosition logPosition2 = new LogPosition(this.logVersionRepository.getCurrentLogVersion(), 64L);
        this.checkpointFile.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, logPosition2, Instant.now(), "detached");
        Assertions.assertThat((Comparable)((CheckpointInfo)this.checkpointFile.findLatestCheckpoint().orElseThrow()).getTransactionLogPosition()).isEqualTo((Object)logPosition2);
    }

    @Test
    void shouldFindReachableCheckpointsForBothLegacyAndDetachedCheckpoints() throws IOException {
        Assertions.assertThat((List)this.checkpointFile.reachableCheckpoints()).isEmpty();
        Assertions.assertThat((List)this.checkpointFile.getReachableDetachedCheckpoints()).isEmpty();
        LogPosition logPosition = new LogPosition(0L, 1L);
        LogPosition logPosition2 = new LogPosition(0L, 2L);
        this.writeLegacyCheckpoint(logPosition);
        this.writeLegacyCheckpoint(logPosition2);
        this.logFiles.getLogFile().forceAfterAppend((LogForceEvents)LogAppendEvent.NULL);
        LogPosition logPosition3 = new LogPosition(0L, 3L);
        LogPosition logPosition4 = new LogPosition(0L, 4L);
        this.checkpointFile.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, logPosition3, Instant.now(), "detached");
        this.checkpointFile.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, logPosition4, Instant.now(), "detached");
        List reachableCheckpoints = this.checkpointFile.reachableCheckpoints();
        Assertions.assertThat((int)reachableCheckpoints.size()).isEqualTo(4);
        Assertions.assertThat((Comparable)((CheckpointInfo)reachableCheckpoints.get(0)).getTransactionLogPosition()).isEqualTo((Object)logPosition);
        Assertions.assertThat((Comparable)((CheckpointInfo)reachableCheckpoints.get(1)).getTransactionLogPosition()).isEqualTo((Object)logPosition2);
        Assertions.assertThat((Comparable)((CheckpointInfo)reachableCheckpoints.get(2)).getTransactionLogPosition()).isEqualTo((Object)logPosition3);
        Assertions.assertThat((Comparable)((CheckpointInfo)reachableCheckpoints.get(3)).getTransactionLogPosition()).isEqualTo((Object)logPosition4);
        List detachedCheckpoints = this.checkpointFile.getReachableDetachedCheckpoints();
        Assertions.assertThat((int)detachedCheckpoints.size()).isEqualTo(2);
        Assertions.assertThat((Comparable)((CheckpointInfo)detachedCheckpoints.get(0)).getTransactionLogPosition()).isEqualTo((Object)logPosition3);
        Assertions.assertThat((Comparable)((CheckpointInfo)detachedCheckpoints.get(1)).getTransactionLogPosition()).isEqualTo((Object)logPosition4);
    }

    private LogFiles buildLogFiles() throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withRotationThreshold(this.rotationThreshold).withTransactionIdStore(this.transactionIdStore).withDatabaseHealth(this.databaseHealth).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).withKernelVersionProvider((KernelVersionRepository)this.versionProvider).build();
    }

    private void writeLegacyCheckpoint(LogPosition logPosition) throws IOException {
        this.versionProvider.version = KernelVersion.V4_0;
        this.transactionLogWriter.legacyCheckPoint(logPosition);
        this.versionProvider.version = KernelVersion.LATEST;
    }

    private class FakeKernelVersionProvider
    implements KernelVersionRepository {
        volatile KernelVersion version = KernelVersion.LATEST;

        private FakeKernelVersionProvider() {
        }

        public KernelVersion kernelVersion() {
            return this.version;
        }
    }
}

