/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexedStoreScan;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class IndexedStoreScanTest {
    IndexedStoreScanTest() {
    }

    @Test
    void shouldRunStoreScanWithinASharedLock() {
        Config config = Config.defaults();
        Locks locks = (Locks)Mockito.mock(Locks.class);
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE), (IndexProviderDescriptor)TokenIndexProvider.DESCRIPTOR).withName("index").materialise(0L);
        StoreScan delegate = (StoreScan)Mockito.mock(StoreScan.class);
        IndexedStoreScan storeScan = new IndexedStoreScan(locks, index, config, delegate);
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)locks.newClient()).thenReturn((Object)client);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{client, delegate});
        ((Locks.Client)inOrder.verify((Object)client)).initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, config);
        ((Locks.Client)inOrder.verify((Object)client)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, index.schema().lockingKeys());
        ((StoreScan)inOrder.verify((Object)delegate)).run(StoreScan.NO_EXTERNAL_UPDATES);
        ((Locks.Client)inOrder.verify((Object)client)).close();
    }
}

