/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.BtreeKey;
import org.neo4j.kernel.impl.index.schema.GenericBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericBlockBasedIndexPopulatorTest;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.memory.MemoryTracker;

class BtreeBlockBasedIndexPopulatorTest
extends GenericBlockBasedIndexPopulatorTest<BtreeKey> {
    private final Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.index_populator_merge_factor, (Object)2);
    private final IndexSpecificSpaceFillingCurveSettings spatialSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)this.config);

    BtreeBlockBasedIndexPopulatorTest() {
    }

    @Override
    IndexType indexType() {
        return IndexType.BTREE;
    }

    @Override
    BlockBasedIndexPopulator<BtreeKey> instantiatePopulator(BlockStorage.Monitor monitor, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker) throws IOException {
        GenericLayout layout = this.layout();
        StandardConfiguration configuration = new StandardConfiguration();
        GenericBlockBasedIndexPopulator populator = new GenericBlockBasedIndexPopulator(this.databaseIndexContext, this.indexFiles, (IndexLayout)layout, this.INDEX_DESCRIPTOR, this.spatialSettings, (SpaceFillingCurveConfiguration)configuration, false, bufferFactory, this.config, memoryTracker, this.tokenNameLookup, monitor);
        populator.create();
        return populator;
    }

    GenericLayout layout() {
        return new GenericLayout(1, this.spatialSettings);
    }
}

