/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.BaseAccessorTilesTest;
import org.neo4j.kernel.impl.index.schema.BtreeKey;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class GenericAccessorTilesTest
extends BaseAccessorTilesTest<BtreeKey> {
    GenericAccessorTilesTest() {
    }

    @Test
    void mustHandlePointArraysWithinSameTile() throws IndexEntryConflictException, IndexNotApplicableKernelException {
        int nbrOfValues = 10000;
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        Long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] centerPoint = curve.centerPointFor(derivedValueForCenterPoint.longValue());
        double xWidthMultiplier = curve.getTileWidth(0, curve.getMaxLevel()) / 2.0;
        double yWidthMultiplier = curve.getTileWidth(1, curve.getMaxLevel()) / 2.0;
        ArrayList<Value> pointArrays = new ArrayList<Value>();
        ArrayList<IndexEntryUpdate<IndexDescriptor>> updates = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
        for (int i = 0; i < nbrOfValues; ++i) {
            int arrayLength = this.random.nextInt(1, 6);
            PointValue[] pointValues = new PointValue[arrayLength];
            for (int j = 0; j < arrayLength; ++j) {
                double x = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
                double y = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
                PointValue value = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x, centerPoint[1] + y});
                GenericAccessorTilesTest.assertDerivedValue(derivedValueForCenterPoint, value);
                pointValues[j] = value;
            }
            PointArray array = Values.pointArray((PointValue[])pointValues);
            pointArrays.add((Value)array);
            updates.add((IndexEntryUpdate<IndexDescriptor>)IndexEntryUpdate.add((long)i, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{array}));
        }
        this.processAll(updates);
        this.exactMatchOnAllValues(pointArrays);
    }

    @Override
    IndexDescriptor createDescriptor() {
        return TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
    }

    @Override
    NativeIndexAccessor<BtreeKey> createAccessor() {
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)this.directory.homePath()).forProvider(GenericNativeIndexProvider.DESCRIPTOR);
        IndexFiles.Directory indexFiles = new IndexFiles.Directory(this.fs, directoryStructure, this.descriptor.getId());
        GenericLayout layout = new GenericLayout(1, indexSettings);
        RecoveryCleanupWorkCollector collector = RecoveryCleanupWorkCollector.ignore();
        DatabaseIndexContext databaseIndexContext = DatabaseIndexContext.builder((PageCache)this.pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").build();
        StandardConfiguration configuration = new StandardConfiguration();
        return new GenericNativeIndexAccessor(databaseIndexContext, (IndexFiles)indexFiles, (IndexLayout)layout, collector, this.descriptor, indexSettings, (SpaceFillingCurveConfiguration)configuration, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
    }
}

