/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.mutable.MutableObject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.defaultanswers.ReturnsDeepStubs;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistry;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;

class Neo4jTransactionalContextTest {
    private GraphDatabaseQueryService queryService;
    private KernelStatement statement;
    private ConfiguredExecutionStatistics statistics;
    private final KernelTransactionFactory transactionFactory = (KernelTransactionFactory)Mockito.mock(KernelTransactionFactory.class);
    private final NamedDatabaseId namedDatabaseId = DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID());

    Neo4jTransactionalContextTest() {
    }

    @BeforeEach
    void setUp() {
        this.setUpMocks();
    }

    @Test
    void contextRollbackClosesAndRollbackTransaction() {
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction kernelTransaction = this.mockTransaction((Statement)this.statement);
        Mockito.when((Object)internalTransaction.kernelTransaction()).thenReturn((Object)kernelTransaction);
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(null, internalTransaction, this.statement, executingQuery, this.transactionFactory);
        transactionalContext.rollback();
        ((InternalTransaction)Mockito.verify((Object)internalTransaction)).rollback();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)transactionalContext.isOpen());
    }

    @Test
    void rollsBackNewlyCreatedTransactionIfTerminationDetectedOnCloseDuringPeriodicCommit() throws TransactionFailureException {
        InternalTransaction userTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction.Type transactionType = KernelTransaction.Type.IMPLICIT;
        SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        ClientConnectionInfo connectionInfo = ClientConnectionInfo.EMBEDDED_CONNECTION;
        Mockito.when((Object)userTransaction.transactionType()).thenReturn((Object)transactionType);
        Mockito.when((Object)userTransaction.clientInfo()).thenReturn((Object)connectionInfo);
        Mockito.when((Object)userTransaction.securityContext()).thenReturn((Object)securityContext);
        Mockito.when((Object)userTransaction.terminationReason()).thenReturn(Optional.empty());
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        KernelStatement initialStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        KernelTransaction initialKTX = this.mockTransaction((Statement)initialStatement);
        QueryRegistry initialQueryRegistry = (QueryRegistry)Mockito.mock(QueryRegistry.class);
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        KernelStatement secondStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        KernelTransaction secondKTX = this.mockTransaction((Statement)secondStatement);
        QueryRegistry secondQueryRegistry = (QueryRegistry)Mockito.mock(QueryRegistry.class);
        Mockito.when((Object)this.transactionFactory.beginKernelTransaction(transactionType, (LoginContext)securityContext, connectionInfo)).thenReturn((Object)secondKTX);
        Mockito.when((Object)executingQuery.databaseId()).thenReturn(Optional.of(this.namedDatabaseId));
        ((KernelTransaction)Mockito.doThrow(RuntimeException.class).when((Object)initialKTX)).commit();
        Mockito.when((Object)initialStatement.queryRegistry()).thenReturn((Object)initialQueryRegistry);
        Mockito.when((Object)userTransaction.kernelTransaction()).thenReturn((Object)initialKTX, (Object[])new KernelTransaction[]{initialKTX, secondKTX});
        Mockito.when((Object)secondStatement.queryRegistry()).thenReturn((Object)secondQueryRegistry);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(queryService, userTransaction, initialStatement, executingQuery, this.transactionFactory);
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> ((Neo4jTransactionalContext)context).commitAndRestartTx());
        ((InternalTransaction)Mockito.verify((Object)userTransaction)).rollback();
    }

    @Test
    void shouldCloseInnerTransactionOnOuterTermination() {
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        InternalTransaction transaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        InternalTransaction innerTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction kernelTransaction = this.mockTransaction((Statement)this.statement);
        Mockito.when((Object)transaction.kernelTransaction()).thenReturn((Object)kernelTransaction);
        Mockito.when((Object)transaction.transactionType()).thenReturn((Object)KernelTransaction.Type.IMPLICIT);
        GraphDatabaseQueryService graph = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        Mockito.when((Object)graph.beginTransaction((KernelTransaction.Type)ArgumentMatchers.any(), (LoginContext)ArgumentMatchers.any(), (ClientConnectionInfo)ArgumentMatchers.any())).thenReturn((Object)innerTransaction);
        TransactionTerminatedException error = new TransactionTerminatedException((Status)Status.Transaction.Terminated);
        Mockito.when((Object)innerTransaction.kernelTransaction()).thenThrow(new Throwable[]{error});
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(graph, transaction, this.statement, executingQuery, this.transactionFactory);
        Assertions.assertThatThrownBy(() -> ((Neo4jTransactionalContext)transactionalContext).contextWithNewTransaction()).isSameAs((Object)error);
        ((InternalTransaction)Mockito.verify((Object)innerTransaction)).close();
    }

    @Test
    void shouldBeOpenAfterCreation() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Neo4jTransactionalContext context = this.newContext(tx);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)context.isOpen());
    }

    @Test
    void shouldBeTopLevelWithImplicitTx() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.IMPLICIT);
        Neo4jTransactionalContext context = this.newContext(tx);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)context.isTopLevelTx());
    }

    @Test
    void shouldNotBeTopLevelWithExplicitTx() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.EXPLICIT);
        Neo4jTransactionalContext context = this.newContext(tx);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)context.isTopLevelTx());
    }

    @Test
    void shouldNotCloseTransactionDuringTermination() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.IMPLICIT);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx)).terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).close();
    }

    @Test
    void shouldBePossibleToCloseAfterTermination() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)tx.transactionType()).thenReturn((Object)KernelTransaction.Type.IMPLICIT);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx)).terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).close();
        context.close();
    }

    @Test
    void shouldBePossibleToTerminateWithoutActiveTransaction() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Neo4jTransactionalContext context = this.newContext(tx);
        context.close();
        context.terminate();
        ((InternalTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).terminate();
    }

    @Test
    void shouldThrowWhenRestartedAfterTermination() {
        MutableObject terminationReason = new MutableObject();
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        ((InternalTransaction)Mockito.doAnswer(invocation -> {
            terminationReason.setValue((Object)Status.Transaction.Terminated);
            return null;
        }).when((Object)tx)).terminate();
        Mockito.when((Object)tx.terminationReason()).then(invocation -> Optional.ofNullable((Status)terminationReason.getValue()));
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        org.junit.jupiter.api.Assertions.assertThrows(TransactionTerminatedException.class, () -> ((Neo4jTransactionalContext)context).commitAndRestartTx());
    }

    @Test
    void shouldThrowWhenAssertIsOpenAfterTermination() {
        MutableObject terminationReason = new MutableObject();
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        ((InternalTransaction)Mockito.doAnswer(invocation -> {
            terminationReason.setValue((Object)Status.Transaction.Terminated);
            return null;
        }).when((Object)tx)).terminate();
        Mockito.when((Object)tx.terminationReason()).then(invocation -> Optional.ofNullable((Status)terminationReason.getValue()));
        Neo4jTransactionalContext context = this.newContext(tx);
        context.terminate();
        org.junit.jupiter.api.Assertions.assertThrows(TransactionTerminatedException.class, () -> ((Neo4jTransactionalContext)context).getOrBeginNewIfClosed());
    }

    @Test
    void shouldBePossibleToCloseMultipleTimes() {
        InternalTransaction tx = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Neo4jTransactionalContext context = this.newContext(tx);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> {
            context.close();
            context.close();
            context.close();
        });
    }

    private void setUpMocks() {
        this.queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        this.statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        this.statistics = new ConfiguredExecutionStatistics();
        QueryRegistry queryRegistry = (QueryRegistry)Mockito.mock(QueryRegistry.class);
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)internalTransaction.terminationReason()).thenReturn(Optional.empty());
        Mockito.when((Object)this.statement.queryRegistry()).thenReturn((Object)queryRegistry);
        Mockito.when((Object)this.queryService.getDependencyResolver()).thenReturn((Object)resolver);
        Mockito.when((Object)this.queryService.beginTransaction((KernelTransaction.Type)ArgumentMatchers.any(), (LoginContext)ArgumentMatchers.any(), (ClientConnectionInfo)ArgumentMatchers.any())).thenReturn((Object)internalTransaction);
    }

    private Neo4jTransactionalContext newContext(InternalTransaction initialTx) {
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        Mockito.when((Object)executingQuery.databaseId()).thenReturn(Optional.of(this.namedDatabaseId));
        return new Neo4jTransactionalContext(this.queryService, initialTx, this.statement, executingQuery, this.transactionFactory);
    }

    private KernelTransaction mockTransaction(Statement statement) {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class, (Answer)new ReturnsDeepStubs());
        Mockito.when((Object)kernelTransaction.executionStatistics()).thenReturn((Object)this.statistics);
        Mockito.when((Object)kernelTransaction.acquireStatement()).thenReturn((Object)statement);
        return kernelTransaction;
    }

    private static class ConfiguredExecutionStatistics
    implements ExecutionStatistics {
        private long hits;
        private long faults;

        private ConfiguredExecutionStatistics() {
        }

        public long pageHits() {
            return this.hits;
        }

        public long pageFaults() {
            return this.faults;
        }

        void setHits(long hits) {
            this.hits = hits;
        }

        void setFaults(long faults) {
            this.faults = faults;
        }
    }
}

