/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.GivenTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.reverse.ReverseTransactionCursorLoggingMonitor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedMultiFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class, LifeExtension.class})
class ReversedMultiFileTransactionCursorTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private LifeSupport life;
    @Inject
    private RandomSupport random;
    private long txId = 1L;
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private ReverseTransactionCursorLoggingMonitor monitor;
    private LogFile logFile;
    private LogFiles logFiles;

    ReversedMultiFileTransactionCursorTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        this.logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs).withLogVersionRepository((LogVersionRepository)logVersionRepository).withTransactionIdStore((TransactionIdStore)transactionIdStore).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.life.add((Lifecycle)this.logFiles);
        this.logFile = this.logFiles.getLogFile();
        this.monitor = (ReverseTransactionCursorLoggingMonitor)Mockito.mock(ReverseTransactionCursorLoggingMonitor.class);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldReadFromSingleVersion(boolean presketch) throws Exception {
        this.writeTransactions(10);
        CommittedTransactionRepresentation[] readTransactions = this.readTransactions(presketch);
        this.assertRecovery(presketch, readTransactions, this.txId, 1L);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldReadUptoASpecificStartingPosition(boolean presketch) throws Exception {
        LogPosition position = this.writeTransactions(2);
        this.writeTransactions(5);
        CommittedTransactionRepresentation[] readTransactions = this.readTransactions(position, presketch);
        this.assertRecovery(presketch, readTransactions, this.txId, 3L);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldReadMultipleVersions(boolean presketch) throws Exception {
        this.writeTransactions(10);
        this.logFile.rotate();
        this.writeTransactions(5);
        this.logFile.rotate();
        this.writeTransactions(2);
        CommittedTransactionRepresentation[] readTransactions = this.readTransactions(presketch);
        this.assertRecovery(presketch, readTransactions, this.txId, 1L);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldReadUptoASpecificStartingPositionFromMultipleVersions(boolean presketch) throws Exception {
        this.writeTransactions(10);
        this.logFile.rotate();
        LogPosition position = this.writeTransactions(5);
        this.writeTransactions(2);
        this.logFile.rotate();
        this.writeTransactions(2);
        CommittedTransactionRepresentation[] readTransactions = this.readTransactions(position, presketch);
        this.assertRecovery(presketch, readTransactions, this.txId, this.txId - 4L);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldHandleEmptyLogsMidStream(boolean presketch) throws Exception {
        this.writeTransactions(10);
        this.logFile.rotate();
        this.logFile.rotate();
        this.writeTransactions(2);
        CommittedTransactionRepresentation[] readTransactions = this.readTransactions(presketch);
        this.assertRecovery(presketch, readTransactions, this.txId, 1L);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldHandleEmptyTransactions(boolean presketch) throws Exception {
        Object[] readTransactions = this.readTransactions(presketch);
        Assertions.assertThat((Object[])readTransactions).isEmpty();
    }

    private CommittedTransactionRepresentation[] readTransactions(LogPosition position, boolean presketch) throws IOException {
        try (TransactionCursor cursor = this.txCursor(position, presketch);){
            CommittedTransactionRepresentation[] committedTransactionRepresentationArray = GivenTransactionCursor.exhaust(cursor);
            return committedTransactionRepresentationArray;
        }
    }

    private CommittedTransactionRepresentation[] readTransactions(boolean presketch) throws IOException {
        return this.readTransactions(new LogPosition(0L, 64L), presketch);
    }

    private void assertRecovery(boolean presketch, CommittedTransactionRepresentation[] readTransactions, long highTxId, long lowTxId) {
        if (presketch) {
            ((ReverseTransactionCursorLoggingMonitor)Mockito.verify((Object)this.monitor)).presketchingTransactionLogs();
        } else {
            ((ReverseTransactionCursorLoggingMonitor)Mockito.verify((Object)this.monitor, (VerificationMode)Mockito.never())).presketchingTransactionLogs();
        }
        long expectedTxId = highTxId;
        for (CommittedTransactionRepresentation tx : readTransactions) {
            org.junit.jupiter.api.Assertions.assertEquals((long)expectedTxId, (long)tx.getCommitEntry().getTxId());
            --expectedTxId;
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedTxId, (long)lowTxId);
    }

    private TransactionCursor txCursor(LogPosition position, boolean presketch) throws IOException {
        ReadAheadLogChannel fileReader = (ReadAheadLogChannel)this.logFile.getReader(this.logFiles.getLogFile().extractHeader(0L).getStartPosition());
        try {
            return ReversedMultiFileTransactionCursor.fromLogFile((LogFile)this.logFile, (LogPosition)position, (LogEntryReader)TestLogEntryReader.logEntryReader(), (boolean)false, (ReversedTransactionCursorMonitor)this.monitor, (boolean)presketch);
        }
        catch (Exception e) {
            fileReader.close();
            throw e;
        }
    }

    private LogPosition writeTransactions(int count) throws IOException {
        FlushablePositionAwareChecksumChannel channel = this.logFile.getTransactionLogWriter().getChannel();
        TransactionLogWriter writer = this.logFile.getTransactionLogWriter();
        int previousChecksum = -559063315;
        for (int i = 0; i < count; ++i) {
            previousChecksum = writer.append(ReversedMultiFileTransactionCursorTest.tx(this.random.intBetween(1, 5)), ++this.txId, previousChecksum);
        }
        channel.prepareForFlush().flush();
        return writer.getCurrentPosition();
    }

    private static TransactionRepresentation tx(int size) {
        ArrayList<TestCommand> commands = new ArrayList<TestCommand>();
        for (int i = 0; i < size; ++i) {
            commands.add(new TestCommand());
        }
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(new byte[0], 0L, 0L, 0L, 0, AuthSubject.ANONYMOUS);
        return tx;
    }
}

