/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.kernel.impl.util.collection.HeapTrackingLongEnumerationList;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class HeapTrackingLongEnumerationListTest {
    private final MemoryMeter meter = new MemoryMeter();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final long measuredMemoryTracker = this.meter.measureDeep((Object)this.memoryTracker);
    @Inject
    private RandomSupport random;
    private final HeapTrackingLongEnumerationList<Long> table = HeapTrackingLongEnumerationList.create((MemoryTracker)this.memoryTracker);

    HeapTrackingLongEnumerationListTest() {
    }

    @AfterEach
    void tearDown() {
        this.table.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void shouldThrowIfChunkSizeNotPowerOfTwo() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HeapTrackingLongEnumerationList.create((MemoryTracker)this.memoryTracker, (int)3));
    }

    @Test
    void add() {
        long i;
        for (i = 0L; i < 10000L; ++i) {
            this.table.add((Object)(i + 1L));
        }
        for (i = 9999L; i >= 0L; --i) {
            Assertions.assertEquals((long)(i + 1L), (Long)((Long)this.table.get(i)));
        }
        Assertions.assertEquals((long)9999L, (long)this.table.lastKey());
        this.assertHeapUsageWithNumberOfLongs(10000L);
    }

    @Test
    void put() {
        long i;
        for (i = 0L; i < 10000L; i += 5L) {
            Assertions.assertNull((Object)this.table.put(i, (Object)(i + 1L)));
        }
        for (i = 9999L; i >= 0L; --i) {
            if (i % 5L == 0L) {
                Assertions.assertEquals((long)(i + 1L), (Long)((Long)this.table.get(i)));
                continue;
            }
            Assertions.assertNull((Object)this.table.get(i));
        }
        Assertions.assertEquals((long)9995L, (long)this.table.lastKey());
        this.assertHeapUsageWithNumberOfLongs(2000L);
    }

    @Test
    void shouldThrowIfPutBeforeFirstKey() {
        Assertions.assertNull((Object)this.table.put(1L, (Object)1L));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.table.put(0L, (Object)0L));
    }

    @Test
    void putOutOfOrder() {
        this.table.put(10L, (Object)10L);
        this.table.put(20L, (Object)20L);
        Assertions.assertNull((Object)this.table.put(15L, (Object)14L));
        Assertions.assertEquals((Long)((Long)this.table.put(15L, (Object)15L)), (long)14L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly(this.table, new long[]{10L, 15L, 20L});
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.table.put(9L, (Object)9L));
    }

    @Test
    void putOutOfOrderSparse() {
        this.table.put(1000L, (Object)1000L);
        this.table.put(8000L, (Object)8000L);
        this.table.put(4000L, (Object)4000L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly(this.table, new long[]{1000L, 4000L, 8000L});
    }

    @Test
    void addNullShouldBeTheSameAsAddingAndRemoving() {
        this.table.add(null);
        this.table.add(null);
        this.table.add(null);
        Assertions.assertNull((Object)this.table.get(0L));
        Assertions.assertNull((Object)this.table.get(1L));
        Assertions.assertNull((Object)this.table.get(2L));
        Assertions.assertNull((Object)this.table.getFirst());
        Assertions.assertEquals((long)2L, (long)this.table.lastKey());
        this.table.foreach((k, v) -> Assertions.fail());
        Assertions.assertFalse((boolean)this.table.valuesIterator().hasNext());
        this.assertHeapUsageWithNumberOfLongs(0L);
        this.table.add((Object)42L);
        Assertions.assertNull((Object)this.table.get(0L));
        Assertions.assertNull((Object)this.table.get(1L));
        Assertions.assertNull((Object)this.table.get(2L));
        Assertions.assertEquals((long)42L, (Long)((Long)this.table.get(3L)));
        Assertions.assertEquals((long)42L, (Long)((Long)this.table.getFirst()));
        Assertions.assertEquals((long)3L, (long)this.table.lastKey());
        this.table.foreach((k, v) -> Assertions.assertEquals((long)42L, (Long)v));
        Iterator it = this.table.valuesIterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((long)42L, (Long)((Long)it.next()));
        Assertions.assertFalse((boolean)it.hasNext());
        this.assertHeapUsageWithNumberOfLongs(1L);
        this.table.add(null);
        this.table.add(null);
        this.table.add(null);
        Assertions.assertNull((Object)this.table.get(4L));
        Assertions.assertNull((Object)this.table.get(5L));
        Assertions.assertNull((Object)this.table.get(6L));
        Assertions.assertEquals((long)42L, (Long)((Long)this.table.getFirst()));
        Assertions.assertEquals((long)6L, (long)this.table.lastKey());
        this.table.foreach((k, v) -> Assertions.assertEquals((long)42L, (Long)v));
        Iterator it2 = this.table.valuesIterator();
        Assertions.assertTrue((boolean)it2.hasNext());
        Assertions.assertEquals((long)42L, (Long)((Long)it2.next()));
        Assertions.assertFalse((boolean)it2.hasNext());
        this.assertHeapUsageWithNumberOfLongs(1L);
        this.table.remove(3L);
        Assertions.assertNull((Object)this.table.get(0L));
        Assertions.assertNull((Object)this.table.get(1L));
        Assertions.assertNull((Object)this.table.get(2L));
        Assertions.assertNull((Object)this.table.getFirst());
        Assertions.assertEquals((long)6L, (long)this.table.lastKey());
        this.table.foreach((k, v) -> Assertions.fail());
        Assertions.assertFalse((boolean)this.table.valuesIterator().hasNext());
        this.assertHeapUsageWithNumberOfLongs(0L);
    }

    @Test
    void putNullShouldBeTheSameAsAddingAndRemoving() {
        this.table.put(0L, null);
        this.table.put(1L, null);
        this.table.put(2L, null);
        Assertions.assertNull((Object)this.table.get(0L));
        Assertions.assertNull((Object)this.table.get(1L));
        Assertions.assertNull((Object)this.table.get(2L));
        Assertions.assertNull((Object)this.table.getFirst());
        Assertions.assertEquals((long)2L, (long)this.table.lastKey());
        this.table.foreach((k, v) -> Assertions.fail());
        Assertions.assertFalse((boolean)this.table.valuesIterator().hasNext());
        this.assertHeapUsageWithNumberOfLongs(0L);
        this.table.put(5L, (Object)42L);
        Assertions.assertNull((Object)this.table.get(0L));
        Assertions.assertNull((Object)this.table.get(1L));
        Assertions.assertNull((Object)this.table.get(2L));
        Assertions.assertNull((Object)this.table.get(3L));
        Assertions.assertNull((Object)this.table.get(4L));
        Assertions.assertEquals((long)42L, (Long)((Long)this.table.get(5L)));
        Assertions.assertEquals((long)42L, (Long)((Long)this.table.getFirst()));
        Assertions.assertEquals((long)5L, (long)this.table.lastKey());
        this.table.foreach((k, v) -> Assertions.assertEquals((long)42L, (Long)v));
        Iterator it = this.table.valuesIterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((long)42L, (Long)((Long)it.next()));
        Assertions.assertFalse((boolean)it.hasNext());
        this.assertHeapUsageWithNumberOfLongs(1L);
        this.table.put(8L, null);
        this.table.put(6L, null);
        this.table.put(7L, null);
        Assertions.assertNull((Object)this.table.get(6L));
        Assertions.assertNull((Object)this.table.get(7L));
        Assertions.assertNull((Object)this.table.get(8L));
        Assertions.assertEquals((long)42L, (Long)((Long)this.table.getFirst()));
        Assertions.assertEquals((long)8L, (long)this.table.lastKey());
        this.table.foreach((k, v) -> Assertions.assertEquals((long)42L, (Long)v));
        Iterator it2 = this.table.valuesIterator();
        Assertions.assertTrue((boolean)it2.hasNext());
        Assertions.assertEquals((long)42L, (Long)((Long)it2.next()));
        Assertions.assertFalse((boolean)it2.hasNext());
        this.assertHeapUsageWithNumberOfLongs(1L);
        this.table.remove(5L);
        Assertions.assertNull((Object)this.table.get(0L));
        Assertions.assertNull((Object)this.table.get(1L));
        Assertions.assertNull((Object)this.table.get(2L));
        Assertions.assertNull((Object)this.table.get(3L));
        Assertions.assertNull((Object)this.table.get(4L));
        Assertions.assertNull((Object)this.table.getFirst());
        Assertions.assertEquals((long)8L, (long)this.table.lastKey());
        this.table.foreach((k, v) -> Assertions.fail());
        Assertions.assertFalse((boolean)this.table.valuesIterator().hasNext());
        this.assertHeapUsageWithNumberOfLongs(0L);
    }

    @Test
    void remove() {
        long i;
        long size = 10000L;
        for (i = 0L; i < size / 2L; ++i) {
            this.table.add((Object)(i + 1L));
        }
        Assertions.assertEquals((long)4999L, (long)this.table.lastKey());
        this.assertHeapUsageWithNumberOfLongs(5000L);
        for (i = 0L; i < size / 4L; ++i) {
            this.table.remove(i);
        }
        Assertions.assertEquals((long)4999L, (long)this.table.lastKey());
        this.assertHeapUsageWithNumberOfLongs(2500L);
        for (i = size / 2L; i < size; ++i) {
            this.table.add((Object)(i + 1L));
        }
        Assertions.assertEquals((long)9999L, (long)this.table.lastKey());
        this.assertHeapUsageWithNumberOfLongs(7500L);
        this.table.remove(9901L);
        for (i = 0L; i < size; ++i) {
            if (i < size / 4L || i == 9901L) {
                Assertions.assertNull((Object)this.table.get(i));
                continue;
            }
            Assertions.assertEquals((long)(i + 1L), (Long)((Long)this.table.get(i)));
        }
        this.assertHeapUsageWithNumberOfLongs(7499L);
    }

    @Test
    void removeUntil() {
        long i;
        long size = 10000L;
        for (i = 0L; i < size; ++i) {
            this.table.add((Object)(i + 100000L));
        }
        Assertions.assertEquals((long)9999L, (long)this.table.lastKey());
        this.assertHeapUsageWithNumberOfLongs(10000L);
        for (i = size / 4L; i < size - size / 4L; ++i) {
            this.table.remove(i);
        }
        Assertions.assertEquals((long)9999L, (long)this.table.lastKey());
        this.assertHeapUsageWithNumberOfLongs(5000L);
        long[] ia = new long[]{0L};
        this.table.removeUntil(9000L, (removedKey, removedValue) -> {
            Assertions.assertEquals((long)ia[0], (Long)removedKey);
            Assertions.assertEquals((long)(ia[0] + 100000L), (Long)removedValue);
            ia[0] = ia[0] + 1L;
            if (ia[0] == 2500L) {
                ia[0] = ia[0] + 5000L;
            }
        });
        Assertions.assertEquals((long)9999L, (long)this.table.lastKey());
        this.assertHeapUsageWithNumberOfLongs(1000L);
        this.table.removeUntil(20000L, (removedKey, removedValue) -> {
            Assertions.assertEquals((long)ia[0], (Long)removedKey);
            Assertions.assertEquals((long)(ia[0] + 100000L), (Long)removedValue);
            ia[0] = ia[0] + 1L;
        });
        Assertions.assertEquals((long)9999L, (long)this.table.lastKey());
        this.assertHeapUsageWithNumberOfLongs(0L);
    }

    @Test
    void removeAtChunkBoundaries() {
        int i;
        int size = Math.max(1024, 4);
        for (i = 0; i < size * 3 + 1; ++i) {
            this.table.add((Object)i);
        }
        for (i = size; i < size * 2; ++i) {
            this.table.remove((long)i);
        }
        this.table.remove(0L);
        this.table.remove((long)(size - 1));
        this.table.remove((long)(size * 2));
        Assertions.assertEquals((long)1L, (Long)((Long)this.table.getFirst()));
        Assertions.assertNull((Object)this.table.get(0L));
        Assertions.assertNull((Object)this.table.get((long)(size - 1)));
        Assertions.assertNull((Object)this.table.get((long)(size * 2)));
        Assertions.assertNull((Object)this.table.get((long)(size * 3 + 1)));
        Assertions.assertEquals((long)1L, (Long)((Long)this.table.get(1L)));
        Assertions.assertEquals((long)(size * 2 + 1), (Long)((Long)this.table.get((long)(size * 2 + 1))));
        Assertions.assertEquals((long)(size * 3), (Long)((Long)this.table.get((long)(size * 3))));
        for (i = size; i < size * 2; ++i) {
            Assertions.assertNull((Object)this.table.get((long)i));
        }
        AtomicInteger i2 = new AtomicInteger(0);
        this.table.foreach((k, v) -> {
            Assertions.assertEquals((Long)k, (Long)v);
            Assertions.assertNotEquals((long)0L, (Long)k);
            Assertions.assertNotEquals((long)(size - 1), (Long)k);
            Assertions.assertNotEquals((long)(size * 2), (Long)k);
            Assertions.assertFalse((k >= (long)size && k < (long)(size * 2) || k > (long)(size * 3 + 1) ? 1 : 0) != 0);
            i2.getAndIncrement();
        });
        Assertions.assertEquals((int)i2.get(), (int)(size * 2 - 2));
        Iterator it = this.table.valuesIterator();
        long expected = 1L;
        while (it.hasNext()) {
            Long value = (Long)it.next();
            if (expected == (long)(size - 1)) {
                expected += (long)(size + 2);
            }
            Assertions.assertEquals((long)expected, (Long)value);
            ++expected;
        }
        this.assertHeapUsageWithNumberOfLongs(size * 2 - 2);
    }

    @Test
    void foreach() {
        long i;
        long size = 10000L;
        for (i = 0L; i < 5000L; ++i) {
            this.table.add((Object)i);
        }
        for (i = 0L; i < 2500L; ++i) {
            this.table.remove(i);
        }
        for (i = 5000L; i < size; ++i) {
            this.table.add((Object)i);
        }
        this.table.remove(9901L);
        AtomicInteger i2 = new AtomicInteger(2500);
        this.table.foreach((k, v) -> {
            int expected = i2.get();
            if (expected >= 9901) {
                ++expected;
            }
            Assertions.assertEquals((long)expected, (Long)k);
            Assertions.assertEquals((long)expected, (Long)v);
            i2.getAndIncrement();
        });
        Assertions.assertEquals((int)i2.get(), (int)9999);
    }

    @Test
    void addRemoveScenario() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        HeapTrackingLongEnumerationList table = HeapTrackingLongEnumerationList.create((MemoryTracker)memoryTracker, (int)4);
        HeapTrackingLongEnumerationListTest.assertEmpty((HeapTrackingLongEnumerationList<Long>)table);
        table.add((Object)0L);
        table.add((Object)1L);
        table.add((Object)2L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 0L, 2L);
        table.remove(0L);
        table.remove(1L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 2L);
        table.remove(2L);
        HeapTrackingLongEnumerationListTest.assertEmpty((HeapTrackingLongEnumerationList<Long>)table);
        table.add((Object)3L);
        table.add((Object)4L);
        table.add((Object)5L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 3L, 5L);
        table.remove(5L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 3L, 4L);
        table.remove(4L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 3L);
        long measured1 = this.meter.measureDeep((Object)table) - this.measuredMemoryTracker;
        Assertions.assertEquals((long)measured1, (long)(memoryTracker.estimatedHeapMemory() + (long)HeapEstimator.LONG_SIZE));
        table.add((Object)6L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{3L, 6L});
        long measured2 = this.meter.measureDeep((Object)table) - this.measuredMemoryTracker;
        Assertions.assertEquals((long)measured2, (long)(memoryTracker.estimatedHeapMemory() + (long)(2 * HeapEstimator.LONG_SIZE)));
        Assertions.assertEquals((long)HeapEstimator.LONG_SIZE, (long)(measured2 - measured1));
        table.add((Object)7L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{3L, 6L, 7L});
        table.add((Object)8L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{3L, 6L, 7L, 8L});
        table.remove(6L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{3L, 7L, 8L});
        table.remove(3L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{7L, 8L});
        table.remove(7L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 8L);
        long measured3 = this.meter.measureDeep((Object)table) - this.measuredMemoryTracker;
        Assertions.assertEquals((long)measured3, (long)(memoryTracker.estimatedHeapMemory() + (long)HeapEstimator.LONG_SIZE));
        Assertions.assertEquals((long)measured1, (long)measured3);
        table.add((Object)9L);
        table.add((Object)10L);
        table.add((Object)11L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 8L, 11L);
        table.remove(8L);
        table.remove(10L);
        table.remove(11L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 9L);
        table.add((Object)12L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{9L, 12L});
        table.remove(9L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 12L);
        long measured4 = this.meter.measureDeep((Object)table) - this.measuredMemoryTracker;
        Assertions.assertEquals((long)measured4, (long)(memoryTracker.estimatedHeapMemory() + (long)HeapEstimator.LONG_SIZE));
        Assertions.assertEquals((long)measured3, (long)measured4);
        table.close();
    }

    @Test
    void addPutRemoveScenario() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        HeapTrackingLongEnumerationList table = HeapTrackingLongEnumerationList.create((MemoryTracker)memoryTracker, (int)4);
        HeapTrackingLongEnumerationListTest.assertEmpty((HeapTrackingLongEnumerationList<Long>)table);
        table.add((Object)0L);
        table.put(2L, (Object)2L);
        table.put(1L, (Object)1L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 0L, 2L);
        table.remove(0L);
        table.remove(1L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 2L);
        table.remove(2L);
        HeapTrackingLongEnumerationListTest.assertEmpty((HeapTrackingLongEnumerationList<Long>)table);
        table.add((Object)9999L);
        table.put(4L, (Object)4L);
        Assertions.assertEquals((Long)((Long)table.put(3L, (Object)3L)), (long)9999L);
        table.add((Object)5L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 3L, 5L);
        table.remove(5L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 3L, 4L);
        table.remove(4L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 3L);
        long measured1 = this.meter.measureDeep((Object)table) - this.measuredMemoryTracker;
        Assertions.assertEquals((long)measured1, (long)(memoryTracker.estimatedHeapMemory() + (long)HeapEstimator.LONG_SIZE));
        table.put(6L, (Object)6L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{3L, 6L});
        long measured2 = this.meter.measureDeep((Object)table) - this.measuredMemoryTracker;
        Assertions.assertEquals((long)measured2, (long)(memoryTracker.estimatedHeapMemory() + (long)(2 * HeapEstimator.LONG_SIZE)));
        Assertions.assertEquals((long)HeapEstimator.LONG_SIZE, (long)(measured2 - measured1));
        table.put(8L, (Object)8L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{3L, 6L, 8L});
        table.put(7L, (Object)7L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{3L, 6L, 7L, 8L});
        table.remove(6L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{3L, 7L, 8L});
        table.remove(3L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{7L, 8L});
        table.remove(7L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 8L);
        long measured3 = this.meter.measureDeep((Object)table) - this.measuredMemoryTracker;
        Assertions.assertEquals((long)measured3, (long)(memoryTracker.estimatedHeapMemory() + (long)HeapEstimator.LONG_SIZE));
        Assertions.assertEquals((long)measured1, (long)measured3);
        table.put(10L, (Object)10L);
        table.put(9L, (Object)9L);
        table.add((Object)11L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 8L, 11L);
        table.remove(8L);
        table.remove(10L);
        table.remove(11L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 9L);
        table.put(12L, (Object)12L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, new long[]{9L, 12L});
        table.remove(9L);
        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, 12L);
        long measured4 = this.meter.measureDeep((Object)table) - this.measuredMemoryTracker;
        Assertions.assertEquals((long)measured4, (long)(memoryTracker.estimatedHeapMemory() + (long)HeapEstimator.LONG_SIZE));
        Assertions.assertEquals((long)measured3, (long)measured4);
        table.close();
    }

    @Test
    void addRemoveAllFirstCycle() {
        int nElements = 2500;
        long key = 0L;
        Assertions.assertNull((Object)this.table.getFirst());
        for (int i = 0; i < nElements; ++i) {
            this.table.add((Object)key++);
        }
        long measuredAfterAdd1 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterAdd1 = this.memoryTracker.estimatedHeapMemory() + (long)(nElements * HeapEstimator.LONG_SIZE);
        for (int i = 0; i < nElements; ++i) {
            this.table.remove((long)i);
        }
        long measuredAfterRemove1 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterRemove1 = this.memoryTracker.estimatedHeapMemory();
        Assertions.assertNull((Object)this.table.getFirst());
        Assertions.assertEquals((long)(key - 1L), (long)this.table.lastKey());
        this.table.add((Object)key++);
        Assertions.assertEquals((long)(key - 1L), (Long)((Long)this.table.getFirst()));
        Assertions.assertEquals((long)(key - 1L), (long)this.table.lastKey());
        for (int i = 1; i < nElements; ++i) {
            this.table.add((Object)key++);
        }
        long measuredAfterAdd2 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterAdd2 = this.memoryTracker.estimatedHeapMemory() + (long)(nElements * HeapEstimator.LONG_SIZE);
        for (int i = 0; i < nElements; ++i) {
            this.table.remove((long)(i + nElements));
        }
        long measuredAfterRemove2 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterRemove2 = this.memoryTracker.estimatedHeapMemory();
        Assertions.assertNull((Object)this.table.getFirst());
        Assertions.assertEquals((long)(key - 1L), (long)this.table.lastKey());
        this.table.add((Object)key++);
        Assertions.assertEquals((long)(key - 1L), (Long)((Long)this.table.getFirst()));
        Assertions.assertEquals((long)(key - 1L), (long)this.table.lastKey());
        long measured = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        Assertions.assertEquals((long)measuredAfterAdd1, (long)estimatedAfterAdd1);
        Assertions.assertEquals((long)measuredAfterAdd2, (long)estimatedAfterAdd2);
        Assertions.assertEquals((long)measured, (long)(this.memoryTracker.estimatedHeapMemory() + (long)HeapEstimator.LONG_SIZE));
        Assertions.assertEquals((long)measuredAfterAdd1, (long)measuredAfterAdd2);
        Assertions.assertEquals((long)measuredAfterRemove1, (long)measuredAfterRemove2);
        Assertions.assertEquals((long)estimatedAfterAdd1, (long)estimatedAfterAdd2);
        Assertions.assertEquals((long)estimatedAfterRemove1, (long)estimatedAfterRemove2);
    }

    @Test
    void addRemoveChunkFirstCycle() {
        int size = 1024;
        long key = 0L;
        long measuredEmpty = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedEmpty = this.memoryTracker.estimatedHeapMemory();
        Assertions.assertNull((Object)this.table.getFirst());
        for (int i = 0; i < size; ++i) {
            this.table.add((Object)key++);
        }
        long measuredAfterAdd1 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterAdd1 = this.memoryTracker.estimatedHeapMemory() + (long)(size * HeapEstimator.LONG_SIZE);
        for (int i = 0; i < size; ++i) {
            this.table.remove((long)i);
        }
        long measuredAfterRemove1 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterRemove1 = this.memoryTracker.estimatedHeapMemory();
        Assertions.assertNull((Object)this.table.getFirst());
        this.table.add((Object)key);
        Assertions.assertEquals((long)key, (Long)((Long)this.table.getFirst()));
        ++key;
        for (int i = 1; i < size; ++i) {
            this.table.add((Object)key++);
        }
        long measuredAfterAdd2 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterAdd2 = this.memoryTracker.estimatedHeapMemory() + (long)(size * HeapEstimator.LONG_SIZE);
        for (int i = 0; i < size; ++i) {
            this.table.remove((long)(i + size));
        }
        long measuredAfterRemove2 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterRemove2 = this.memoryTracker.estimatedHeapMemory();
        Assertions.assertNull((Object)this.table.getFirst());
        this.table.add((Object)key);
        Assertions.assertEquals((long)key, (Long)((Long)this.table.getFirst()));
        long measuredLast = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedLast = this.memoryTracker.estimatedHeapMemory() + (long)HeapEstimator.LONG_SIZE;
        Assertions.assertEquals((long)measuredAfterAdd1, (long)estimatedAfterAdd1);
        Assertions.assertEquals((long)measuredAfterRemove1, (long)estimatedAfterRemove1);
        Assertions.assertEquals((long)measuredAfterAdd2, (long)estimatedAfterAdd2);
        Assertions.assertEquals((long)measuredAfterRemove2, (long)estimatedAfterRemove2);
        Assertions.assertEquals((long)measuredLast, (long)estimatedLast);
        Assertions.assertEquals((long)measuredAfterAdd1, (long)measuredAfterAdd2);
        Assertions.assertEquals((long)measuredAfterRemove1, (long)measuredAfterRemove2);
        Assertions.assertEquals((long)estimatedAfterAdd1, (long)estimatedAfterAdd2);
        Assertions.assertEquals((long)estimatedAfterRemove1, (long)estimatedAfterRemove2);
        Assertions.assertEquals((long)measuredEmpty, (long)(measuredAfterAdd1 - (long)(size * HeapEstimator.LONG_SIZE)));
        Assertions.assertEquals((long)measuredEmpty, (long)measuredAfterRemove1);
        Assertions.assertEquals((long)measuredEmpty, (long)(measuredAfterAdd2 - (long)(size * HeapEstimator.LONG_SIZE)));
        Assertions.assertEquals((long)measuredEmpty, (long)measuredAfterRemove2);
        Assertions.assertEquals((long)estimatedEmpty, (long)(estimatedAfterAdd1 - (long)(size * HeapEstimator.LONG_SIZE)));
        Assertions.assertEquals((long)estimatedEmpty, (long)estimatedAfterRemove1);
        Assertions.assertEquals((long)estimatedEmpty, (long)(estimatedAfterAdd2 - (long)(size * HeapEstimator.LONG_SIZE)));
        Assertions.assertEquals((long)estimatedEmpty, (long)estimatedAfterRemove2);
    }

    @Test
    void addRemoveChunkFirstCycleWithOffset() {
        int size = 1024;
        long key = 0L;
        long measuredEmpty = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedEmpty = this.memoryTracker.estimatedHeapMemory();
        Assertions.assertNull((Object)this.table.getFirst());
        this.table.add((Object)key);
        this.table.remove(key);
        Assertions.assertNull((Object)this.table.getFirst());
        for (long i = ++key; i < key + (long)size; ++i) {
            this.table.add((Object)i);
        }
        long measuredAfterAdd1 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterAdd1 = this.memoryTracker.estimatedHeapMemory() + (long)(size * HeapEstimator.LONG_SIZE);
        for (long i = key; i < key + (long)size; ++i) {
            this.table.remove(i);
        }
        long measuredAfterRemove1 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterRemove1 = this.memoryTracker.estimatedHeapMemory();
        Assertions.assertNull((Object)this.table.getFirst());
        for (long i = key += (long)size; i < key + (long)size; ++i) {
            this.table.add((Object)i);
        }
        long measuredAfterAdd2 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterAdd2 = this.memoryTracker.estimatedHeapMemory() + (long)(size * HeapEstimator.LONG_SIZE);
        for (long i = key; i < key + (long)size; ++i) {
            this.table.remove(i);
        }
        long measuredAfterRemove2 = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedAfterRemove2 = this.memoryTracker.estimatedHeapMemory();
        Assertions.assertNull((Object)this.table.getFirst());
        this.table.add((Object)(key += (long)size));
        Assertions.assertEquals((long)key, (Long)((Long)this.table.getFirst()));
        long measuredLast = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        long estimatedLast = this.memoryTracker.estimatedHeapMemory() + (long)HeapEstimator.LONG_SIZE;
        Assertions.assertEquals((long)measuredAfterAdd1, (long)estimatedAfterAdd1);
        Assertions.assertEquals((long)measuredAfterRemove1, (long)estimatedAfterRemove1);
        Assertions.assertEquals((long)measuredAfterAdd2, (long)estimatedAfterAdd2);
        Assertions.assertEquals((long)measuredAfterRemove2, (long)estimatedAfterRemove2);
        Assertions.assertEquals((long)measuredLast, (long)estimatedLast);
        Assertions.assertEquals((long)measuredAfterAdd1, (long)measuredAfterAdd2);
        Assertions.assertEquals((long)measuredAfterRemove1, (long)measuredAfterRemove2);
        Assertions.assertEquals((long)estimatedAfterAdd1, (long)estimatedAfterAdd2);
        Assertions.assertEquals((long)estimatedAfterRemove1, (long)estimatedAfterRemove2);
        Assertions.assertEquals((long)measuredEmpty, (long)(measuredAfterAdd1 - (long)(size * HeapEstimator.LONG_SIZE)));
        Assertions.assertEquals((long)measuredEmpty, (long)measuredAfterRemove1);
        Assertions.assertEquals((long)measuredEmpty, (long)(measuredAfterAdd2 - (long)(size * HeapEstimator.LONG_SIZE)));
        Assertions.assertEquals((long)measuredEmpty, (long)measuredAfterRemove2);
        Assertions.assertEquals((long)estimatedEmpty, (long)(estimatedAfterAdd1 - (long)(size * HeapEstimator.LONG_SIZE)));
        Assertions.assertEquals((long)estimatedEmpty, (long)estimatedAfterRemove1);
        Assertions.assertEquals((long)estimatedEmpty, (long)(estimatedAfterAdd2 - (long)(size * HeapEstimator.LONG_SIZE)));
        Assertions.assertEquals((long)estimatedEmpty, (long)estimatedAfterRemove2);
    }

    @Test
    void getWhenEmpty() {
        Assertions.assertNull((Object)this.table.get(-1L));
        Assertions.assertNull((Object)this.table.get(0L));
        Assertions.assertNull((Object)this.table.get(1023L));
        Assertions.assertNull((Object)this.table.get(1024L));
    }

    @Test
    void valuesIterator() {
        long i;
        long size = 10000L;
        for (i = 0L; i < size / 2L; ++i) {
            this.table.add((Object)i);
        }
        for (i = 0L; i < size / 4L; ++i) {
            this.table.remove(i);
        }
        for (i = size / 2L; i < size; ++i) {
            this.table.add((Object)i);
        }
        this.table.remove(9901L);
        Iterator it = this.table.valuesIterator();
        for (long i2 = size / 4L; i2 < size - 1L; ++i2) {
            Assertions.assertTrue((boolean)it.hasNext());
            Long entry = (Long)it.next();
            if (i2 < 9901L) {
                Assertions.assertEquals((long)i2, (Long)entry);
                continue;
            }
            Assertions.assertEquals((long)(i2 + 1L), (Long)entry);
        }
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    void emptySize() {
        this.assertHeapUsageWithNumberOfLongs(0L);
    }

    @Test
    void closeShouldReleaseEverything() {
        long value1 = 11L;
        long externalAllocation = this.meter.measure((Object)value1);
        this.memoryTracker.allocateHeap(externalAllocation);
        this.table.add((Object)value1);
        long actualSize = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        Assertions.assertEquals((long)actualSize, (long)this.memoryTracker.estimatedHeapMemory());
        this.table.close();
        Assertions.assertEquals((long)externalAllocation, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.releaseHeap(externalAllocation);
    }

    @Test
    void fuzzTest() {
        int i;
        ArrayList<Long> referenceValues = new ArrayList<Long>();
        ArrayList<ListOperation> opList = new ArrayList<ListOperation>();
        int chunkSize = (Integer)this.random.among((Object[])new Integer[]{1, 2, 4, 8, 16, 1024});
        HeapTrackingLongEnumerationList table = HeapTrackingLongEnumerationList.create((MemoryTracker)this.memoryTracker, (int)chunkSize);
        int iterations = this.random.intBetween(1000, 2000);
        int addPercentage = this.random.intBetween(40, 70);
        int nAdds = iterations * addPercentage / 100;
        int nRemoves = iterations - nAdds;
        for (i = 0; i < nAdds; ++i) {
            opList.add(ListOperation.ADD);
        }
        for (i = 0; i < nRemoves; ++i) {
            opList.add(ListOperation.REMOVE);
        }
        Collections.shuffle(opList, this.random.random());
        int opCount = 0;
        long key = 0L;
        try {
            for (ListOperation op : opList) {
                switch (op) {
                    case ADD: {
                        referenceValues.add(key);
                        table.add((Object)key++);
                        Assertions.assertEquals((long)(key - 1L), (Long)((Long)table.get(key - 1L)));
                        HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, referenceValues);
                        break;
                    }
                    case REMOVE: {
                        if (!referenceValues.isEmpty()) {
                            int i2 = this.random.intBetween(0, referenceValues.size() - 1);
                            int k = ((Long)referenceValues.remove(i2)).intValue();
                            Long actual = (Long)table.remove((long)k);
                            Assertions.assertEquals((long)k, (Long)actual);
                            HeapTrackingLongEnumerationListTest.assertContainsOnly((HeapTrackingLongEnumerationList<Long>)table, referenceValues);
                            break;
                        }
                        HeapTrackingLongEnumerationListTest.assertEmpty((HeapTrackingLongEnumerationList<Long>)table);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                Assertions.assertEquals((long)(key - 1L), (long)table.lastKey());
                ++opCount;
            }
            table.close();
        }
        catch (Throwable t) {
            System.err.println(String.format("Failed with chunk size %s after %s operations (last added key = %s)", chunkSize, opCount, key - 1L));
            throw t;
        }
    }

    private void assertHeapUsageWithNumberOfLongs(long numberOfBoxedLongs) {
        long measured = this.meter.measureDeep(this.table) - this.measuredMemoryTracker;
        Assertions.assertEquals((long)measured, (long)(this.memoryTracker.estimatedHeapMemory() + numberOfBoxedLongs * (long)HeapEstimator.LONG_SIZE));
    }

    private static void assertEmpty(HeapTrackingLongEnumerationList<Long> table) {
        Assertions.assertNull((Object)table.getFirst());
        Assertions.assertFalse((boolean)table.valuesIterator().hasNext());
        table.foreach((k, v) -> Assertions.fail());
        Assertions.assertNull((Object)table.get(0L));
        Assertions.assertNull((Object)table.get(table.lastKey()));
    }

    private static void assertContainsOnly(HeapTrackingLongEnumerationList<Long> table, long element) {
        HeapTrackingLongEnumerationListTest.assertContainsOnly(table, element, element);
    }

    private static void assertContainsOnly(HeapTrackingLongEnumerationList<Long> table, long from, long to) {
        long until = to + 1L;
        Assertions.assertEquals((long)from, (Long)((Long)table.getFirst()));
        for (long i = from; i <= to; ++i) {
            Assertions.assertEquals((long)i, (Long)((Long)table.get(i)));
        }
        Assertions.assertNull((Object)table.get(from - 1L));
        Assertions.assertNull((Object)table.get(to + 1L));
        long[] i = new long[]{from};
        table.foreach((k, v) -> {
            if (i[0] >= until) {
                Assertions.fail((String)"foreach out of range");
            }
            long expected = i[0];
            Assertions.assertEquals((long)expected, (Long)k);
            Assertions.assertEquals((long)expected, (Long)v);
            i[0] = i[0] + 1L;
        });
        Assertions.assertEquals((long)until, (long)i[0]);
        long i2 = from;
        Iterator it = table.valuesIterator();
        while (it.hasNext()) {
            long value = (Long)it.next();
            Assertions.assertEquals((long)i2, (long)value);
            ++i2;
        }
        Assertions.assertEquals((long)until, (long)i2);
    }

    private static void assertContainsOnly(HeapTrackingLongEnumerationList<Long> table, long[] expected) {
        HeapTrackingLongEnumerationListTest.assertContainsOnly(table, Arrays.stream(expected).boxed().collect(Collectors.toList()));
    }

    private static void assertContainsOnly(HeapTrackingLongEnumerationList<Long> table, List<Long> expected) {
        if (expected.size() > 0) {
            Assertions.assertEquals((Long)expected.get(0), (Long)((Long)table.getFirst()));
        }
        long nullFrom = -1L;
        for (long i : expected) {
            Assertions.assertEquals((long)i, (Long)((Long)table.get(i)));
            for (long nullKey = nullFrom; nullKey < i; ++nullKey) {
                Assertions.assertNull((Object)table.get(nullKey));
            }
            nullFrom = i + 1L;
        }
        if (expected.size() > 0) {
            Assertions.assertNull((Object)table.get(expected.get(0) - 1L));
            Assertions.assertNull((Object)table.get(expected.get(expected.size() - 1) + 1L));
        }
        int[] i = new int[1];
        table.foreach((k, v) -> {
            if (i[0] >= expected.size()) {
                Assertions.fail((String)"foreach out of range");
            }
            Long expect = (Long)expected.get(i[0]);
            Assertions.assertEquals((Long)expect, (Long)k);
            Assertions.assertEquals((Long)expect, (Long)v);
            i[0] = i[0] + 1;
        });
        Assertions.assertEquals((int)expected.size(), (int)i[0]);
        int i2 = 0;
        Iterator it = table.valuesIterator();
        while (it.hasNext()) {
            long value = (Long)it.next();
            Assertions.assertEquals((Long)expected.get(i2), (long)value);
            ++i2;
        }
        Assertions.assertEquals((int)expected.size(), (int)i2);
    }

    static enum ListOperation {
        ADD,
        REMOVE;

    }
}

