/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.info.CannedJvmMetadataRepository;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssertions;

class JVMCheckerTest {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final Log log = this.logProvider.getLog("test");

    JVMCheckerTest() {
    }

    @Test
    void shouldIssueWarningWhenUsingHotspotServerVmVersion12() {
        new JvmChecker(this.log, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "12")).checkJvmCompatibilityAndIssueWarning();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) 11 or OpenJDK(TM) 11."});
    }

    @Test
    void shouldNotIssueWarningWhenUsingHotspotServerVmVersion11() {
        new JvmChecker(this.log, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11")).checkJvmCompatibilityAndIssueWarning();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) 11 or OpenJDK(TM) 11.");
    }

    @Test
    void shouldIssueWarningWhenUsingUnsupportedJvmVersion() {
        new JvmChecker(this.log, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "22.33.44.55")).checkJvmCompatibilityAndIssueWarning();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) 11 or OpenJDK(TM) 11."});
    }

    @Test
    void warnAboutMissingInitialHeapSize() {
        new JvmChecker(this.log, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11.0.2+9", Collections.singletonList("-XMx"), 12L, 23L)).checkJvmCompatibilityAndIssueWarning();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{JvmChecker.initialMemorySettingWarning((long)12L)});
    }

    @Test
    void warnAboutMissingMaximumHeapSize() {
        new JvmChecker(this.log, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11", Collections.singletonList("-XMs"), 12L, 23L)).checkJvmCompatibilityAndIssueWarning();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{JvmChecker.maxMemorySettingWarning((long)23L)});
    }

    @Test
    void warnAboutMissingHeapSizes() {
        new JvmChecker(this.log, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11.0.1")).checkJvmCompatibilityAndIssueWarning();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{JvmChecker.initialMemorySettingWarning((long)1L)});
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{JvmChecker.maxMemorySettingWarning((long)2L)});
    }

    @Test
    void doNotWarnAboutMissingHeapSizesWhenOptionsSpecified() {
        new JvmChecker(this.log, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11.0.2", Arrays.asList("-xMx", "-xmS"), 1L, 2L)).checkJvmCompatibilityAndIssueWarning();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage(JvmChecker.initialMemorySettingWarning((long)1L));
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage(JvmChecker.maxMemorySettingWarning((long)2L));
    }
}

