/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;

class CountCommittedTransactionThreshold
extends AbstractCheckPointThreshold {
    private final int notificationThreshold;
    private volatile long nextTransactionIdTarget;

    CountCommittedTransactionThreshold(int notificationThreshold) {
        super("every " + notificationThreshold + " transactions threshold");
        this.notificationThreshold = notificationThreshold;
    }

    @Override
    public void initialize(long transactionId, LogPosition logPosition) {
        this.nextTransactionIdTarget = transactionId + (long)this.notificationThreshold;
    }

    @Override
    protected boolean thresholdReached(long lastCommittedTransactionId, LogPosition logPosition) {
        return lastCommittedTransactionId >= this.nextTransactionIdTarget;
    }

    @Override
    public void checkPointHappened(long transactionId, LogPosition logPosition) {
        this.nextTransactionIdTarget = transactionId + (long)this.notificationThreshold;
    }

    @Override
    public long checkFrequencyMillis() {
        return DEFAULT_CHECKING_FREQUENCY_MILLIS;
    }
}

