/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.index.schema.BtreeKey;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GeometryType;
import org.neo4j.kernel.impl.index.schema.IndexKeyStateTest;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.AnyValues;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class BtreeKeyStateTest
extends IndexKeyStateTest<BtreeKey> {
    private final IndexSpecificSpaceFillingCurveSettings noSpecificIndexSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());

    BtreeKeyStateTest() {
    }

    @Test
    void comparePointsMustOnlyReturnZeroForEqualPoints() {
        PointValue firstPoint = this.random.randomValues().nextPointValue();
        PointValue equalPoint = Values.point((Point)firstPoint);
        CoordinateReferenceSystem crs = firstPoint.getCoordinateReferenceSystem();
        SpaceFillingCurve curve = this.noSpecificIndexSettings.forCrs(crs);
        Long spaceFillingCurveValue = curve.derivedValueFor(firstPoint.coordinate());
        PointValue centerPoint = Values.pointValue((CoordinateReferenceSystem)crs, (double[])curve.centerPointFor(spaceFillingCurveValue.longValue()));
        BtreeKey firstKey = (BtreeKey)this.newKeyState();
        firstKey.writeValue((Value)firstPoint, NativeIndexKey.Inclusion.NEUTRAL);
        BtreeKey equalKey = (BtreeKey)this.newKeyState();
        equalKey.writeValue((Value)equalPoint, NativeIndexKey.Inclusion.NEUTRAL);
        BtreeKey centerKey = (BtreeKey)this.newKeyState();
        centerKey.writeValue((Value)centerPoint, NativeIndexKey.Inclusion.NEUTRAL);
        BtreeKey noCoordsKey = (BtreeKey)this.newKeyState();
        noCoordsKey.writeValue((Value)equalPoint, NativeIndexKey.Inclusion.NEUTRAL);
        GeometryType.setNoCoordinates((GenericKey)noCoordsKey);
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo((GenericKey)equalKey), (String)"expected keys to be equal");
        Assertions.assertEquals((Object)(firstPoint.compareTo(centerPoint) != 0 ? 1 : 0), (Object)(firstKey.compareValueTo((GenericKey)centerKey) != 0 ? 1 : 0), (String)"expected keys to be equal if and only if source points are equal");
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo((GenericKey)noCoordsKey), (String)"expected keys to be equal");
    }

    @Test
    void comparePointArraysMustOnlyReturnZeroForEqualArrays() {
        PointArray firstArray = this.random.randomValues().nextPointArray();
        PointValue[] sourcePointValues = (PointValue[])firstArray.asObjectCopy();
        PointArray equalArray = Values.pointArray((PointValue[])sourcePointValues);
        PointValue[] centerPointValues = new PointValue[sourcePointValues.length];
        for (int i = 0; i < sourcePointValues.length; ++i) {
            PointValue sourcePointValue = sourcePointValues[i];
            CoordinateReferenceSystem crs = sourcePointValue.getCoordinateReferenceSystem();
            SpaceFillingCurve curve = this.noSpecificIndexSettings.forCrs(crs);
            Long spaceFillingCurveValue = curve.derivedValueFor(sourcePointValue.coordinate());
            centerPointValues[i] = Values.pointValue((CoordinateReferenceSystem)crs, (double[])curve.centerPointFor(spaceFillingCurveValue.longValue()));
        }
        PointArray centerArray = Values.pointArray((PointValue[])centerPointValues);
        BtreeKey firstKey = (BtreeKey)this.newKeyState();
        firstKey.writeValue((Value)firstArray, NativeIndexKey.Inclusion.NEUTRAL);
        BtreeKey equalKey = (BtreeKey)this.newKeyState();
        equalKey.writeValue((Value)equalArray, NativeIndexKey.Inclusion.NEUTRAL);
        BtreeKey centerKey = (BtreeKey)this.newKeyState();
        centerKey.writeValue((Value)centerArray, NativeIndexKey.Inclusion.NEUTRAL);
        BtreeKey noCoordsKey = (BtreeKey)this.newKeyState();
        noCoordsKey.writeValue((Value)equalArray, NativeIndexKey.Inclusion.NEUTRAL);
        GeometryType.setNoCoordinates((GenericKey)noCoordsKey);
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo((GenericKey)equalKey), (String)"expected keys to be equal");
        Assertions.assertEquals((Object)(firstArray.compareToSequence((SequenceValue)centerArray, AnyValues.COMPARATOR) != 0 ? 1 : 0), (Object)(firstKey.compareValueTo((GenericKey)centerKey) != 0 ? 1 : 0), (String)"expected keys to be equal if and only if source points are equal");
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo((GenericKey)noCoordsKey), (String)"expected keys to be equal");
    }

    @Override
    boolean includePointTypesForComparisons() {
        return false;
    }

    @Override
    int getPointSerialisedSize(int dimensions) {
        if (dimensions == 2) {
            return 28;
        }
        if (dimensions == 3) {
            return 36;
        }
        throw new RuntimeException("Did not expect spatial value with " + dimensions + " dimensions.");
    }

    @Override
    int getArrayPointSerialisedSize(int dimensions) {
        if (dimensions == 2) {
            return 24;
        }
        if (dimensions == 3) {
            return 32;
        }
        throw new RuntimeException("Did not expect spatial value with " + dimensions + " dimensions.");
    }

    @Override
    IndexKeyStateTest.Layout<BtreeKey> newLayout(int numberOfSlots) {
        final GenericLayout btreeLayout = new GenericLayout(numberOfSlots, this.noSpecificIndexSettings);
        return new IndexKeyStateTest.Layout<BtreeKey>(){

            @Override
            public BtreeKey newKey() {
                return btreeLayout.newKey();
            }

            @Override
            public void minimalSplitter(BtreeKey left, BtreeKey right, BtreeKey into) {
                btreeLayout.minimalSplitter(left, right, into);
            }

            @Override
            public int compare(BtreeKey k1, BtreeKey k2) {
                return btreeLayout.compare((NativeIndexKey)k1, (NativeIndexKey)k2);
            }
        };
    }
}

